/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.codeWithMe.ClientId;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.BooleanPropertyToggleAction;
import git4idea.GitProtectedBranchesKt;
import git4idea.actions.GitFetch;
import git4idea.actions.branch.GitBranchActionsUtil;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.i18n.GitBundleExtensions;
import git4idea.remote.GitConfigureRemotesDialogKt;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.BranchGroupingAction;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchesDashboardController;
import git4idea.ui.branch.dashboard.BranchesDashboardUi;
import git4idea.ui.branch.dashboard.BranchesDashboardUiKt;
import git4idea.ui.branch.dashboard.BranchesDataKeysKt;
import git4idea.ui.branch.dashboard.BranchesTreeComponent;
import git4idea.ui.branch.dashboard.NodeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b!\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u001f\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\""}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions;", "", "()V", "BranchActionsBuilder", "BranchesActionBase", "BranchesTreeActionGroup", "ChangeBranchFilterAction", "CheckoutSelectedBranchAction", "CurrentBranchActions", "DeleteBranchAction", "EditRemoteAction", "FetchAction", "GroupActions", "GroupBranchByDirectoryAction", "GroupBranchByRepositoryAction", "GroupingSettingsGroup", "HideBranchesAction", "LocalBranchActions", "MultipleGroupActions", "MultipleLocalBranchActions", "NavigateLogToBranchAction", "NavigateLogToSelectedBranchAction", "NewBranchAction", "RemoteActionBase", "RemoteBranchActions", "RemoteGlobalActions", "RemoveRemoteAction", "RenameLocalBranch", "ShowArbitraryBranchesDiffAction", "ShowBranchDiffAction", "ShowMyBranchesAction", "ToggleFavoriteAction", "UpdateBranchFilterInLogAction", "UpdateSelectedBranchAction", "intellij.vcs.git"})
public final class BranchesDashboardActions {
    @NotNull
    public static final BranchesDashboardActions INSTANCE = new BranchesDashboardActions();

    private BranchesDashboardActions() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchActionsBuilder;", "", "()V", "build", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchActionsBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,719:1\n1#2:720\n*E\n"})
    public static final class BranchActionsBuilder {
        @NotNull
        public static final BranchActionsBuilder INSTANCE = new BranchActionsBuilder();

        private BranchActionsBuilder() {
        }

        @RequiresBackgroundThread
        @Nullable
        public final ActionGroup build(@Nullable AnActionEvent e) {
            Set selectedBranchNodes;
            Set selectedRemotes;
            List selectedBranches;
            AnActionEvent anActionEvent = e;
            if (anActionEvent == null || (anActionEvent = anActionEvent.getProject()) == null) {
                return null;
            }
            AnActionEvent project = anActionEvent;
            List list2 = (List)e.getData(BranchesDataKeysKt.getGIT_BRANCHES());
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            boolean multipleBranchSelection = (selectedBranches = list2).size() > 1;
            GitRepository gitRepository = GitBranchUtil.guessWidgetRepository((Project)project, e.getDataContext());
            if (gitRepository == null) {
                return null;
            }
            GitRepository guessRepo = gitRepository;
            if (multipleBranchSelection) {
                return new MultipleLocalBranchActions();
            }
            BranchInfo branchInfo = (BranchInfo)CollectionsKt.singleOrNull((List)selectedBranches);
            List list3 = (List)e.getData(BranchesDataKeysKt.getGIT_BRANCH_FILTERS());
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            boolean headSelected = list3.contains("HEAD");
            if (branchInfo != null && !headSelected) {
                List<GitRepository> list4;
                Object object = e.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
                TreePath[] selectionPaths = object instanceof TreePath[] ? (TreePath[])object : null;
                List<GitRepository> list5 = CollectionsKt.toList((Iterable)BranchesTreeComponent.Companion.getSelectedRepositories$intellij_vcs_git(branchInfo, selectionPaths));
                if (list5.isEmpty()) {
                    boolean bl = false;
                    list4 = branchInfo.getRepositories();
                } else {
                    list4 = list5;
                }
                List selectedRepositories = list4;
                GitRepository gitRepository2 = (GitRepository)CollectionsKt.singleOrNull((List)selectedRepositories);
                if (gitRepository2 == null) {
                    gitRepository2 = guessRepo;
                }
                GitRepository selectedRepository = gitRepository2;
                return branchInfo.isCurrent() ? (ActionGroup)new CurrentBranchActions((Project)project, selectedRepositories, branchInfo.getBranchName(), selectedRepository) : (branchInfo.isLocal() ? (ActionGroup)new LocalBranchActions((Project)project, selectedRepositories, branchInfo.getBranchName(), selectedRepository) : (ActionGroup)new RemoteBranchActions((Project)project, selectedRepositories, branchInfo.getBranchName(), selectedRepository));
            }
            Set set = (Set)e.getData(BranchesDataKeysKt.getGIT_BRANCH_REMOTES());
            if (set == null) {
                set = SetsKt.emptySet();
            }
            if ((selectedRemotes = set).size() == 1) {
                return new GroupActions();
            }
            if (!((Collection)selectedRemotes).isEmpty()) {
                return new MultipleGroupActions();
            }
            Set set2 = (Set)e.getData(BranchesDataKeysKt.getGIT_BRANCH_DESCRIPTORS());
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            if ((selectedBranchNodes = set2).size() == 1 && ((BranchNodeDescriptor)CollectionsKt.first((Iterable)selectedBranchNodes)).getType() == NodeType.REMOTE_ROOT) {
                return new RemoteGlobalActions();
            }
            String currentBranchName = guessRepo.getCurrentBranchName();
            if (currentBranchName != null && headSelected) {
                return (ActionGroup)new CurrentBranchActions((Project)project, CollectionsKt.listOf((Object)guessRepo), currentBranchName, guessRepo);
            }
            return null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001BS\u0012\u001f\b\u0002\u0010\u0002\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\b0\u0003\u0012\u001f\b\u0002\u0010\t\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\n0\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016R%\u0010\t\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "description", "Sentence", "icon", "Ljavax/swing/Icon;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljavax/swing/Icon;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static abstract class BranchesActionBase
    extends DumbAwareAction {
        @NotNull
        private final Function0<String> description;

        public BranchesActionBase(@NotNull Function0<String> text2, @NotNull Function0<String> description2, @Nullable Icon icon) {
            Intrinsics.checkNotNullParameter(text2, (String)"text");
            Intrinsics.checkNotNullParameter(description2, (String)"description");
            super(() -> BranchesActionBase._init_$lambda$0(text2), () -> BranchesActionBase._init_$lambda$1(description2), icon);
            this.description = description2;
        }

        public /* synthetic */ BranchesActionBase(Function0 function0, Function0 function02, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function0 = 1.INSTANCE;
            }
            if ((n & 2) != 0) {
                function02 = 2.INSTANCE;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this((Function0<String>)function0, (Function0<String>)function02, icon);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches2, (String)"branches");
        }

        public void update(@NotNull AnActionEvent e) {
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesDashboardController controller = (BranchesDashboardController)e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            List branches2 = (List)e.getData(BranchesDataKeysKt.getGIT_BRANCHES());
            Project project = e.getProject();
            boolean enabled = project != null && controller != null && !((collection = (Collection)branches2) == null || collection.isEmpty());
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription((String)this.description.invoke());
            if (enabled) {
                Project project2 = project;
                Intrinsics.checkNotNull((Object)project2);
                List list2 = branches2;
                Intrinsics.checkNotNull((Object)list2);
                this.update(e, project2, list2);
            }
        }

        private static final String _init_$lambda$0(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke();
        }

        private static final String _init_$lambda$1(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke();
        }

        public BranchesActionBase() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesTreeActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class BranchesTreeActionGroup
    extends ActionGroup
    implements DumbAware {
        public BranchesTreeActionGroup() {
            this.getTemplatePresentation().setPopupGroup(true);
            this.getTemplatePresentation().setHideGroupIfEmpty(true);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ActionGroup actionGroup = BranchActionsBuilder.INSTANCE.build(e);
            Object object = actionGroup != null ? actionGroup.getChildren(e) : null;
            if (object == null) {
                object = AnAction.EMPTY_ARRAY;
                Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            }
            return object;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ChangeBranchFilterAction;", "Lcom/intellij/vcs/log/ui/actions/BooleanPropertyToggleAction;", "()V", "getProperty", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "", "setSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "state", "intellij.vcs.git"})
    public static final class ChangeBranchFilterAction
    extends BooleanPropertyToggleAction {
        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.setSelected(e, state2);
            ((VcsLogUiProperties)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)).set((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getNAVIGATE_LOG_TO_BRANCH_ON_BRANCH_SELECTION_PROPERTY(), (Object)false);
        }

        @NotNull
        protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
            return (VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getCHANGE_LOG_FILTER_ON_BRANCH_SELECTION_PROPERTY();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$CheckoutSelectedBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class CheckoutSelectedBranchAction
    extends BranchesActionBase {
        public CheckoutSelectedBranchAction() {
            super(null, null, null, 7, null);
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches2, (String)"branches");
            if (branches2.size() > 1) {
                e.getPresentation().setEnabled(false);
                return;
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            Object object = e.getData(BranchesDataKeysKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object);
            BranchInfo branchInfo = (BranchInfo)CollectionsKt.firstOrNull((List)((List)object));
            if (branchInfo == null) {
                return;
            }
            BranchInfo branch = branchInfo;
            Object object2 = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object2);
            BranchesDashboardController controller = (BranchesDashboardController)object2;
            List<GitRepository> repositories2 = controller.getSelectedRepositories(branch);
            if (branch.isLocal()) {
                GitBranchPopupActions.LocalBranchActions.CheckoutAction.checkoutBranch(project2, repositories2, branch.getBranchName());
            } else {
                GitBranchPopupActions.RemoteBranchActions.CheckoutRemoteBranchAction.checkoutRemoteBranch(project2, repositories2, branch.getBranchName());
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$CurrentBranchActions;", "Lgit4idea/ui/branch/GitBranchPopupActions$CurrentBranchActions;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branchName", "", "selectedRepository", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lgit4idea/repo/GitRepository;)V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$CurrentBranchActions\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,719:1\n37#2,2:720\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$CurrentBranchActions\n*L\n81#1:720,2\n*E\n"})
    public static final class CurrentBranchActions
    extends GitBranchPopupActions.CurrentBranchActions {
        public CurrentBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            Intrinsics.checkNotNullParameter((Object)selectedRepository, (String)"selectedRepository");
            super(project, repositories2, branchName, selectedRepository);
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = super.getChildren(e);
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
            AnAction[] anActionArray2 = anActionArray;
            ArrayList children = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(anActionArray2, anActionArray2.length));
            List list2 = this.myRepositories;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"myRepositories");
            if (MultiRootBranches.diverged((Collection)list2)) {
                children.add(1, new GitBranchPopupActions.LocalBranchActions.CheckoutAction(this.myProject, this.myRepositories, this.myBranchName));
            }
            Collection $this$toTypedArray$iv = children;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new AnAction[0]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\u0012"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$DeleteBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "delete", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "controller", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$DeleteBranchAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,719:1\n1747#2,3:720\n3190#2,10:723\n1179#2,2:733\n1253#2,4:735\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$DeleteBranchAction\n*L\n278#1:720,3\n295#1:723,10\n298#1:733,2\n298#1:735,4\n*E\n"})
    public static final class DeleteBranchAction
    extends BranchesActionBase {
        public DeleteBranchAction() {
            super(null, null, AllIcons.Actions.GC, 3, null);
            ShortcutSet[] shortcutSetArray = new ShortcutSet[]{KeymapUtil.getActiveKeymapShortcuts((String)"SafeDelete"), KeymapUtil.getActiveKeymapShortcuts((String)"EditorDeleteToLineStart")};
            this.setShortcutSet((ShortcutSet)new CompositeShortcutSet(shortcutSetArray));
        }

        @Override
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(branches2, (String)"branches");
                Object[] objectArray = new Object[]{branches2.size()};
                e.getPresentation().setText(GitBundle.message("action.Git.Delete.Branch.title", objectArray));
                Object object = e.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
                TreePath[] selectionPaths = object instanceof TreePath[] ? (TreePath[])object : null;
                Iterable $this$any$iv = branches2;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BranchInfo it = (BranchInfo)element$iv;
                        boolean bl2 = false;
                        if (!(it.isCurrent() || !it.isLocal() && GitProtectedBranchesKt.isRemoteBranchProtected((Collection<? extends GitRepository>)BranchesTreeComponent.Companion.getSelectedRepositories$intellij_vcs_git(it, selectionPaths), it.getBranchName()))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            boolean disabled = bl;
            e.getPresentation().setEnabled(!disabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getData(BranchesDataKeysKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object);
            List branches2 = (List)object;
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            Object object2 = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object2);
            BranchesDashboardController controller = (BranchesDashboardController)object2;
            this.delete(project2, branches2, controller);
        }

        /*
         * WARNING - void declaration
         */
        private final void delete(Project project, Collection<BranchInfo> branches2, BranchesDashboardController controller) {
            void $this$associateTo$iv$iv;
            GitBrancher gitBrancher = GitBrancher.getInstance(project);
            Iterable $this$partition$iv = branches2;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                BranchInfo it = (BranchInfo)element$iv;
                boolean bl2 = false;
                if (it.isLocal() && !it.isCurrent()) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List localBranches2 = (List)pair.component1();
            List remoteBranches2 = (List)pair.component2();
            GitBrancher $this$delete_u24lambda_u244 = gitBrancher;
            boolean bl = false;
            Iterable $this$associate$iv = localBranches2;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable bl2 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                BranchInfo it = (BranchInfo)element$iv$iv;
                boolean bl3 = false;
                Pair pair2 = TuplesKt.to((Object)it.getBranchName(), controller.getSelectedRepositories(it));
                map2.put(pair2.getFirst(), pair2.getSecond());
            }
            Map branchesToContainingRepositories = destination$iv$iv;
            Function0 deleteRemoteBranches2 = (Function0)new Function0<Unit>($this$delete_u24lambda_u244, (List<BranchInfo>)remoteBranches2){
                final /* synthetic */ GitBrancher $this_with;
                final /* synthetic */ List<BranchInfo> $remoteBranches;
                {
                    this.$this_with = $receiver;
                    this.$remoteBranches = $remoteBranches;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    BranchInfo p0;
                    Collection collection;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    Iterable iterable = this.$remoteBranches;
                    GitBrancher gitBrancher = this.$this_with;
                    boolean $i$f$map = false;
                    void var3_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        BranchInfo branchInfo = (BranchInfo)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(p0.getBranchName());
                    }
                    $this$map$iv = this.$remoteBranches;
                    collection = (List)destination$iv$iv;
                    boolean $i$f$flatMap = false;
                    $this$mapTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        p0 = (BranchInfo)element$iv$iv;
                        boolean bl = false;
                        Iterable list$iv$iv = p0.getRepositories();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv;
                    gitBrancher.deleteRemoteBranches((List<String>)collection, CollectionsKt.distinct((Iterable)list2));
                }
            };
            Set localBranchNames = branchesToContainingRepositories.keySet();
            if (!((Collection)localBranchNames).isEmpty()) {
                $this$delete_u24lambda_u244.deleteBranches(branchesToContainingRepositories, () -> DeleteBranchAction.delete$lambda$4$lambda$3(deleteRemoteBranches2));
            } else {
                deleteRemoteBranches2.invoke();
            }
        }

        private static final void delete$lambda$4$lambda$3(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0016J2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0016\u00a8\u0006\u000f"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$EditRemoteAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteActionBase;", "()V", "doAction", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selectedRemotes", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "update", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$EditRemoteAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,719:1\n43#2,3:720\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$EditRemoteAction\n*L\n562#1:720,3\n*E\n"})
    public static final class EditRemoteAction
    extends RemoteActionBase {
        public EditRemoteAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Log.Edit.Remote.text", new Object[0]), null, null, 6, null);
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            if (selectedRemotes.size() != 1) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        @Override
        public void doAction(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)selectedRemotes.entrySet());
            GitRepository repository = (GitRepository)entry.getKey();
            Set remotes = (Set)entry.getValue();
            boolean $i$f$service = false;
            Class<Git> serviceClass$iv = Git.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            GitConfigureRemotesDialogKt.editRemote$default((Git)object, repository, (GitRemote)CollectionsKt.first((Iterable)remotes), null, 8, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$FetchAction;", "Lgit4idea/actions/GitFetch;", "ui", "Lgit4idea/ui/branch/dashboard/BranchesDashboardUi;", "(Lgit4idea/ui/branch/dashboard/BranchesDashboardUi;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "onFetchFinished", "project", "Lcom/intellij/openapi/project/Project;", "result", "Lgit4idea/fetch/GitFetchResult;", "update", "intellij.vcs.git"})
    public static final class FetchAction
    extends GitFetch {
        @NotNull
        private final BranchesDashboardUi ui;

        public FetchAction(@NotNull BranchesDashboardUi ui) {
            Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
            this.ui = ui;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            e.getPresentation().setText(GitBundle.message("action.Git.Fetch.title", new Object[0]));
            e.getPresentation().setIcon(AllIcons.Vcs.Fetch);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.ui.startLoadingBranches();
            super.actionPerformed(e);
        }

        @Override
        protected void onFetchFinished(@NotNull Project project, @NotNull GitFetchResult result2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            this.ui.stopLoadingBranches();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupActions\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,719:1\n37#2,2:720\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupActions\n*L\n108#1:720,2\n*E\n"})
    public static final class GroupActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            Object[] objectArray = new AnAction[]{new EditRemoteAction(), new RemoveRemoteAction()};
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new AnAction[0]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByDirectoryAction;", "Lgit4idea/ui/branch/BranchGroupingAction;", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    public static final class GroupBranchByDirectoryAction
    extends BranchGroupingAction {
        public GroupBranchByDirectoryAction() {
            super(GroupingKey.GROUPING_BY_DIRECTORY, null, 2, null);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Supplier supplier = DvcsBundle.messagePointer((String)"action.text.branch.group.by.directory", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            Supplier groupByDirectory = supplier;
            Function0<String> groupingSeparator = GitBundleExtensions.INSTANCE.messagePointer("group.Git.Log.Branches.Grouping.Settings.text", new Object[0]);
            e.getPresentation().setText((String)(GroupBranchByRepositoryAction.Companion.isEnabledAndVisible(e) ? (String)groupByDirectory.get() : groupingSeparator.invoke() + " " + groupByDirectory.get()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByRepositoryAction;", "Lgit4idea/ui/branch/BranchGroupingAction;", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.vcs.git"})
    public static final class GroupBranchByRepositoryAction
    extends BranchGroupingAction {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public GroupBranchByRepositoryAction() {
            super(GroupingKey.GROUPING_BY_REPOSITORY, null, 2, null);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            e.getPresentation().setEnabledAndVisible(Companion.isEnabledAndVisible(e));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByRepositoryAction$Companion;", "", "()V", "isEnabledAndVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
        @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByRepositoryAction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,719:1\n1#2:720\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project = e.getProject();
                Project project2 = project;
                if (project == null) return false;
                Project project3 = project2;
                RepositoryChangesBrowserNode.Companion companion = RepositoryChangesBrowserNode.Companion;
                Project p0 = project3;
                boolean bl = false;
                VcsLogColorManager vcsLogColorManager = companion.getColorManager(p0);
                project2 = vcsLogColorManager;
                if (vcsLogColorManager == null) return false;
                boolean bl2 = project2.hasMultiplePaths();
                return bl2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupingSettingsGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    public static final class GroupingSettingsGroup
    extends DefaultActionGroup
    implements DumbAware {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setPopupGroup(GroupBranchByRepositoryAction.Companion.isEnabledAndVisible(e));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$HideBranchesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.vcs.git"})
    public static final class HideBranchesAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            e.getPresentation().setEnabledAndVisible(properties != null && properties.exists((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY()));
            super.update(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            if (properties != null && properties.exists((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY())) {
                properties.set((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY(), (Object)false);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$LocalBranchActions;", "Lgit4idea/ui/branch/GitBranchPopupActions$LocalBranchActions;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branchName", "", "selectedRepository", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lgit4idea/repo/GitRepository;)V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$LocalBranchActions\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,719:1\n37#2,2:720\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$LocalBranchActions\n*L\n92#1:720,2\n*E\n"})
    public static final class LocalBranchActions
    extends GitBranchPopupActions.LocalBranchActions {
        public LocalBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            Intrinsics.checkNotNullParameter((Object)selectedRepository, (String)"selectedRepository");
            super(project, repositories2, branchName, selectedRepository);
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = super.getChildren(e);
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
            AnAction[] anActionArray2 = anActionArray;
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(anActionArray2, anActionArray2.length));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new AnAction[0]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$MultipleGroupActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$MultipleGroupActions\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,719:1\n37#2,2:720\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$MultipleGroupActions\n*L\n114#1:720,2\n*E\n"})
    public static final class MultipleGroupActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            Object[] objectArray = new AnAction[]{new RemoveRemoteAction()};
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new AnAction[0]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$MultipleLocalBranchActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class MultipleLocalBranchActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new ShowArbitraryBranchesDiffAction(), new UpdateSelectedBranchAction(), new DeleteBranchAction()};
            return anActionArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$NavigateLogToBranchAction;", "Lcom/intellij/vcs/log/ui/actions/BooleanPropertyToggleAction;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getProperty", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "", "isSelected", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.vcs.git"})
    public static final class NavigateLogToBranchAction
    extends BooleanPropertyToggleAction {
        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return super.isSelected(e) && (Boolean)((VcsLogUiProperties)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)).get((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getCHANGE_LOG_FILTER_ON_BRANCH_SELECTION_PROPERTY()) == false;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.setSelected(e, state2);
            ((VcsLogUiProperties)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)).set((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getCHANGE_LOG_FILTER_ON_BRANCH_SELECTION_PROPERTY(), (Object)false);
        }

        @NotNull
        protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
            return (VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getNAVIGATE_LOG_TO_BRANCH_ON_BRANCH_SELECTION_PROPERTY();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$NavigateLogToSelectedBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.vcs.git"})
    public static final class NavigateLogToSelectedBranchAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean visible;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesDashboardController uiController = (BranchesDashboardController)e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Project project = e.getProject();
            boolean bl = visible = project != null && uiController != null;
            if (!visible) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            List branchFilters = (List)e.getData(BranchesDataKeysKt.getGIT_BRANCH_FILTERS());
            e.getPresentation().setEnabled(branchFilters != null && branchFilters.size() == 1);
            e.getPresentation().setVisible(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ((BranchesDashboardController)e.getRequiredData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER())).navigateLogToSelectedBranch();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$NewBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$NewBranchAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,719:1\n1360#2:720\n1446#2,5:721\n1360#2:726\n1446#2,5:727\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$NewBranchAction\n*L\n194#1:720\n194#1:721,5\n210#1:726\n210#1:727,5\n*E\n"})
    public static final class NewBranchAction
    extends BranchesActionBase {
        public NewBranchAction() {
            super((Function0<String>)((Function0)1.INSTANCE), (Function0<String>)((Function0)2.INSTANCE), com.intellij.dvcs.ui.NewBranchAction.icon);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            List branchFilters = (List)e.getData(BranchesDataKeysKt.getGIT_BRANCH_FILTERS());
            if (branchFilters != null && branchFilters.contains("HEAD")) {
                e.getPresentation().setEnabled(true);
            } else {
                super.update(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches2, (String)"branches");
            if (branches2.size() > 1) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(GitBundle.message("action.Git.New.Branch.description", new Object[0]));
                return;
            }
            Object object = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object);
            BranchesDashboardController controller = (BranchesDashboardController)object;
            Iterable $this$flatMap$iv = branches2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BranchInfo p0 = (BranchInfo)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = controller.getSelectedRepositories(p0);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List repositories2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, (List)repositories2, (String)DvcsBundle.message((String)"action.not.possible.in.fresh.repo.new.branch", (Object[])new Object[0]));
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            List branchFilters = (List)e.getData(BranchesDataKeysKt.getGIT_BRANCH_FILTERS());
            if (branchFilters != null && branchFilters.contains("HEAD")) {
                List<GitRepository> list2 = GitRepositoryManager.getInstance(project2).getRepositories();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getRepositories(...)");
                List<GitRepository> repositories2 = list2;
                GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project2, repositories2, "HEAD", null, MultiRootBranches.getCommonCurrentBranch((Collection)repositories2), 8, null);
            } else {
                void $this$flatMapTo$iv$iv;
                Object object = e.getData(BranchesDataKeysKt.getGIT_BRANCHES());
                Intrinsics.checkNotNull((Object)object);
                List branches2 = (List)object;
                Object object2 = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
                Intrinsics.checkNotNull((Object)object2);
                BranchesDashboardController controller = (BranchesDashboardController)object2;
                Iterable $this$flatMap$iv = branches2;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    BranchInfo p0 = (BranchInfo)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = controller.getSelectedRepositories(p0);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List repositories3 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                BranchInfo branchInfo = (BranchInfo)CollectionsKt.first((List)branches2);
                String branchName = branchInfo.getBranchName();
                String string = branchName + "^0";
                Object[] objectArray = new Object[]{branchName};
                String string2 = GitBundle.message("action.Git.New.Branch.dialog.title", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                GitBranchActionsUtilKt.createOrCheckoutNewBranch(project2, repositories3, string, string2, GitBranchActionsUtil.calculateNewBranchInitialName(branchName, !branchInfo.isLocal()));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001BQ\u0012\u001d\u0010\u0002\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\b0\u0003\u0012\u001f\b\u0002\u0010\t\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\n0\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J2\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016H&J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J2\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016H\u0016R%\u0010\t\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "description", "Sentence", "icon", "Ljavax/swing/Icon;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljavax/swing/Icon;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doAction", "project", "Lcom/intellij/openapi/project/Project;", "selectedRemotes", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.vcs.git"})
    public static abstract class RemoteActionBase
    extends DumbAwareAction {
        @NotNull
        private final Function0<String> description;

        public RemoteActionBase(@NotNull Function0<String> text2, @NotNull Function0<String> description2, @Nullable Icon icon) {
            Intrinsics.checkNotNullParameter(text2, (String)"text");
            Intrinsics.checkNotNullParameter(description2, (String)"description");
            super(() -> RemoteActionBase._init_$lambda$0(text2), () -> RemoteActionBase._init_$lambda$1(description2), icon);
            this.description = description2;
        }

        public /* synthetic */ RemoteActionBase(Function0 function0, Function0 function02, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                function02 = 1.INSTANCE;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this((Function0<String>)function0, (Function0<String>)function02, icon);
        }

        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
        }

        public abstract void doAction(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull Map<GitRepository, ? extends Set<GitRemote>> var3);

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Object selectedRemotes;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            BranchesDashboardController controller = (BranchesDashboardController)e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Object object = controller;
            if (object == null || (object = ((BranchesDashboardController)object).getSelectedRemotes()) == null) {
                object = selectedRemotes = MapsKt.emptyMap();
            }
            boolean enabled = project != null && !selectedRemotes.isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription((String)this.description.invoke());
            if (enabled) {
                Project project2 = project;
                Intrinsics.checkNotNull((Object)project2);
                this.update(e, project2, (Map<GitRepository, ? extends Set<GitRemote>>)selectedRemotes);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            Object object = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object);
            BranchesDashboardController controller = (BranchesDashboardController)object;
            Map<GitRepository, Set<GitRemote>> selectedRemotes = controller.getSelectedRemotes();
            this.doAction(e, project2, selectedRemotes);
        }

        private static final String _init_$lambda$0(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke();
        }

        private static final String _init_$lambda$1(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteBranchActions;", "Lgit4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branchName", "", "selectedRepository", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lgit4idea/repo/GitRepository;)V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteBranchActions\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,719:1\n37#2,2:720\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteBranchActions\n*L\n102#1:720,2\n*E\n"})
    public static final class RemoteBranchActions
    extends GitBranchPopupActions.RemoteBranchActions {
        public RemoteBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NonNls @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            Intrinsics.checkNotNullParameter((Object)selectedRepository, (String)"selectedRepository");
            super(project, repositories2, branchName, selectedRepository);
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = super.getChildren(e);
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
            AnAction[] anActionArray2 = anActionArray;
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(anActionArray2, anActionArray2.length));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new AnAction[0]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteGlobalActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteGlobalActions\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,719:1\n37#2,2:720\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteGlobalActions\n*L\n120#1:720,2\n*E\n"})
    public static final class RemoteGlobalActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            Object[] objectArray = new AnAction[1];
            Intrinsics.checkNotNullExpressionValue((Object)ActionManager.getInstance().getAction("Git.Configure.Remotes"), (String)"getAction(...)");
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new AnAction[0]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0016J2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0016\u00a8\u0006\u000f"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoveRemoteAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteActionBase;", "()V", "doAction", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selectedRemotes", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "update", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoveRemoteAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,719:1\n43#2,3:720\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoveRemoteAction\n*L\n547#1:720,3\n*E\n"})
    public static final class RemoveRemoteAction
    extends RemoteActionBase {
        public RemoveRemoteAction() {
            Object[] objectArray = new Object[]{0};
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Log.Remove.Remote.text", objectArray), null, null, 6, null);
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            Object[] objectArray = new Object[]{selectedRemotes.size()};
            e.getPresentation().setText(GitBundle.message("action.Git.Log.Remove.Remote.text", objectArray));
        }

        @Override
        public void doAction(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            for (Map.Entry<GitRepository, ? extends Set<GitRemote>> entry : selectedRemotes.entrySet()) {
                GitRepository repository = entry.getKey();
                Set<GitRemote> remotes = entry.getValue();
                boolean $i$f$service = false;
                Class<Git> serviceClass$iv = Git.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                GitConfigureRemotesDialogKt.removeRemotes$default((Git)object, repository, remotes, null, 8, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RenameLocalBranch;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$RenameLocalBranch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,719:1\n1747#2,3:720\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$RenameLocalBranch\n*L\n704#1:720,3\n*E\n"})
    public static final class RenameLocalBranch
    extends BranchesActionBase {
        public RenameLocalBranch() {
            super(null, null, null, 7, null);
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            block10: {
                block9: {
                    boolean bl;
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter(branches2, (String)"branches");
                        if (branches2.size() > 1) {
                            e.getPresentation().setEnabled(false);
                            return;
                        }
                        BranchInfo branch = (BranchInfo)CollectionsKt.first((Iterable)branches2);
                        Object object = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
                        Intrinsics.checkNotNull((Object)object);
                        BranchesDashboardController controller = (BranchesDashboardController)object;
                        List<GitRepository> repositories2 = controller.getSelectedRepositories(branch);
                        if (!branch.isLocal()) break block9;
                        Iterable $this$any$iv = repositories2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Repository p0 = (Repository)element$iv;
                                boolean bl2 = false;
                                if (!p0.isFresh()) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block10;
                }
                e.getPresentation().setEnabled(false);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            Object object = e.getData(BranchesDataKeysKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object);
            BranchInfo branchInfo = (BranchInfo)CollectionsKt.firstOrNull((List)((List)object));
            if (branchInfo == null) {
                return;
            }
            BranchInfo branch = branchInfo;
            Object object2 = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object2);
            BranchesDashboardController controller = (BranchesDashboardController)object2;
            List<GitRepository> repositories2 = controller.getSelectedRepositories(branch);
            GitBranchPopupActions.LocalBranchActions.RenameBranchAction.rename(project2, repositories2, branch.getBranchName());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowArbitraryBranchesDiffAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "commonRepositories", "Lgit4idea/repo/GitRepository;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "branchOne", "branchTwo", "intellij.vcs.git"})
    public static final class ShowArbitraryBranchesDiffAction
    extends BranchesActionBase {
        public ShowArbitraryBranchesDiffAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Compare.Selected.title", new Object[0]), null, AllIcons.Actions.Diff, 2, null);
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches2, (String)"branches");
            if (branches2.size() != 2) {
                e.getPresentation().setEnabledAndVisible(false);
                e.getPresentation().setDescription("");
            } else {
                e.getPresentation().setDescription(GitBundle.message("action.Git.Compare.Selected.description", new Object[0]));
                BranchInfo branchOne = (BranchInfo)CollectionsKt.elementAt((Iterable)branches2, (int)0);
                BranchInfo branchTwo = (BranchInfo)CollectionsKt.elementAt((Iterable)branches2, (int)1);
                Object object = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
                Intrinsics.checkNotNull((Object)object);
                BranchesDashboardController controller = (BranchesDashboardController)object;
                if (Intrinsics.areEqual((Object)branchOne.getBranchName(), (Object)branchTwo.getBranchName()) || this.commonRepositories(controller, branchOne, branchTwo).isEmpty()) {
                    e.getPresentation().setEnabled(false);
                    e.getPresentation().setDescription(GitBundle.message("action.Git.Compare.Selected.description.disabled", new Object[0]));
                }
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object);
            BranchesDashboardController controller = (BranchesDashboardController)object;
            Object object2 = e.getData(BranchesDataKeysKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object2);
            List branches2 = (List)object2;
            BranchInfo branchOne = (BranchInfo)branches2.get(0);
            BranchInfo branchTwo = (BranchInfo)branches2.get(1);
            Collection<GitRepository> commonRepositories = this.commonRepositories(controller, branchOne, branchTwo);
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            GitBrancher.getInstance(project).compareAny(branchOne.getBranchName(), branchTwo.getBranchName(), CollectionsKt.toList((Iterable)commonRepositories));
        }

        private final Collection<GitRepository> commonRepositories(BranchesDashboardController $this$commonRepositories, BranchInfo branchOne, BranchInfo branchTwo) {
            return CollectionsKt.intersect((Iterable)$this$commonRepositories.getSelectedRepositories(branchOne), (Iterable)$this$commonRepositories.getSelectedRepositories(branchTwo));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowBranchDiffAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowBranchDiffAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,719:1\n2624#2,3:720\n819#2:723\n847#2,2:724\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowBranchDiffAction\n*L\n322#1:720,3\n334#1:723\n334#1:724,2\n*E\n"})
    public static final class ShowBranchDiffAction
    extends BranchesActionBase {
        public ShowBranchDiffAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Compare.With.Current.title", new Object[0]), null, AllIcons.Actions.Diff, 2, null);
            this.setShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"Diff.ShowDiff"));
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(branches2, (String)"branches");
                Iterable $this$none$iv = branches2;
                boolean $i$f$none = false;
                if (((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        BranchInfo it = (BranchInfo)element$iv;
                        boolean bl2 = false;
                        if (!(!it.isCurrent())) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (bl) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(GitBundle.message("action.Git.Update.Selected.description.select.non.current", new Object[0]));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object);
            BranchesDashboardController controller = (BranchesDashboardController)object;
            Object object2 = e.getData(BranchesDataKeysKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object2);
            List branches2 = (List)object2;
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            GitBrancher gitBrancher = GitBrancher.getInstance(project2);
            Iterable $this$filterNot$iv = branches2;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                BranchInfo p0 = (BranchInfo)element$iv$iv;
                boolean bl = false;
                if (p0.isCurrent()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (BranchInfo branch : (List)destination$iv$iv) {
                gitBrancher.compare(branch.getBranchName(), controller.getSelectedRepositories(branch));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowMyBranchesAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "uiController", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "(Lgit4idea/ui/branch/dashboard/BranchesDashboardController;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowMyBranchesAction\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,719:1\n167#2,3:720\n1726#3,3:723\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowMyBranchesAction\n*L\n396#1:720,3\n402#1:723,3\n*E\n"})
    public static final class ShowMyBranchesAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final BranchesDashboardController uiController;

        public ShowMyBranchesAction(@NotNull BranchesDashboardController uiController) {
            Intrinsics.checkNotNullParameter((Object)uiController, (String)"uiController");
            super(() -> ShowMyBranchesAction._init_$lambda$0(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Show.My.Branches.title", new Object[0])), AllIcons.Actions.Find);
            this.uiController = uiController;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return this.uiController.getShowOnlyMy();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.uiController.setShowOnlyMy(state2);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            boolean isGraphReady;
            boolean supportsIndexing;
            block10: {
                boolean bl2;
                VcsProjectLog log;
                Project project;
                block9: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.update(e);
                    project = (Project)e.getData(CommonDataKeys.PROJECT);
                    if (project == null) {
                        e.getPresentation().setEnabled(false);
                        return;
                    }
                    log = VcsProjectLog.Companion.getInstance(project);
                    Object object = log.getDataManager();
                    if (object != null && (object = object.getLogProviders()) != null) {
                        Object $this$all$iv = object;
                        boolean $i$f$all = false;
                        if ($this$all$iv.isEmpty()) {
                            bl2 = true;
                        } else {
                            Iterator iterator = $this$all$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry element$iv;
                                Map.Entry it = element$iv = iterator.next();
                                boolean bl3 = false;
                                Object object2 = VcsLogProperties.SUPPORTS_INDEXING.getOrDefault((VcsLogProvider)it.getValue());
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrDefault(...)");
                                if (((Boolean)object2).booleanValue()) continue;
                                bl2 = false;
                                break block9;
                            }
                            bl2 = true;
                        }
                    } else {
                        bl2 = false;
                    }
                }
                supportsIndexing = bl2;
                VcsLogData vcsLogData = log.getDataManager();
                isGraphReady = vcsLogData != null && (vcsLogData = vcsLogData.getDataPack()) != null ? vcsLogData.isFull() : false;
                List<GitRepository> list2 = GitRepositoryManager.getInstance(project).getRepositories();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getRepositories(...)");
                Iterable $this$all$iv = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl4 = false;
                        VcsLogData vcsLogData2 = log.getDataManager();
                        if (vcsLogData2 != null && (vcsLogData2 = vcsLogData2.getIndex()) != null ? vcsLogData2.isIndexed(it.getRoot()) : false) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            boolean allRootsIndexed = bl;
            e.getPresentation().setEnabled(supportsIndexing && isGraphReady && allRootsIndexed);
            e.getPresentation().setDescription(!supportsIndexing ? GitBundle.message("action.Git.Show.My.Branches.description.not.support.indexing", new Object[0]) : (!allRootsIndexed ? GitBundle.message("action.Git.Show.My.Branches.description.not.all.roots.indexed", new Object[0]) : (!isGraphReady ? GitBundle.message("action.Git.Show.My.Branches.description.not.graph.ready", new Object[0]) : GitBundle.message("action.Git.Show.My.Branches.description.is.my.branch", new Object[0]))));
        }

        private static final String _init_$lambda$0(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ToggleFavoriteAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ToggleFavoriteAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,719:1\n30#2,3:720\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ToggleFavoriteAction\n*L\n447#1:720,3\n*E\n"})
    public static final class ToggleFavoriteAction
    extends BranchesActionBase {
        public ToggleFavoriteAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Toggle.Favorite.title", new Object[0]), null, AllIcons.Nodes.Favorite, 2, null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            Object object = e.getData(BranchesDataKeysKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object);
            List branches2 = (List)object;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            GitBranchManager gitBranchManager = (GitBranchManager)((Object)object2);
            for (BranchInfo branch : branches2) {
                GitBranchType type = branch.isLocal() ? GitBranchType.LOCAL : GitBranchType.REMOTE;
                Object object3 = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
                Intrinsics.checkNotNull((Object)object3);
                BranchesDashboardController controller = (BranchesDashboardController)object3;
                List<GitRepository> repositories2 = controller.getSelectedRepositories(branch);
                for (GitRepository repository : repositories2) {
                    gitBranchManager.setFavorite(type, repository, branch.getBranchName(), !branch.isFavorite());
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$UpdateBranchFilterInLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.vcs.git"})
    public static final class UpdateBranchFilterInLogAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            boolean enabled = e.getProject() != null && e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER()) != null && !((collection = (Collection)e.getData(BranchesDataKeysKt.getGIT_BRANCH_FILTERS())) == null || collection.isEmpty()) && e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) instanceof BranchesTreeComponent;
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ((BranchesDashboardController)e.getRequiredData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER())).updateLogBranchFilter();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$UpdateSelectedBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$UpdateSelectedBranchAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,719:1\n1#2:720\n1360#3:721\n1446#3,5:722\n1549#3:727\n1620#3,3:728\n1360#3:731\n1446#3,5:732\n1549#3:737\n1620#3,3:738\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$UpdateSelectedBranchAction\n*L\n241#1:721\n241#1:722,5\n242#1:727\n242#1:728,3\n256#1:731\n256#1:732,5\n257#1:737\n257#1:738,3\n*E\n"})
    public static final class UpdateSelectedBranchAction
    extends BranchesActionBase {
        public UpdateSelectedBranchAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Update.Selected.text", new Object[0]), null, AllIcons.Actions.CheckOut, 2, null);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project != null) {
                Project p0 = project;
                boolean bl2 = false;
                bl = GitBranchActionsUtilKt.hasRemotes(p0);
            } else {
                bl = false;
            }
            boolean enabledAndVisible = bl;
            e.getPresentation().setEnabledAndVisible(enabledAndVisible);
            if (enabledAndVisible) {
                super.update(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches2, (String)"branches");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            Presentation presentation2 = presentation;
            if (GitFetchSupport.fetchSupport(project).isFetchRunning()) {
                presentation2.setEnabled(false);
                presentation2.setDescription(GitBundle.message("action.Git.Update.Selected.description.already.running", new Object[0]));
                return;
            }
            Object object = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object);
            BranchesDashboardController controller = (BranchesDashboardController)object;
            Iterable $this$flatMap$iv = branches2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BranchInfo p0 = (BranchInfo)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = controller.getSelectedRepositories(p0);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List repositories2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv = branches2;
            boolean $i$f$map22 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                BranchInfo bl = (BranchInfo)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(p0.getBranchName());
            }
            List branchNames = (List)destination$iv$iv2;
            String string = GitVcsSettings.getInstance(project).getUpdateMethod().name().toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String updateMethodName = string;
            Object[] $i$f$map22 = new Object[]{branches2.size(), updateMethodName};
            presentation2.setDescription(GitBundle.message("action.Git.Update.Selected.description", $i$f$map22));
            boolean trackingInfosExist = GitBranchActionsUtilKt.isTrackingInfosExist(branchNames, repositories2);
            presentation2.setEnabled(trackingInfosExist);
            if (!trackingInfosExist) {
                Object[] objectArray = new Object[]{branches2.size()};
                presentation2.setDescription(GitBundle.message("action.Git.Update.Selected.description.tracking.not.configured", objectArray));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getData(BranchesDataKeysKt.getGIT_BRANCHES());
            Intrinsics.checkNotNull((Object)object);
            List branches2 = (List)object;
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            Object object2 = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object2);
            BranchesDashboardController controller = (BranchesDashboardController)object2;
            Iterable $this$flatMap$iv = branches2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BranchInfo p0 = (BranchInfo)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = controller.getSelectedRepositories(p0);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List repositories2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv = branches2;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                BranchInfo bl = (BranchInfo)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(p0.getBranchName());
            }
            List branchNames = (List)destination$iv$iv2;
            GitBranchActionsUtilKt.updateBranches(project2, repositories2, branchNames);
        }
    }
}

