/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.rebase.GitHandlerRebaseEditorManager;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaseUtils;
import git4idea.update.GitUpdateResult;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitRebaser {
    private static final Logger LOG = Logger.getInstance(GitRebaser.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final List<GitRebaseUtils.CommitInfo> mySkippedCommits;

    public GitRebaser(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator) {
        if (project == null) {
            GitRebaser.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitRebaser.$$$reportNull$$$0(1);
        }
        if (progressIndicator == null) {
            GitRebaser.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myGit = git;
        this.myProgressIndicator = progressIndicator;
        this.myVcs = GitVcs.getInstance(project);
        this.mySkippedCommits = new ArrayList<GitRebaseUtils.CommitInfo>();
    }

    public GitUpdateResult rebase(@NotNull VirtualFile root, @NotNull List<String> parameters) {
        GitUpdateResult gitUpdateResult;
        block10: {
            if (root == null) {
                GitRebaser.$$$reportNull$$$0(3);
            }
            if (parameters == null) {
                GitRebaser.$$$reportNull$$$0(4);
            }
            GitLineHandler rebaseHandler = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
            rebaseHandler.setStdoutSuppressed(false);
            rebaseHandler.addParameters(parameters);
            GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
            rebaseHandler.addLineListener(rebaseConflictDetector);
            GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
            GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
            rebaseHandler.addLineListener(untrackedFilesDetector);
            rebaseHandler.addLineListener(localChangesDetector);
            rebaseHandler.addLineListener(GitStandardProgressAnalyzer.createListener(this.myProgressIndicator));
            AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message("activity.name.rebase", new Object[0]));
            try {
                String oldText = this.myProgressIndicator.getText();
                this.myProgressIndicator.setText(GitBundle.message("rebase.progress.indicator.title", new Object[0]));
                GitCommandResult result2 = this.myGit.runCommand(rebaseHandler);
                this.myProgressIndicator.setText(oldText);
                GitUpdateResult gitUpdateResult2 = gitUpdateResult = result2.success() ? GitUpdateResult.SUCCESS : this.handleRebaseFailure(rebaseHandler, root, result2, rebaseConflictDetector, untrackedFilesDetector, localChangesDetector);
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessCanceledException pce) {
                    return GitUpdateResult.CANCEL;
                }
            }
            ignore.close();
        }
        return gitUpdateResult;
    }

    public void abortRebase(@NotNull VirtualFile root) {
        if (root == null) {
            GitRebaser.$$$reportNull$$$0(5);
        }
        LOG.info("abortRebase " + root);
        GitLineHandler rh = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
        rh.setStdoutSuppressed(false);
        rh.addParameters("--abort");
        String oldText = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText(GitBundle.message("rebase.update.project.abort.task.title", new Object[0]));
        GitCommandResult commandResult = this.myGit.runCommand(rh);
        this.myProgressIndicator.setText(oldText);
        if (commandResult.success()) {
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess("git.rebase.abort", "", GitBundle.message("rebase.update.project.notification.abort.success.message", new Object[0]));
        } else {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("git.rebase.abort", "", GitBundle.message("rebase.update.project.notification.abort.error.message", new Object[0]));
        }
        this.myProgressIndicator.setText2(GitBundle.message("progress.details.refreshing.files.for.root", root.getPath()));
        root.refresh(false, true);
    }

    public boolean continueRebase(@NotNull VirtualFile root) {
        if (root == null) {
            GitRebaser.$$$reportNull$$$0(6);
        }
        return this.continueRebase(root, false);
    }

    private boolean skipCommitAndContinue(@NotNull VirtualFile root) {
        if (root == null) {
            GitRebaser.$$$reportNull$$$0(7);
        }
        return this.continueRebase(root, true);
    }

    public boolean continueRebase(@NotNull Collection<? extends VirtualFile> rebasingRoots) {
        if (rebasingRoots == null) {
            GitRebaser.$$$reportNull$$$0(8);
        }
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message("activity.name.rebase", new Object[0]));){
            boolean success = true;
            for (VirtualFile virtualFile : rebasingRoots) {
                success &= this.continueRebase(virtualFile);
            }
            boolean bl = success;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean continueRebase(@NotNull VirtualFile root, boolean skip) {
        if (root == null) {
            GitRebaser.$$$reportNull$$$0(9);
        }
        LOG.info(String.format("continueRebase in %s, skip: %s", root, skip));
        GitLineHandler rh = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
        rh.setStdoutSuppressed(false);
        rh.addParameters(skip ? "--skip" : "--continue");
        GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
        rh.addLineListener(rebaseConflictDetector);
        rh.addLineListener(GitStandardProgressAnalyzer.createListener(this.myProgressIndicator));
        TrivialEditor editor2 = new TrivialEditor();
        try (GitHandlerRebaseEditorManager ignored = GitHandlerRebaseEditorManager.prepareEditor(rh, editor2);){
            String oldText = this.myProgressIndicator.getText();
            this.myProgressIndicator.setText(GitBundle.message("rebase.progress.indicator.title", new Object[0]));
            GitCommandResult result2 = this.myGit.runCommand(rh);
            this.myProgressIndicator.setText(oldText);
            if (result2.success()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.handleRebaseContinueFailure(root, result2, rebaseConflictDetector);
            return bl;
        }
        catch (ProcessCanceledException pce) {
            return false;
        }
    }

    @NotNull
    public Collection<VirtualFile> getRebasingRoots() {
        HashSet<VirtualFile> rebasingRoots = new HashSet<VirtualFile>();
        for (VirtualFile root : ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)this.myVcs)) {
            if (!GitRebaseUtils.isRebaseInTheProgress(this.myProject, root)) continue;
            rebasingRoots.add(root);
        }
        HashSet<VirtualFile> hashSet = rebasingRoots;
        if (hashSet == null) {
            GitRebaser.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    private boolean handleRebaseContinueFailure(final VirtualFile root, @NotNull GitCommandResult commandResult, @NotNull GitRebaseProblemDetector rebaseConflictDetector) {
        if (commandResult == null) {
            GitRebaser.$$$reportNull$$$0(11);
        }
        if (rebaseConflictDetector == null) {
            GitRebaser.$$$reportNull$$$0(12);
        }
        if (rebaseConflictDetector.isMergeConflict()) {
            LOG.info("handleRebaseFailure merge conflict");
            return new GitConflictResolver(this.myProject, Collections.singleton(root), GitRebaser.makeParams(this.myProject)){

                @Override
                protected boolean proceedIfNothingToMerge() {
                    this.notifyUnresolvedRemain();
                    return false;
                }

                @Override
                protected boolean proceedAfterAllMerged() {
                    return GitRebaser.this.continueRebase(root);
                }
            }.merge();
        }
        if (rebaseConflictDetector.isNoChangeError()) {
            LOG.info("handleRebaseFailure no changes error detected");
            try {
                if (GitUtil.hasLocalChanges(true, this.myProject, root)) {
                    LOG.error("The rebase detector incorrectly detected 'no changes' situation. Attempting to continue rebase.");
                    return this.continueRebase(root);
                }
                if (GitUtil.hasLocalChanges(false, this.myProject, root)) {
                    LOG.warn("No changes from patch were not added to the index. Adding all changes from tracked files.");
                    this.stageEverything(root);
                    return this.continueRebase(root);
                }
                GitRebaseUtils.CommitInfo commit = GitRebaseUtils.getCurrentRebaseCommit(this.myProject, root);
                LOG.info("no changes confirmed. Skipping commit " + commit);
                this.mySkippedCommits.add(commit);
                return this.skipCommitAndContinue(root);
            }
            catch (VcsException e) {
                LOG.info("Failed to work around 'no changes' error.", (Throwable)e);
                VcsNotifier.getInstance((Project)this.myProject).notifyError("git.rebase.update.project.error", GitBundle.message("rebase.update.project.notification.failed.title", new Object[0]), GitBundle.message("rebase.update.project.notification.failed.message", e.getMessage()));
                return false;
            }
        }
        List errors = ContainerUtil.map(GitRebaser.collectErrorOutputLines(commandResult), it -> new VcsException(it));
        LOG.info("handleRebaseFailure error");
        VcsNotifier.getInstance((Project)this.myProject).notifyError("git.rebase.update.project.error", GitBundle.message("rebase.update.project.notification.failed.title", new Object[0]), "", (Collection)errors);
        return false;
    }

    private static @NotNull List<@NlsSafe String> collectErrorOutputLines(@NotNull GitCommandResult result2) {
        if (result2 == null) {
            GitRebaser.$$$reportNull$$$0(13);
        }
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(ContainerUtil.filter(result2.getOutput(), line -> GitHandlerUtil.isErrorLine(line.trim())));
        errors.addAll(ContainerUtil.filter(result2.getErrorOutput(), line -> GitHandlerUtil.isErrorLine(line.trim())));
        if (errors.isEmpty() && !result2.success()) {
            errors.addAll(result2.getErrorOutput());
            if (errors.isEmpty()) {
                List<String> output = result2.getOutput();
                String lastOutput = (String)ContainerUtil.findLast(output, line -> !StringUtil.isEmptyOrSpaces((String)line));
                List<String> list2 = Collections.singletonList(lastOutput);
                if (list2 == null) {
                    GitRebaser.$$$reportNull$$$0(14);
                }
                return list2;
            }
        }
        ArrayList<String> arrayList = errors;
        if (arrayList == null) {
            GitRebaser.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private void stageEverything(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            GitRebaser.$$$reportNull$$$0(16);
        }
        GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.ADD);
        handler.setSilent(false);
        handler.addParameters("--update");
        this.myGit.runCommand(handler).throwOnError(new int[0]);
    }

    @NotNull
    private static GitConflictResolver.Params makeParams(@NotNull Project project) {
        if (project == null) {
            GitRebaser.$$$reportNull$$$0(17);
        }
        GitConflictResolver.Params params = new GitConflictResolver.Params(project).setReverse(true).setErrorNotificationTitle(GitBundle.message("rebase.update.project.conflict.error.notification.title", new Object[0])).setMergeDescription(GitBundle.message("rebase.update.project.conflict.merge.description.label", new Object[0])).setErrorNotificationAdditionalDescription(GitBundle.message("rebase.update.project.conflict.error.notification.description", new Object[0]));
        if (params == null) {
            GitRebaser.$$$reportNull$$$0(18);
        }
        return params;
    }

    @NotNull
    public GitUpdateResult handleRebaseFailure(@NotNull GitLineHandler handler, @NotNull VirtualFile root, @NotNull GitCommandResult result2, @NotNull GitRebaseProblemDetector rebaseConflictDetector, @NotNull GitMessageWithFilesDetector untrackedWouldBeOverwrittenDetector, @NotNull GitLocalChangesWouldBeOverwrittenDetector localChangesDetector) {
        if (handler == null) {
            GitRebaser.$$$reportNull$$$0(19);
        }
        if (root == null) {
            GitRebaser.$$$reportNull$$$0(20);
        }
        if (result2 == null) {
            GitRebaser.$$$reportNull$$$0(21);
        }
        if (rebaseConflictDetector == null) {
            GitRebaser.$$$reportNull$$$0(22);
        }
        if (untrackedWouldBeOverwrittenDetector == null) {
            GitRebaser.$$$reportNull$$$0(23);
        }
        if (localChangesDetector == null) {
            GitRebaser.$$$reportNull$$$0(24);
        }
        if (rebaseConflictDetector.isMergeConflict()) {
            LOG.info("handleRebaseFailure merge conflict");
            boolean allMerged = new ConflictResolver(this.myProject, this.myGit, root, this).merge();
            GitUpdateResult gitUpdateResult = allMerged ? GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS : GitUpdateResult.INCOMPLETE;
            if (gitUpdateResult == null) {
                GitRebaser.$$$reportNull$$$0(25);
            }
            return gitUpdateResult;
        }
        if (untrackedWouldBeOverwrittenDetector.wasMessageDetected()) {
            LOG.info("handleRebaseFailure: untracked files would be overwritten by checkout");
            GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, root, untrackedWouldBeOverwrittenDetector.getRelativeFilePaths(), GitBundle.message("rebase.operation.name", new Object[0]), null);
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                GitRebaser.$$$reportNull$$$0(26);
            }
            return gitUpdateResult;
        }
        if (localChangesDetector.wasMessageDetected()) {
            LocalChangesWouldBeOverwrittenHelper.showErrorNotification(this.myProject, "git.merge.local.changes.detected", root, GitBundle.message("rebase.git.operation.name", new Object[0]), localChangesDetector.getRelativeFilePaths());
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                GitRebaser.$$$reportNull$$$0(27);
            }
            return gitUpdateResult;
        }
        LOG.info("handleRebaseFailure error");
        VcsNotifier.getInstance((Project)this.myProject).notifyError("git.rebase.update.project.error", GitBundle.message("rebase.update.project.notification.failed.title", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
        GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
        if (gitUpdateResult == null) {
            GitRebaser.$$$reportNull$$$0(28);
        }
        return gitUpdateResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14, 15, 18, 25, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebasingRoots";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaser";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandResult";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseConflictDetector";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untrackedWouldBeOverwrittenDetector";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localChangesDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaser";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRebasingRoots";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectErrorOutputLines";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "makeParams";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "handleRebaseFailure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rebase";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "abortRebase";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "continueRebase";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipCommitAndContinue";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleRebaseContinueFailure";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectErrorOutputLines";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "stageEverything";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "makeParams";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "handleRebaseFailure";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14, 15, 18, 25, 26, 27, 28 -> new IllegalStateException(string);
        };
    }

    public static class TrivialEditor
    implements GitRebaseEditorHandler {
        @Override
        public int editCommits(@NotNull File file2) {
            if (file2 == null) {
                TrivialEditor.$$$reportNull$$$0(0);
            }
            return 0;
        }

        @Override
        public boolean wasCommitListEditorCancelled() {
            return false;
        }

        @Override
        public boolean wasUnstructuredEditorCancelled() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/rebase/GitRebaser$TrivialEditor", "editCommits"));
        }
    }

    public static class ConflictResolver
    extends GitConflictResolver {
        @NotNull
        private final GitRebaser myRebaser;
        @NotNull
        private final VirtualFile myRoot;

        public ConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull VirtualFile root, @NotNull GitRebaser rebaser) {
            if (project == null) {
                ConflictResolver.$$$reportNull$$$0(0);
            }
            if (git == null) {
                ConflictResolver.$$$reportNull$$$0(1);
            }
            if (root == null) {
                ConflictResolver.$$$reportNull$$$0(2);
            }
            if (rebaser == null) {
                ConflictResolver.$$$reportNull$$$0(3);
            }
            super(project, Collections.singleton(root), GitRebaser.makeParams(project));
            this.myRebaser = rebaser;
            this.myRoot = root;
        }

        @Override
        protected boolean proceedIfNothingToMerge() {
            return this.myRebaser.continueRebase(this.myRoot);
        }

        @Override
        protected boolean proceedAfterAllMerged() {
            return this.myRebaser.continueRebase(this.myRoot);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "git";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rebaser";
                    break;
                }
            }
            objectArray[1] = "git4idea/rebase/GitRebaser$ConflictResolver";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

