/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import git4idea.GitBranch;
import git4idea.actions.branch.GitSingleBranchAction;
import git4idea.branch.GitBrancher;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J.\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lgit4idea/actions/branch/GitRebaseBranchAction;", "Lgit4idea/actions/branch/GitSingleBranchAction;", "()V", "disabledForCurrent", "", "getDisabledForCurrent", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branch", "Lgit4idea/GitBranch;", "updateIfEnabledAndVisible", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRebaseBranchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRebaseBranchAction.kt\ngit4idea/actions/branch/GitRebaseBranchAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1726#2,3:38\n*S KotlinDebug\n*F\n+ 1 GitRebaseBranchAction.kt\ngit4idea/actions/branch/GitRebaseBranchAction\n*L\n23#1:38,3\n*E\n"})
public final class GitRebaseBranchAction
extends GitSingleBranchAction {
    private final boolean disabledForCurrent;

    public GitRebaseBranchAction() {
        Supplier<String> supplier = GitBundle.messagePointer("branches.rebase.current.onto.selected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        super(supplier);
        this.disabledForCurrent = true;
    }

    @Override
    public boolean getDisabledForCurrent() {
        return this.disabledForCurrent;
    }

    @Override
    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull GitBranch branch) {
        String string;
        boolean bl;
        Presentation $this$updateIfEnabledAndVisible_u24lambda_u241;
        block5: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            $this$updateIfEnabledAndVisible_u24lambda_u241 = e.getPresentation();
            boolean bl2 = false;
            Object[] objectArray = new Object[]{GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, (Collection<? extends GitRepository>)repositories2), GitBranchPopupActions.getSelectedBranchTruncatedPresentation(project, branch.getName())};
            $this$updateIfEnabledAndVisible_u24lambda_u241.setText(GitBundle.message("branches.rebase.onto", objectArray));
            Iterable $this$all$iv = repositories2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl3 = false;
                    if (it.isOnBranch()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        boolean isOnBranch = bl;
        $this$updateIfEnabledAndVisible_u24lambda_u241.setEnabled(isOnBranch);
        if (isOnBranch) {
            Object[] objectArray = new Object[]{GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories2), GitBranchPopupActions.getSelectedBranchFullPresentation(branch.getName())};
            string = GitBundle.message("branches.rebase.onto", objectArray);
        } else {
            string = GitBundle.message("branches.rebase.is.not.possible.in.the.detached.head.state", new Object[0]);
        }
        $this$updateIfEnabledAndVisible_u24lambda_u241.setDescription(string);
        GitBranchPopupActions.addTooltipText($this$updateIfEnabledAndVisible_u24lambda_u241, $this$updateIfEnabledAndVisible_u24lambda_u241.getDescription());
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        GitBrancher.getInstance(project).rebase(repositories2, branch.getName());
    }
}

