/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsUser;
import git4idea.GitVcs;
import git4idea.config.GitConfigUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitUserRegistry
implements Disposable,
VcsMappingListener {
    private static final Logger LOG = Logger.getInstance(GitUserRegistry.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, VcsUser> myUserMap;

    public GitUserRegistry(@NotNull Project project) {
        if (project == null) {
            GitUserRegistry.$$$reportNull$$$0(0);
        }
        this.myUserMap = new ConcurrentHashMap<VirtualFile, VcsUser>();
        this.myProject = project;
    }

    public static GitUserRegistry getInstance(@NotNull Project project) {
        if (project == null) {
            GitUserRegistry.$$$reportNull$$$0(1);
        }
        return (GitUserRegistry)project.getService(GitUserRegistry.class);
    }

    public void activate() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        this.directoryMappingChanged();
    }

    @Nullable
    public VcsUser getUser(@NotNull VirtualFile root) {
        if (root == null) {
            GitUserRegistry.$$$reportNull$$$0(2);
        }
        return this.myUserMap.get(root);
    }

    @Nullable
    public VcsUser getOrReadUser(@NotNull VirtualFile root) {
        VcsUser user;
        if (root == null) {
            GitUserRegistry.$$$reportNull$$$0(3);
        }
        if ((user = this.myUserMap.get(root)) == null && (user = this.readUser(root)) != null) {
            this.myUserMap.put(root, user);
        }
        return user;
    }

    @Nullable
    public VcsUser readUser(@NotNull VirtualFile root) {
        if (root == null) {
            GitUserRegistry.$$$reportNull$$$0(4);
        }
        try {
            return GitUserRegistry.readCurrentUser(this.myProject, root);
        }
        catch (VcsException e) {
            LOG.warn("Could not retrieve user name in " + root, (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static VcsUser readCurrentUser(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            GitUserRegistry.$$$reportNull$$$0(5);
        }
        if (root == null) {
            GitUserRegistry.$$$reportNull$$$0(6);
        }
        String userName = StringUtil.nullize((String)GitConfigUtil.getValue(project, root, "user.name"));
        String userEmail = StringUtil.notNullize((String)GitConfigUtil.getValue(project, root, "user.email"));
        return userName == null ? null : ((VcsLogObjectsFactory)project.getService(VcsLogObjectsFactory.class)).createUser(userName, userEmail);
    }

    public void dispose() {
        this.myUserMap.clear();
    }

    public void directoryMappingChanged() {
        Object[] roots = ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)GitVcs.getInstance(this.myProject));
        List rootsToCheck = ContainerUtil.filter((Object[])roots, root -> this.getUser((VirtualFile)root) == null);
        if (!rootsToCheck.isEmpty()) {
            Runnable task = () -> {
                for (VirtualFile root : rootsToCheck) {
                    this.getOrReadUser(root);
                }
            };
            BackgroundTaskUtil.executeOnPooledThread((Disposable)this, (Runnable)task);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "git4idea/GitUserRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getUser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrReadUser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readUser";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readCurrentUser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

