/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ssh.ui.unified.SshExtendedCredentialsForm;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SshEntityConfigurable
extends NamedConfigurable<SshUiData> {
    protected final SshExtendedCredentialsForm myForm;
    @NotNull
    private final SshUiData myItem;
    @NlsSafe
    private String myCustomName;
    private final Disposable myDisposable;
    private boolean myRequestFocusOnSelection;

    SshEntityConfigurable(@NotNull SshUiData item, boolean isNameEditable, @Nullable Runnable updateTree, boolean showOnlyAppLevel) {
        if (item == null) {
            SshEntityConfigurable.$$$reportNull$$$0(0);
        }
        super(isNameEditable, updateTree);
        this.myDisposable = Disposer.newDisposable((String)"SshEntityConfigurable");
        this.myItem = item;
        this.myForm = this.createFormConfigurable(this.myItem, showOnlyAppLevel, updateTree, this.myDisposable);
    }

    @NotNull
    protected SshExtendedCredentialsForm createFormConfigurable(SshUiData item, boolean showOnlyAppLevel, @Nullable Runnable updateTree, @NotNull Disposable disposable) {
        if (disposable == null) {
            SshEntityConfigurable.$$$reportNull$$$0(1);
        }
        return new SshExtendedCredentialsForm(item, showOnlyAppLevel, updateTree, disposable);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myForm.getPanel());
        scrollPane.setBorder(IdeBorderFactory.createEmptyBorder((Insets)JBInsets.emptyInsets()));
        return scrollPane;
    }

    @NotNull
    public SshUiData getEditableObject() {
        SshUiData sshUiData = this.myItem;
        if (sshUiData == null) {
            SshEntityConfigurable.$$$reportNull$$$0(2);
        }
        return sshUiData;
    }

    public String getBannerSlogan() {
        return this.myItem.getConfig().getPresentableFullName();
    }

    public String getDisplayName() {
        return this.myCustomName != null ? this.myCustomName : this.myItem.getConfig().getPresentableFullName();
    }

    public void setDisplayName(String name) {
        throw new IllegalStateException("Ssh configs are not designed to rename");
    }

    public boolean isModified() {
        return this.myForm.isModified() || this.myCustomName != null && !this.myCustomName.equals(this.myItem.getName());
    }

    public void apply() throws ConfigurationException {
        this.myForm.apply();
        if (this.myCustomName != null) {
            this.myItem.getConfig().setCustomName(this.myCustomName);
            this.myCustomName = null;
        }
    }

    public void reset() {
        this.myForm.reset();
        this.myCustomName = null;
    }

    void setCustomName(@Nullable String customName) {
        this.myCustomName = customName;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    @NotNull
    public SshUiData applyToNewDefaultSshDataIfPossible(boolean isUiInitialized) {
        SshUiData clone = this.myItem.clone();
        if (isUiInitialized) {
            this.myForm.applyTo(clone);
            if (this.myCustomName != null) {
                clone.getConfig().setCustomName(this.myCustomName);
            }
        }
        SshUiData sshUiData = clone;
        if (sshUiData == null) {
            SshEntityConfigurable.$$$reportNull$$$0(3);
        }
        return sshUiData;
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    boolean isRequestFocusOnSelection() {
        return this.myRequestFocusOnSelection;
    }

    void setRequestFocusOnSelection(boolean requestFocusOnSelection) {
        this.myRequestFocusOnSelection = requestFocusOnSelection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/unified/SshEntityConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/unified/SshEntityConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToNewDefaultSshDataIfPossible";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFormConfigurable";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

