/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.google.common.net.HostAndPort;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.ssh.ChannelSshTransportException;
import com.intellij.ssh.ExecChannelConfig;
import com.intellij.ssh.SftpChannelConfig;
import com.intellij.ssh.ShellChannelConfig;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSessionChannelFactory;
import com.intellij.ssh.SshTunnelAlreadyRegisteredException;
import com.intellij.ssh.X11Forwarding;
import com.intellij.ssh.channels.ExecChannel;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.channels.ShellChannel;
import com.intellij.ssh.channels.SshChannel;
import com.intellij.ssh.config.EnvironmentVariable;
import com.intellij.ssh.config.OpenSshConfigForwardInfo;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.channels.PatchedSftpChannel;
import com.intellij.ssh.impl.sshj.channels.PatchedShellChannel;
import com.intellij.ssh.impl.sshj.channels.SshjExecChannel;
import com.intellij.ssh.impl.sshj.channels.SshjSftpChannel;
import com.intellij.ssh.impl.sshj.channels.SshjShellChannel;
import com.intellij.ssh.impl.sshj.tunnels.LocalForwarderCollection;
import com.intellij.ssh.impl.sshj.tunnels.RemoteForwarderCollection;
import com.intellij.util.SmartList;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.connection.channel.direct.PatchedExecChannel;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0014H\u0016J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0014H\u0016J \u0010\"\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0014H\u0016J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0014H\u0016J \u0010#\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0014H\u0016J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0014H\u0016J\b\u0010%\u001a\u00020\u001dH\u0016J\b\u0010&\u001a\u00020\u001dH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0017\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010!\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b-J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00070/H\u0016J+\u00100\u001a\u0002H1\"\b\b\u0000\u00101*\u0002022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H104H\u0016\u00a2\u0006\u0002\u00105J\u0018\u00106\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u00106\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u00107\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010)\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010)\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020\u0007H\u0016J\u0010\u0010B\u001a\u00020\u001d2\u0006\u00109\u001a\u00020:H\u0002J\"\u0010C\u001a\u0002HD\"\u0004\b\u0000\u0010D2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002HD0FH\u0082\b\u00a2\u0006\u0002\u0010GR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\r\u00a8\u0006H"}, d2={"Lcom/intellij/ssh/impl/sshj/SshjSshConnection;", "Lcom/intellij/ssh/SshSessionChannelFactory;", "connectionConfig", "Lcom/intellij/ssh/config/SshConnectionConfig;", "sshjBackend", "Lnet/schmizz/sshj/SSHClient;", "userName", "", "executor", "Ljava/util/concurrent/ExecutorService;", "(Lcom/intellij/ssh/config/SshConnectionConfig;Lnet/schmizz/sshj/SSHClient;Ljava/lang/String;Ljava/util/concurrent/ExecutorService;)V", "host", "getHost", "()Ljava/lang/String;", "isConnected", "", "()Z", "localForwarders", "Lcom/intellij/ssh/impl/sshj/tunnels/LocalForwarderCollection;", "port", "", "getPort", "()I", "remoteForwarders", "Lcom/intellij/ssh/impl/sshj/tunnels/RemoteForwarderCollection;", "getSshjBackend$intellij_platform_ssh", "()Lnet/schmizz/sshj/SSHClient;", "getUserName", "addLocalTunnel", "", "localAddress", "Ljava/net/InetAddress;", "localPort", "remotePort", "addLocalTunnelWithRandomLocalPort", "addRemoteTunnel", "addRemoteTunnelWithRandomRemotePort", "applyPortForwardings", "disconnect", "execChannel", "Lcom/intellij/ssh/channels/ExecChannel;", "channelConfig", "Lcom/intellij/ssh/ExecChannelConfig;", "getLocalTunnel", "Lcom/google/common/net/HostAndPort;", "getLocalTunnel$intellij_platform_ssh", "getPortForwardingList", "", "openChannel", "C", "Lcom/intellij/ssh/channels/SshChannel;", "channelCreator", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Lcom/intellij/ssh/channels/SshChannel;", "removeLocalTunnel", "removeRemoteTunnel", "sendEnvironmentVariables", "channel", "Lnet/schmizz/sshj/connection/channel/direct/Session;", "sftpChannel", "Lcom/intellij/ssh/channels/SftpChannel;", "Lcom/intellij/ssh/SftpChannelConfig;", "shellChannel", "Lcom/intellij/ssh/channels/ShellChannel;", "Lcom/intellij/ssh/ShellChannelConfig;", "toString", "tryMakeX11Forwarding", "wrapStartSessionErrors", "T", "handler", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshjSshConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshjSshConnection.kt\ncom/intellij/ssh/impl/sshj/SshjSshConnection\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n*L\n1#1,270:1\n260#1,6:271\n260#1,6:277\n260#1,6:283\n83#2,18:289\n*S KotlinDebug\n*F\n+ 1 SshjSshConnection.kt\ncom/intellij/ssh/impl/sshj/SshjSshConnection\n*L\n74#1:271,6\n121#1:277,6\n132#1:283,6\n208#1:289,18\n*E\n"})
public final class SshjSshConnection
implements SshSessionChannelFactory {
    @NotNull
    private final SshConnectionConfig connectionConfig;
    @NotNull
    private final SSHClient sshjBackend;
    @NotNull
    private final String userName;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final LocalForwarderCollection localForwarders;
    @NotNull
    private final RemoteForwarderCollection remoteForwarders;

    public SshjSshConnection(@NotNull SshConnectionConfig connectionConfig, @NotNull SSHClient sshjBackend, @NotNull String userName, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)connectionConfig, (String)"connectionConfig");
        Intrinsics.checkNotNullParameter((Object)sshjBackend, (String)"sshjBackend");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.connectionConfig = connectionConfig;
        this.sshjBackend = sshjBackend;
        this.userName = userName;
        this.executor = executor;
        this.localForwarders = new LocalForwarderCollection(this.sshjBackend, this.toString());
        this.remoteForwarders = new RemoteForwarderCollection(this.sshjBackend, this.toString());
    }

    @NotNull
    public final SSHClient getSshjBackend$intellij_platform_ssh() {
        return this.sshjBackend;
    }

    @Override
    @NotNull
    public String getUserName() {
        return this.userName;
    }

    @Override
    @NotNull
    public String getHost() {
        String string = this.sshjBackend.getRemoteHostname();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRemoteHostname(...)");
        return string;
    }

    @Override
    public int getPort() {
        return this.sshjBackend.getRemotePort();
    }

    @Override
    @NotNull
    public <C extends SshChannel> C openChannel(@NotNull Function1<? super SshSessionChannelFactory, ? extends C> channelCreator) {
        Intrinsics.checkNotNullParameter(channelCreator, (String)"channelCreator");
        try {
            return (C)((SshChannel)channelCreator.invoke((Object)this));
        }
        catch (SshException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SshException(String.valueOf(e.getMessage()), e, new Attachment[0]);
        }
        catch (IllegalStateException e) {
            throw Intrinsics.areEqual((Object)e.getMessage(), (Object)"Not connected") ? (Throwable)((Object)new ChannelSshTransportException(e)) : (Throwable)e;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.valueOf(e.getMessage()), e);
        }
    }

    @Override
    @NotNull
    public ExecChannel execChannel(@NotNull ExecChannelConfig channelConfig) {
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        PatchedExecChannel channel2 = new PatchedExecChannel(this.sshjBackend);
        SshjSshConnection this_$iv = this;
        boolean $i$f$wrapStartSessionErrors = false;
        try {
            boolean bl = false;
            channel2.open();
            Unit unit = Unit.INSTANCE;
        }
        catch (OpenFailException e$iv) {
            throw new ChannelSshTransportException(e$iv);
        }
        this.sendEnvironmentVariables((Session)channel2);
        if (channelConfig.isPty()) {
            channel2.allocateDefaultPTY();
        }
        channel2.setRedirectingStderr$intellij_platform_ssh(channelConfig.getRedirectErrorStream());
        this.tryMakeX11Forwarding((Session)channel2);
        if (this.connectionConfig.getForwardAgent()) {
            channel2.sendAgentForwardingRequest();
        }
        Session.Command cmd = channel2.exec(channelConfig.getCommand());
        Intrinsics.checkNotNull((Object)cmd);
        return new SshjExecChannel(this, cmd, channelConfig.isPty());
    }

    private final void sendEnvironmentVariables(Session channel2) {
        for (EnvironmentVariable.Certain certain : UtilKt.certainVariables(this.connectionConfig.getEnvironmentVariables())) {
            String name = certain.component1();
            String value = certain.component2();
            try {
                channel2.setEnvVar(name, value);
            }
            catch (ConnectionException err) {
                UtilKt.getSSHJ_LOG().warn("Failed to send environment variable " + name, (Throwable)err);
            }
        }
    }

    private final void tryMakeX11Forwarding(Session channel2) {
        block4: {
            X11Forwarding x11Forwarding2 = this.connectionConfig.getX11Forwarding();
            if (x11Forwarding2 == null) break block4;
            X11Forwarding x11forwarding = x11Forwarding2;
            boolean bl = false;
            try {
                Unit unit;
                String string = x11forwarding.makeMitMagicCookie();
                if (string != null) {
                    String cookie2 = string;
                    boolean bl2 = false;
                    channel2.reqX11Forwarding("MIT-MAGIC-COOKIE-1", cookie2, x11forwarding.getScreen());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            catch (Throwable error2) {
                UtilKt.getSSHJ_LOG().warn("Failed to set up " + x11forwarding + " in " + this, error2);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Override
    @NotNull
    public SftpChannel sftpChannel(@NotNull SftpChannelConfig channelConfig) {
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        PatchedSftpChannel channel2 = new PatchedSftpChannel(this, channelConfig);
        SshjSshConnection this_$iv = this;
        boolean $i$f$wrapStartSessionErrors = false;
        try {
            boolean bl = false;
            channel2.open();
            Unit unit = Unit.INSTANCE;
        }
        catch (OpenFailException e$iv) {
            throw new ChannelSshTransportException(e$iv);
        }
        SFTPEngine sftpEngine2 = new SFTPEngine(new SessionFactory(this, channel2){
            final /* synthetic */ SshjSshConnection this$0;
            final /* synthetic */ PatchedSftpChannel $channel;
            {
                this.this$0 = $receiver;
                this.$channel = $channel;
            }

            @NotNull
            public InetSocketAddress getRemoteSocketAddress() {
                InetSocketAddress inetSocketAddress = this.this$0.getSshjBackend$intellij_platform_ssh().getRemoteSocketAddress();
                Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress, (String)"getRemoteSocketAddress(...)");
                return inetSocketAddress;
            }

            @NotNull
            public Session startSession() {
                return (Session)this.$channel;
            }
        });
        SFTPClient sftpClient = new SFTPClient(sftpEngine2.init());
        return new SshjSftpChannel(this, (Channel)channel2, sftpClient);
    }

    @Override
    @NotNull
    public ShellChannel shellChannel(@NotNull ShellChannelConfig channelConfig) {
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        PatchedShellChannel channel2 = new PatchedShellChannel(this.sshjBackend);
        SshjSshConnection this_$iv = this;
        boolean $i$f$wrapStartSessionErrors = false;
        try {
            boolean bl = false;
            channel2.open();
            Unit unit = Unit.INSTANCE;
        }
        catch (OpenFailException e$iv) {
            throw new ChannelSshTransportException(e$iv);
        }
        this.sendEnvironmentVariables((Session)channel2);
        if (channelConfig.isPty()) {
            channel2.allocatePTY("xterm-256color", 80, 24, 0, 0, MapsKt.emptyMap());
        }
        try {
            channel2.setEnvVar("LANG", "en_US.UTF-8");
        }
        catch (ConnectionException e) {
            UtilKt.getSSHJ_LOG().warn("Failed to set remote env variable LANG for " + this + ": " + e);
        }
        this.tryMakeX11Forwarding((Session)channel2);
        if (this.connectionConfig.getForwardAgent()) {
            channel2.sendAgentForwardingRequest();
        }
        return new SshjShellChannel(this, (Session)channel2);
    }

    @Override
    public boolean isConnected() {
        return this.sshjBackend.isConnected();
    }

    @Override
    public void addRemoteTunnel(int remotePort, @NotNull String host2, int localPort) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        this.remoteForwarders.create("localhost", localPort, host2, remotePort);
    }

    @Override
    public int addRemoteTunnelWithRandomRemotePort(@NotNull String host2, int localPort) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        return this.remoteForwarders.createWithRandomRemotePort("", localPort, host2);
    }

    @Override
    public void addLocalTunnel(int localPort, @NotNull String host2, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        this.localForwarders.create("localhost", localPort, host2, remotePort);
    }

    @Override
    public int addLocalTunnelWithRandomLocalPort(@NotNull String host2, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        return this.localForwarders.createForFreePort("localhost", host2, remotePort);
    }

    @Override
    public void removeLocalTunnel(int port2) {
        this.localForwarders.remove("localhost", port2);
    }

    @Override
    public void addLocalTunnel(@NotNull InetAddress localAddress, int localPort, @NotNull String host2, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        this.localForwarders.create(localAddress, localPort, host2, remotePort);
    }

    @Override
    public int addLocalTunnelWithRandomLocalPort(@NotNull InetAddress localAddress, @NotNull String host2, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        return this.localForwarders.createForFreePort(localAddress, host2, remotePort);
    }

    @Override
    public void removeLocalTunnel(@NotNull InetAddress localAddress, int port2) {
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        this.localForwarders.remove(localAddress, port2);
    }

    @Override
    public void removeRemoteTunnel(int port2) {
        this.remoteForwarders.remove("localhost", port2);
    }

    @Override
    @NotNull
    public List<String> getPortForwardingList() {
        List<String> result2 = this.localForwarders.get();
        result2.addAll((Collection<String>)this.remoteForwarders.get());
        return CollectionsKt.sorted((Iterable)result2);
    }

    @Override
    public void disconnect() {
        UtilKt.getSSHJ_LOG().debug("Disconnecting " + this);
        KeepAlive keepAlive = this.sshjBackend.getConnection().getKeepAlive();
        try {
            Object[] objectArray = new Function0[5];
            objectArray[0] = new Function0<Unit>((Object)this.executor){

                public final void invoke() {
                    ((ExecutorService)this.receiver).shutdown();
                }
            };
            Intrinsics.checkNotNull((Object)keepAlive);
            objectArray[1] = new Function0<Unit>((Object)keepAlive){

                public final void invoke() {
                    ((KeepAlive)this.receiver).interrupt();
                }
            };
            objectArray[2] = new Function0<Unit>((Object)this.localForwarders){

                public final void invoke() {
                    ((LocalForwarderCollection)this.receiver).close();
                }
            };
            objectArray[3] = new Function0<Unit>((Object)this.sshjBackend){

                public final void invoke() {
                    ((SSHClient)this.receiver).close();
                }
            };
            objectArray[4] = new Function0<Unit>(keepAlive){
                final /* synthetic */ KeepAlive $keepAlive;
                {
                    this.$keepAlive = $keepAlive;
                    super(0);
                }

                public final void invoke() {
                    this.$keepAlive.join(1000L);
                }
            };
            Collection $this$forEachGuaranteed$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEachGuaranteed = false;
            Iterator $this$forEachGuaranteed$iv$iv = $this$forEachGuaranteed$iv.iterator();
            boolean $i$f$forEachGuaranteed2 = false;
            List errors$iv$iv = null;
            Iterator iterator = $this$forEachGuaranteed$iv$iv;
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                try {
                    Function0 it = (Function0)element$iv$iv;
                    boolean bl = false;
                    it.invoke();
                }
                catch (Throwable e$iv$iv) {
                    if (errors$iv$iv == null) {
                        errors$iv$iv = (List)new SmartList();
                    }
                    errors$iv$iv.add(e$iv$iv);
                }
            }
            CompoundRuntimeException.throwIfNotEmpty(errors$iv$iv);
        }
        catch (Throwable error2) {
            UtilKt.getSSHJ_LOG().info("Got an error while disconnecting " + this + ": " + error2);
        }
    }

    @Override
    public void applyPortForwardings() {
        for (OpenSshConfigForwardInfo localForwarding : this.connectionConfig.getInitialLocalTcpForwardings()) {
            try {
                this.localForwarders.create(localForwarding.getBindHost(), localForwarding.getBindPort(), localForwarding.getHost(), localForwarding.getPort());
            }
            catch (SshTunnelAlreadyRegisteredException sshTunnelAlreadyRegisteredException) {
            }
            catch (Exception e) {
                UtilKt.getSSHJ_LOG().error("Can't apply local forwarding from config: " + localForwarding, (Throwable)e);
            }
        }
        for (OpenSshConfigForwardInfo remoteForwarding : this.connectionConfig.getInitialRemoteTcpForwardings()) {
            try {
                this.remoteForwarders.create(remoteForwarding.getBindHost(), remoteForwarding.getBindPort(), remoteForwarding.getHost(), remoteForwarding.getPort());
            }
            catch (SshTunnelAlreadyRegisteredException e) {
            }
            catch (Exception e) {
                UtilKt.getSSHJ_LOG().error("Can't apply remote forwarding from config: " + remoteForwarding, (Throwable)e);
            }
        }
    }

    @Nullable
    public final HostAndPort getLocalTunnel$intellij_platform_ssh(int remotePort) {
        return this.localForwarders.getLocalAddressForRemotePort(remotePort);
    }

    @NotNull
    public String toString() {
        return "SshjSshConnection(" + this.getUserName() + "@" + this.getHost() + ")@" + UtilKt.hexId(this);
    }

    private final <T> T wrapStartSessionErrors(Function0<? extends T> handler) {
        Object object;
        boolean $i$f$wrapStartSessionErrors = false;
        try {
            object = handler.invoke();
        }
        catch (OpenFailException e) {
            throw new ChannelSshTransportException(e);
        }
        return (T)object;
    }
}

