/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.ChannelSshTransportException;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshSessionChannelFactory;
import com.intellij.ssh.channels.SshChannel;
import com.intellij.ssh.impl.SshConnection;
import com.intellij.ssh.impl.sshj.SshjConnectionUtilKt;
import com.intellij.ssh.impl.sshj.SshjSshConnection;
import com.intellij.ssh.ui.SshConnectionStateListener;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 42\u00020\u0001:\u00014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u000eH\u0007J\u000e\u0010 \u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010#\u001a\u00020\u001bJ\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0&J\u000e\u0010'\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ1\u0010(\u001a\u0002H)\"\b\b\u0000\u0010)*\u00020*2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H)0,\u00a2\u0006\u0002\u0010-J,\u0010.\u001a\u0002H/\"\u0004\b\u0000\u0010/2\b\u00100\u001a\u0004\u0018\u00010\u00152\f\u00101\u001a\b\u0012\u0004\u0012\u0002H/02H\u0082\b\u00a2\u0006\u0002\u00103R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u00a8\u00065"}, d2={"Lcom/intellij/ssh/impl/SshConnection;", "", "userName", "", "host", "port", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "allSessions", "Ljava/util/ArrayList;", "Lcom/intellij/ssh/SshSession;", "disposeLock", "Ljava/util/concurrent/locks/ReentrantLock;", "disposed", "", "getHost", "()Ljava/lang/String;", "getPort", "()I", "progressIndicatorOfInstantiatingConnections", "", "Lcom/intellij/openapi/progress/ProgressIndicator;", "serveLock", "sessions", "Lcom/intellij/ssh/SshSessionChannelFactory;", "getUserName", "assertNotDisposed", "", "checkCanAuthenticate", "sessionConfig", "Lcom/intellij/ssh/SessionConfig;", "addToPool", "connect", "createSession", "createSshSessionForSshj", "dispose", "doSshjSshConnection", "getSessions", "", "getSshSession", "openChannel", "R", "Lcom/intellij/ssh/channels/SshChannel;", "channelCreator", "Lkotlin/Function1;", "(Lcom/intellij/ssh/SessionConfig;Lkotlin/jvm/functions/Function1;)Lcom/intellij/ssh/channels/SshChannel;", "withServeLockInterruptible", "T", "progressIndicator", "handler", "Lkotlin/Function0;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "intellij.platform.ssh"})
public final class SshConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String userName;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final ArrayList<SshSessionChannelFactory> sessions;
    @NotNull
    private final ArrayList<SshSession> allSessions;
    @NotNull
    private final ReentrantLock serveLock;
    @NotNull
    private final ReentrantLock disposeLock;
    @NotNull
    private final Set<ProgressIndicator> progressIndicatorOfInstantiatingConnections;
    private volatile boolean disposed;
    @NotNull
    private static final Logger LOG;

    public SshConnection(@NotNull String userName, @NotNull String host2, int port2) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        this.userName = userName;
        this.host = host2;
        this.port = port2;
        this.sessions = new ArrayList();
        this.allSessions = new ArrayList();
        this.serveLock = new ReentrantLock();
        this.disposeLock = new ReentrantLock();
        Set set = Collections.newSetFromMap(ContainerUtil.createConcurrentWeakMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        this.progressIndicatorOfInstantiatingConnections = set;
    }

    @NotNull
    public final String getUserName() {
        return this.userName;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final <R extends SshChannel> R openChannel(@NotNull SessionConfig sessionConfig, @NotNull Function1<? super SshSessionChannelFactory, ? extends R> channelCreator) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter(channelCreator, (String)"channelCreator");
        return (R)((SshChannel)Ssh.wrapBlockingSshCall$default(null, false, new Function0<R>(this, sessionConfig, channelCreator){
            final /* synthetic */ SshConnection this$0;
            final /* synthetic */ SessionConfig $sessionConfig;
            final /* synthetic */ Function1<SshSessionChannelFactory, R> $channelCreator;
            {
                this.this$0 = $receiver;
                this.$sessionConfig = $sessionConfig;
                this.$channelCreator = $channelCreator;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final R invoke() {
                Pair pair;
                void this_$iv;
                ((SshConnectionService.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionService.Companion.getTOPIC())).sessionOrChannelRequested(this.this$0.getUserName(), this.this$0.getHost(), this.this$0.getPort());
                SshConnection sshConnection = this.this$0;
                ProgressIndicator progressIndicator2 = this.$sessionConfig.getProgressIndicator();
                SshConnection sshConnection2 = this.this$0;
                Function1<SshSessionChannelFactory, R> function1 = this.$channelCreator;
                SessionConfig sessionConfig = this.$sessionConfig;
                boolean $i$f$withServeLockInterruptible = false;
                while (!SshConnection.access$getServeLock$p((SshConnection)this_$iv).tryLock(500L, TimeUnit.MILLISECONDS)) {
                    void progressIndicator$iv;
                    SshConnection.access$assertNotDisposed((SshConnection)this_$iv);
                    void v0 = progressIndicator$iv;
                    if (v0 == null) continue;
                    v0.checkCanceled();
                }
                try {
                    Pair pair2;
                    block14: {
                        boolean bl = false;
                        SshConnection.access$assertNotDisposed(sshConnection2);
                        Iterator<E> iterator = SshConnection.access$getSessions$p(sshConnection2).iterator();
                        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                        Iterator<E> iterator2 = iterator;
                        while (iterator2.hasNext()) {
                            E e = iterator2.next();
                            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                            SshSessionChannelFactory session = (SshSessionChannelFactory)e;
                            if (session.isConnected()) {
                                try {
                                    pair2 = TuplesKt.to(session.openChannel(function1), null);
                                    break block14;
                                }
                                catch (SshException e2) {
                                    if (e2 instanceof ChannelSshTransportException) {
                                        SshConnection.access$getLOG$cp().debug(session + " refused to create a new channel");
                                        continue;
                                    }
                                    if (ExceptionUtil.causedBy((Throwable)((Throwable)((Object)e2)), SocketException.class)) {
                                        SshConnection.access$getLOG$cp().warn("Got error when tried to acquire a channel in session " + session + ". Probably connection was lost.", (Throwable)((Object)e2));
                                        continue;
                                    }
                                    throw e2;
                                }
                            }
                            iterator2.remove();
                            Lock lock = SshConnection.access$getDisposeLock$p(sshConnection2);
                            lock.lock();
                            try {
                                boolean bl2 = false;
                                boolean bl3 = SshConnection.access$getAllSessions$p(sshConnection2).remove(session);
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                        SshConnection.access$getLOG$cp().debug("Failed to create SSH channel using existing SSH sessions, creating new SSH session");
                        SshSessionChannelFactory sshSession = SshConnection.access$createSession(sshConnection2, sessionConfig);
                        pair2 = TuplesKt.to(sshSession.openChannel(function1), (Object)sshSession);
                    }
                    pair = pair2;
                }
                finally {
                    SshConnection.access$getServeLock$p((SshConnection)this_$iv).unlock();
                }
                Pair pair3 = pair;
                SshChannel channel2 = (SshChannel)pair3.component1();
                SshSessionChannelFactory createdSession = (SshSessionChannelFactory)pair3.component2();
                if (createdSession != null) {
                    ((SshConnectionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionStateListener.Companion.getAUTH_TOPIC())).connectionCreated(createdSession);
                }
                return (R)channel2;
            }
        }, 3, null));
    }

    @NotNull
    public final SshSession connect(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return this.getSshSession(sessionConfig);
    }

    @NotNull
    public final SshSession getSshSession(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return (SshSession)Ssh.wrapBlockingSshCall$default(null, false, (Function0)new Function0<SshSessionChannelFactory>(this, sessionConfig){
            final /* synthetic */ SshConnection this$0;
            final /* synthetic */ SessionConfig $sessionConfig;
            {
                this.this$0 = $receiver;
                this.$sessionConfig = $sessionConfig;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final SshSessionChannelFactory invoke() {
                Pair pair;
                void this_$iv;
                ((SshConnectionService.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionService.Companion.getTOPIC())).sessionOrChannelRequested(this.this$0.getUserName(), this.this$0.getHost(), this.this$0.getPort());
                SshConnection sshConnection = this.this$0;
                ProgressIndicator progressIndicator2 = this.$sessionConfig.getProgressIndicator();
                SshConnection sshConnection2 = this.this$0;
                SessionConfig sessionConfig = this.$sessionConfig;
                boolean $i$f$withServeLockInterruptible = false;
                while (!SshConnection.access$getServeLock$p((SshConnection)this_$iv).tryLock(500L, TimeUnit.MILLISECONDS)) {
                    void progressIndicator$iv;
                    SshConnection.access$assertNotDisposed((SshConnection)this_$iv);
                    void v0 = progressIndicator$iv;
                    if (v0 == null) continue;
                    v0.checkCanceled();
                }
                try {
                    Pair pair2;
                    block10: {
                        boolean bl = false;
                        Iterator<E> iterator = SshConnection.access$getSessions$p(sshConnection2).iterator();
                        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                        Iterator<E> iterator2 = iterator;
                        while (iterator2.hasNext()) {
                            E e = iterator2.next();
                            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                            SshSessionChannelFactory session = (SshSessionChannelFactory)e;
                            if (session.isConnected()) {
                                pair2 = TuplesKt.to((Object)session, (Object)false);
                                break block10;
                            }
                            iterator2.remove();
                            Lock lock = SshConnection.access$getDisposeLock$p(sshConnection2);
                            lock.lock();
                            try {
                                boolean bl2 = false;
                                boolean bl3 = SshConnection.access$getAllSessions$p(sshConnection2).remove(session);
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                        SshConnection.access$getLOG$cp().debug("No opened sessions to " + sshConnection2.getUserName() + "@" + sshConnection2.getHost() + ":" + sshConnection2.getPort() + " found");
                        pair2 = TuplesKt.to((Object)SshConnection.access$createSession(sshConnection2, sessionConfig), (Object)true);
                    }
                    pair = pair2;
                }
                finally {
                    SshConnection.access$getServeLock$p((SshConnection)this_$iv).unlock();
                }
                Pair pair3 = pair;
                SshSessionChannelFactory session = (SshSessionChannelFactory)pair3.component1();
                boolean justCreated = (Boolean)pair3.component2();
                if (justCreated) {
                    ((SshConnectionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionStateListener.Companion.getAUTH_TOPIC())).connectionCreated(session);
                }
                return session;
            }
        }, 3, null);
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate(@NotNull SessionConfig sessionConfig, boolean addToPool) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return (Boolean)Ssh.wrapBlockingSshCall$default(null, false, (Function0)new Function0<Boolean>(this, sessionConfig, addToPool){
            final /* synthetic */ SshConnection this$0;
            final /* synthetic */ SessionConfig $sessionConfig;
            final /* synthetic */ boolean $addToPool;
            {
                this.this$0 = $receiver;
                this.$sessionConfig = $sessionConfig;
                this.$addToPool = $addToPool;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                SshSessionChannelFactory sshSessionChannelFactory;
                SshConnection.access$getLOG$cp().debug("Checking that can authenticate " + this.this$0.getUserName() + "@" + this.this$0.getHost() + ":" + this.this$0.getPort());
                if (checkCanAuthenticate.WhenMappings.$EnumSwitchMapping$0[this.$sessionConfig.getSshBackendLibrary().ordinal()] == 1) {
                    try {
                        sshSessionChannelFactory = SshConnection.access$createSshSessionForSshj(this.this$0, this.$sessionConfig);
                    }
                    catch (AuthFailSshTransportException e) {
                        sshSessionChannelFactory = null;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                SshSessionChannelFactory session = sshSessionChannelFactory;
                if (session != null) {
                    if (this.$addToPool) {
                        if (SshConnection.access$getServeLock$p(this.this$0).tryLock()) {
                            try {
                                checkCanAuthenticate.1.invoke$addToThePool(this.this$0, session);
                            }
                            finally {
                                SshConnection.access$getServeLock$p(this.this$0).unlock();
                            }
                        } else {
                            ProcessIOExecutorService.INSTANCE.execute(() -> checkCanAuthenticate.1.invoke$addToThePool(this.this$0, session));
                        }
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            private static final void invoke$addToThePool$lambda$1(SshSessionChannelFactory $session) {
                try {
                    $session.disconnect();
                }
                catch (Throwable err) {
                    SshConnection.access$getLOG$cp().info("Error on disconnection while checked if can authenticate. Unlikely it's sufficient.", err);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final void invoke$addToThePool(SshConnection this$0, SshSessionChannelFactory session) {
                boolean bl;
                Lock lock = SshConnection.access$getServeLock$p(this$0);
                lock.lock();
                try {
                    boolean bl2;
                    boolean bl3 = false;
                    if (SshConnection.access$getSessions$p(this$0).isEmpty()) {
                        SshConnection.access$getSessions$p(this$0).add(session);
                        bl2 = false;
                    } else {
                        bl2 = true;
                    }
                    bl = bl2;
                }
                finally {
                    lock.unlock();
                }
                boolean disconnect2 = bl;
                if (disconnect2) {
                    ProcessIOExecutorService.INSTANCE.execute(() -> checkCanAuthenticate.1.invoke$addToThePool$lambda$1(session));
                } else {
                    ((SshConnectionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionStateListener.Companion.getAUTH_TOPIC())).connectionCreated(session);
                }
            }
        }, 3, null);
    }

    public static /* synthetic */ boolean checkCanAuthenticate$default(SshConnection sshConnection, SessionConfig sessionConfig, boolean bl, int n, Object object) throws SshException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sshConnection.checkCanAuthenticate(sessionConfig, bl);
    }

    private final SshSessionChannelFactory createSession(SessionConfig sessionConfig) throws SshException {
        return (SshSessionChannelFactory)Ssh.wrapBlockingSshCall$default(null, false, (Function0)new Function0<SshSessionChannelFactory>(this, sessionConfig){
            final /* synthetic */ SshConnection this$0;
            final /* synthetic */ SessionConfig $sessionConfig;
            {
                this.this$0 = $receiver;
                this.$sessionConfig = $sessionConfig;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final SshSessionChannelFactory invoke() {
                SshConnection.access$getLOG$cp().debug("Establishing new SSH session to " + this.this$0.getUserName() + "@" + this.this$0.getHost() + ":" + this.this$0.getPort());
                if (createSession.WhenMappings.$EnumSwitchMapping$0[this.$sessionConfig.getSshBackendLibrary().ordinal()] != 1) {
                    throw new NoWhenBranchMatchedException();
                }
                SshSessionChannelFactory session = SshConnection.access$createSshSessionForSshj(this.this$0, this.$sessionConfig);
                SshConnection.access$getLOG$cp().debug("SSH session @" + Integer.toHexString(session.hashCode()) + " established to " + this.this$0.getUserName() + "@" + this.this$0.getHost() + ":" + this.this$0.getPort());
                Lock lock = SshConnection.access$getDisposeLock$p(this.this$0);
                SshConnection sshConnection = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    SshConnection.access$assertNotDisposed(sshConnection);
                    boolean bl2 = SshConnection.access$getSessions$p(sshConnection).add(session);
                }
                finally {
                    lock.unlock();
                }
                return session;
            }
        }, 3, null);
    }

    private final SshSessionChannelFactory createSshSessionForSshj(SessionConfig sessionConfig) {
        Object[] objectArray = new Object[]{sessionConfig.getConnectionConfig().getUser(), sessionConfig.getConnectionConfig().getHost()};
        String string = SshBundle.message("ssh.connecting.to.background.task.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return (SshSessionChannelFactory)Ssh.wrapBlockingSshCall$default(string, false, (Function0)new Function0<SshSessionChannelFactory>(this, sessionConfig){
            final /* synthetic */ SshConnection this$0;
            final /* synthetic */ SessionConfig $sessionConfig;
            {
                this.this$0 = $receiver;
                this.$sessionConfig = $sessionConfig;
                super(0);
            }

            @NotNull
            public final SshSessionChannelFactory invoke() {
                return SshConnection.access$doSshjSshConnection(this.this$0, this.$sessionConfig);
            }
        }, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SshSessionChannelFactory doSshjSshConnection(SessionConfig sessionConfig) {
        ProgressIndicator progressIndicator2 = sessionConfig.getProgressIndicator();
        if (progressIndicator2 == null) {
            progressIndicator2 = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator progressIndicator3 = progressIndicator2;
        ProgressWrapper progressIndicator4 = new ProgressWrapper(progressIndicator3){};
        ((Collection)this.progressIndicatorOfInstantiatingConnections).add(progressIndicator4);
        SshjSshConnection sshSession = SshjConnectionUtilKt.setUpSessionForSshJ(sessionConfig, (ProgressIndicator)progressIndicator4);
        Lock lock = this.disposeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.assertNotDisposed();
            boolean bl2 = this.allSessions.add(sshSession);
        }
        finally {
            lock.unlock();
        }
        return sshSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Lock lock = this.disposeLock;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.disposed) {
                this.disposed = true;
                LOG.debug("Disconnecting SSH sessions to " + this.userName + "@" + this.host + ":" + this.port);
                for (ProgressIndicator progressIndicator2 : CollectionsKt.toList((Iterable)this.progressIndicatorOfInstantiatingConnections)) {
                    progressIndicator2.cancel();
                }
                for (SshSession session : this.allSessions) {
                    session.disconnect();
                }
                this.allSessions.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public final List<SshSession> getSessions() {
        return this.sessions;
    }

    private final void assertNotDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("SSH connection to " + this.userName + "@" + this.host + ":" + this.port + " disposed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withServeLockInterruptible(ProgressIndicator progressIndicator2, Function0<? extends T> handler) {
        boolean $i$f$withServeLockInterruptible = false;
        while (!this.serveLock.tryLock(500L, TimeUnit.MILLISECONDS)) {
            this.assertNotDisposed();
            ProgressIndicator progressIndicator3 = progressIndicator2;
            if (progressIndicator3 == null) continue;
            progressIndicator3.checkCanceled();
        }
        try {
            Object object = handler.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.serveLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return SshConnection.checkCanAuthenticate$default(this, sessionConfig, false, 2, null);
    }

    public static final /* synthetic */ ArrayList access$getAllSessions$p(SshConnection $this) {
        return $this.allSessions;
    }

    public static final /* synthetic */ ArrayList access$getSessions$p(SshConnection $this) {
        return $this.sessions;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ ReentrantLock access$getDisposeLock$p(SshConnection $this) {
        return $this.disposeLock;
    }

    public static final /* synthetic */ SshSessionChannelFactory access$createSession(SshConnection $this, SessionConfig sessionConfig) {
        return $this.createSession(sessionConfig);
    }

    public static final /* synthetic */ SshSessionChannelFactory access$createSshSessionForSshj(SshConnection $this, SessionConfig sessionConfig) {
        return $this.createSshSessionForSshj(sessionConfig);
    }

    public static final /* synthetic */ SshSessionChannelFactory access$doSshjSshConnection(SshConnection $this, SessionConfig sessionConfig) {
        return $this.doSshjSshConnection(sessionConfig);
    }

    static {
        Logger logger = Logger.getInstance(SshConnection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ssh/impl/SshConnection$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

