/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ssh.ProxyCommandImpl;
import com.intellij.ssh.ProxyCommandKt;
import com.intellij.util.EnvironmentUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0011H\u0002J\u0017\u0010\u001d\u001a\u00020\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fH\u0082\bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ssh/ProxyCommandImpl;", "", "command", "", "(Ljava/lang/String;)V", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "inputStream$delegate", "Lkotlin/Lazy;", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "outputStream$delegate", "process", "Ljava/lang/Process;", "processMonitor", "Ljava/lang/Object;", "watcher", "Ljava/lang/Thread;", "close", "", "connect", "host", "port", "", "ensureProcess", "ignoreStreamClosed", "block", "Lkotlin/Function0;", "makeProcessBuilder", "Ljava/lang/ProcessBuilder;", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nProxyCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyCommand.kt\ncom/intellij/ssh/ProxyCommandImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1#2:281\n*E\n"})
final class ProxyCommandImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String command;
    @Nullable
    private Process process;
    @Nullable
    private Thread watcher;
    @NotNull
    private final Object processMonitor;
    @NotNull
    private final Lazy inputStream$delegate;
    @NotNull
    private final Lazy outputStream$delegate;
    @NotNull
    private static final String HOST = "%h";
    @NotNull
    private static final String PORT = "%p";
    @NotNull
    private static final String USERNAME = "%r";
    @NotNull
    private static final Regex SPACES = new Regex("\\s+");
    @NotNull
    private static final String SHELL_ENV_VAR = "SHELL";
    @NotNull
    private static final String PATH_BSHELL = "/bin/sh";

    public ProxyCommandImpl(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.command = command;
        this.processMonitor = new Object();
        this.inputStream$delegate = LazyKt.lazy((Function0)((Function0)new Function0<inputStream.1>(this){
            final /* synthetic */ ProxyCommandImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final inputStream.1 invoke() {
                ProxyCommandImpl self = this.this$0;
                InputStream inputStream2 = ProxyCommandImpl.access$ensureProcess(this.this$0).getInputStream();
                return new FilterInputStream(this.this$0, self, inputStream2){
                    final /* synthetic */ ProxyCommandImpl this$0;
                    final /* synthetic */ ProxyCommandImpl $self;
                    {
                        this.this$0 = $receiver;
                        this.$self = $self;
                        super($super_call_param$1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() {
                        block7: {
                            ProxyCommandImpl proxyCommandImpl = this.this$0;
                            ProxyCommandImpl proxyCommandImpl2 = this.this$0;
                            ProxyCommandImpl proxyCommandImpl3 = this.$self;
                            boolean $i$f$ignoreStreamClosed = false;
                            try {
                                boolean bl = false;
                                Object object = ProxyCommandImpl.access$getProcessMonitor$p(proxyCommandImpl2);
                                synchronized (object) {
                                    boolean bl2 = false;
                                    proxyCommandImpl3.close();
                                    super.close();
                                    Unit unit = Unit.INSTANCE;
                                }
                            }
                            catch (IOException e$iv) {
                                String string;
                                String string2 = e$iv.getMessage();
                                if (string2 != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null) {
                                    String string3 = string2.toLowerCase();
                                    string = string3;
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                                } else {
                                    string = null;
                                }
                                if (Intrinsics.areEqual(string, (Object)"stream closed")) break block7;
                                throw e$iv;
                            }
                        }
                    }
                };
            }
        }));
        this.outputStream$delegate = LazyKt.lazy((Function0)((Function0)new Function0<outputStream.1>(this){
            final /* synthetic */ ProxyCommandImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final outputStream.1 invoke() {
                ProxyCommandImpl self = this.this$0;
                OutputStream delegate = ProxyCommandImpl.access$ensureProcess(this.this$0).getOutputStream();
                return new OutputStream(delegate, this.this$0, self){
                    final /* synthetic */ OutputStream $delegate;
                    final /* synthetic */ ProxyCommandImpl this$0;
                    final /* synthetic */ ProxyCommandImpl $self;
                    {
                        this.$delegate = $delegate;
                        this.this$0 = $receiver;
                        this.$self = $self;
                    }

                    public void flush() {
                        this.$delegate.flush();
                    }

                    public void write(int p0) {
                        this.$delegate.write(p0);
                        this.$delegate.flush();
                    }

                    public void write(@NotNull byte[] b, int off, int len) {
                        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                        this.$delegate.write(b, off, len);
                        this.$delegate.flush();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() {
                        block7: {
                            ProxyCommandImpl proxyCommandImpl = this.this$0;
                            ProxyCommandImpl proxyCommandImpl2 = this.this$0;
                            ProxyCommandImpl proxyCommandImpl3 = this.$self;
                            OutputStream outputStream2 = this.$delegate;
                            boolean $i$f$ignoreStreamClosed = false;
                            try {
                                boolean bl = false;
                                Object object = ProxyCommandImpl.access$getProcessMonitor$p(proxyCommandImpl2);
                                synchronized (object) {
                                    boolean bl2 = false;
                                    proxyCommandImpl3.close();
                                    outputStream2.close();
                                    Unit unit = Unit.INSTANCE;
                                }
                            }
                            catch (IOException e$iv) {
                                String string;
                                String string2 = e$iv.getMessage();
                                if (string2 != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null) {
                                    String string3 = string2.toLowerCase();
                                    string = string3;
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                                } else {
                                    string = null;
                                }
                                if (Intrinsics.areEqual(string, (Object)"stream closed")) break block7;
                                throw e$iv;
                            }
                        }
                    }
                };
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void connect(@Nullable String host2, int port2) throws IOException {
        ProxyCommandKt.access$getLOG$p().info("ProxyCommand for " + host2 + ":" + port2 + ": " + this.command);
        try {
            void $this$connect_u24lambda_u244;
            Process process2;
            Object $this$connect_u24lambda_u242 = this.makeProcessBuilder(this.command);
            boolean bl = false;
            ((ProcessBuilder)$this$connect_u24lambda_u242).redirectError(ProcessBuilder.Redirect.PIPE);
            Object object = this.processMonitor;
            synchronized (object) {
                Process process3;
                boolean bl2 = false;
                if (this.process != null) {
                    throw new IOException("Already connected");
                }
                Process it = process3 = ((ProcessBuilder)$this$connect_u24lambda_u242).start();
                boolean bl3 = false;
                this.process = it;
                process2 = process3;
            }
            Process startedProcess = process2;
            ProxyCommandKt.access$getLOG$p().info("Started ProxyCommand for " + host2 + ":" + port2 + ": " + this.process);
            Thread thread = new Thread(() -> ProxyCommandImpl.connect$lambda$3(startedProcess));
            $this$connect_u24lambda_u242 = thread;
            ProxyCommandImpl proxyCommandImpl = this;
            boolean bl4 = false;
            $this$connect_u24lambda_u244.setName("Error stream logger of " + startedProcess);
            $this$connect_u24lambda_u244.setDaemon(true);
            $this$connect_u24lambda_u244.start();
            proxyCommandImpl.watcher = thread;
        }
        catch (ExecutionException e) {
            IOException iOException = e.toIOException();
            Intrinsics.checkNotNullExpressionValue((Object)iOException, (String)"toIOException(...)");
            throw (Throwable)iOException;
        }
    }

    private final void ignoreStreamClosed(Function0<Unit> block) {
        block4: {
            boolean $i$f$ignoreStreamClosed = false;
            try {
                block.invoke();
            }
            catch (IOException e) {
                String string;
                String string2 = e.getMessage();
                if (string2 != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null) {
                    String string3 = string2.toLowerCase();
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                } else {
                    string = null;
                }
                if (Intrinsics.areEqual(string, (Object)"stream closed")) break block4;
                throw e;
            }
        }
    }

    @NotNull
    public final InputStream getInputStream() {
        Lazy lazy = this.inputStream$delegate;
        return (InputStream)lazy.getValue();
    }

    @NotNull
    public final OutputStream getOutputStream() {
        Lazy lazy = this.outputStream$delegate;
        return (OutputStream)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Process p;
        Process process2;
        Object object = this.processMonitor;
        synchronized (object) {
            boolean bl = false;
            Process p2 = this.process;
            this.process = null;
            process2 = p2;
        }
        Process process3 = p = process2;
        if (process3 != null) {
            process3.destroy();
        }
        try {
            Thread thread = this.watcher;
            if (thread != null) {
                thread.join();
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            ProxyCommandKt.access$getLOG$p().info("Got InterruptedException when tried to join " + this.watcher);
        }
    }

    private final ProcessBuilder makeProcessBuilder(String command) {
        if (!SystemInfo.isWindows) {
            String string = System.getenv(SHELL_ENV_VAR);
            if (string == null) {
                string = PATH_BSHELL;
            }
            String shell2 = string;
            String[] stringArray = new String[]{shell2, "-c", "exec " + command};
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            try {
                Map map = EnvironmentUtil.getEnvironmentMap();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironmentMap(...)");
                Map envFromNewShell = map;
                processBuilder.environment().putAll(envFromNewShell);
            }
            catch (IOException ioe) {
                ProxyCommandKt.access$getLOG$p().warn("Failed to read environment variables from the new Shell process:\n " + ioe);
            }
            return processBuilder;
        }
        CharSequence charSequence = command;
        Regex regex = SPACES;
        int n = 0;
        return new ProcessBuilder(regex.split(charSequence, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Process ensureProcess() {
        Process process2;
        Object object = this.processMonitor;
        synchronized (object) {
            boolean bl = false;
            Process process3 = this.process;
            if (process3 == null) {
                throw new IOException("Not connected");
            }
            process2 = process3;
        }
        return process2;
    }

    private static final void connect$lambda$3(Process $startedProcess) {
        Intrinsics.checkNotNull((Object)$startedProcess);
        ProxyCommandKt.watchProxyCommandProcess($startedProcess, ProxyCommandKt.access$getLOG$p());
    }

    public static final /* synthetic */ Object access$getProcessMonitor$p(ProxyCommandImpl $this) {
        return $this.processMonitor;
    }

    public static final /* synthetic */ Process access$ensureProcess(ProxyCommandImpl $this) {
        return $this.ensureProcess();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ssh/ProxyCommandImpl$Companion;", "", "()V", "HOST", "", "PATH_BSHELL", "PORT", "SHELL_ENV_VAR", "SPACES", "Lkotlin/text/Regex;", "USERNAME", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

