/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.GroupButtonsAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.util.ArrayList;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class NoButtonGroupInspection
extends BaseFormInspection {
    private static final Logger LOG = Logger.getInstance(NoButtonGroupInspection.class);

    public NoButtonGroupInspection() {
        super("NoButtonGroup");
    }

    @Override
    protected void checkComponentProperties(Module module, @NotNull IComponent component, FormErrorCollector collector) {
        if (component == null) {
            NoButtonGroupInspection.$$$reportNull$$$0(0);
        }
        if (FormInspectionUtil.isComponentClass(module, component, JRadioButton.class)) {
            IRootContainer root = FormEditingUtil.getRoot(component);
            if (root == null) {
                return;
            }
            if (root.getButtonGroupName(component) == null) {
                EditorQuickFixProvider quickFixProvider = null;
                IContainer parent = component.getParentContainer();
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    GridConstraints c2;
                    GridConstraints c1;
                    IComponent child = parent.getComponent(i);
                    if (child == component || !FormInspectionUtil.isComponentClass(module, child, JRadioButton.class) || !NoButtonGroupInspection.areCellsAdjacent(parent, c1 = component.getConstraints(), c2 = child.getConstraints())) continue;
                    String groupName = root.getButtonGroupName(child);
                    if (groupName == null) {
                        quickFixProvider = (editor, component1) -> new CreateGroupQuickFix(editor, component1, c1.getColumn() == c2.getColumn());
                        break;
                    }
                    quickFixProvider = (editor, component12) -> new AddToGroupQuickFix(editor, component12, groupName);
                }
                collector.addError(this.getID(), component, null, UIDesignerBundle.message("inspection.no.button.group.error", new Object[0]), quickFixProvider);
            }
        }
    }

    private static boolean areCellsAdjacent(IContainer parent, GridConstraints c1, GridConstraints c2) {
        if (parent instanceof RadContainer) {
            RadContainer container = (RadContainer)parent;
            if (!container.getLayoutManager().isGrid()) {
                return false;
            }
            if (c1.getRow() == c2.getRow()) {
                return FormEditingUtil.prevCol(container, c1.getColumn()) == c2.getColumn() || FormEditingUtil.nextCol(container, c1.getColumn()) == c2.getColumn();
            }
            if (c1.getColumn() == c2.getColumn()) {
                return FormEditingUtil.prevRow(container, c1.getRow()) == c2.getRow() || FormEditingUtil.nextRow(container, c1.getRow()) == c2.getRow();
            }
        }
        return c1.getRow() == c2.getRow() && Math.abs(c1.getColumn() - c2.getColumn()) == 1 || c1.getColumn() == c2.getColumn() && Math.abs(c1.getRow() - c2.getRow()) == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/inspections/NoButtonGroupInspection", "checkComponentProperties"));
    }

    private static class AddToGroupQuickFix
    extends QuickFix {
        private final String myGroupName;

        AddToGroupQuickFix(GuiEditor editor, RadComponent component, String groupName) {
            super(editor, UIDesignerBundle.message("inspection.no.button.group.quickfix.add", groupName), component);
            this.myGroupName = groupName;
        }

        @Override
        public void run() {
            RadRootContainer root = (RadRootContainer)FormEditingUtil.getRoot(this.myComponent);
            if (root == null) {
                return;
            }
            for (RadButtonGroup group : root.getButtonGroups()) {
                if (!group.getName().equals(this.myGroupName)) continue;
                root.setGroupForComponent(this.myComponent, group);
                break;
            }
            this.myEditor.refreshAndSave(true);
        }
    }

    private static class CreateGroupQuickFix
    extends QuickFix {
        private final boolean myVerticalGroup;

        CreateGroupQuickFix(GuiEditor editor, RadComponent component, boolean verticalGroup) {
            super(editor, UIDesignerBundle.message("inspection.no.button.group.quickfix.create", new Object[0]), component);
            this.myVerticalGroup = verticalGroup;
        }

        @Override
        public void run() {
            int i;
            RadContainer parent = this.myComponent.getParent();
            ArrayList<RadComponent> buttonsToGroup = new ArrayList<RadComponent>();
            for (RadComponent component : parent.getComponents()) {
                if (!FormInspectionUtil.isComponentClass(this.myComponent.getModule(), component, JRadioButton.class) || component.getConstraints().getCell(!this.myVerticalGroup) != this.myComponent.getConstraints().getCell(!this.myVerticalGroup)) continue;
                buttonsToGroup.add(component);
            }
            buttonsToGroup.sort((o1, o2) -> {
                if (this.myVerticalGroup) {
                    return o1.getConstraints().getRow() - o2.getConstraints().getRow();
                }
                return o1.getConstraints().getColumn() - o2.getConstraints().getColumn();
            });
            int index = buttonsToGroup.indexOf(this.myComponent);
            LOG.assertTrue(index >= 0);
            int expectCell = this.myComponent.getConstraints().getCell(this.myVerticalGroup);
            for (i = index - 1; i >= 0; --i) {
                expectCell = FormEditingUtil.adjustForGap(parent, expectCell - 1, this.myVerticalGroup, -1);
                if (((RadComponent)buttonsToGroup.get(i)).getConstraints().getCell(this.myVerticalGroup) == expectCell) continue;
                buttonsToGroup.subList(0, i + 1).clear();
                break;
            }
            expectCell = this.myComponent.getConstraints().getCell(this.myVerticalGroup);
            for (i = index + 1; i < buttonsToGroup.size(); ++i) {
                expectCell = FormEditingUtil.adjustForGap(parent, expectCell + 1, this.myVerticalGroup, 1);
                if (((RadComponent)buttonsToGroup.get(i)).getConstraints().getCell(this.myVerticalGroup) == expectCell) continue;
                buttonsToGroup.subList(i, buttonsToGroup.size()).clear();
                break;
            }
            LOG.assertTrue(buttonsToGroup.size() > 1);
            GroupButtonsAction.groupButtons(this.myEditor, buttonsToGroup);
        }
    }
}

