/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.ide.palette.impl.PaletteToolWindowManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.uiDesigner.CutCopyPasteSupport;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.SimpleTransferable;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.ComponentItemDragObject;
import com.intellij.uiDesigner.designSurface.DraggedComponentList;
import com.intellij.uiDesigner.designSurface.GridInsertProcessor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class DesignDropTargetListener
implements DropTargetListener {
    private static final Logger LOG = Logger.getInstance(DesignDropTargetListener.class);
    private DraggedComponentList myDraggedComponentList;
    private ComponentDragObject myComponentDragObject;
    private List<RadComponent> myDraggedComponentsCopy;
    private Point myLastPoint;
    private final GuiEditor myEditor;
    private final GridInsertProcessor myGridInsertProcessor;
    private boolean myUseDragDelta = false;

    DesignDropTargetListener(GuiEditor editor) {
        this.myEditor = editor;
        this.myGridInsertProcessor = new GridInsertProcessor(editor);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        try {
            DraggedComponentList dcl = DraggedComponentList.fromTransferable(dtde.getTransferable());
            if (dcl != null) {
                this.myDraggedComponentList = dcl;
                this.myComponentDragObject = dcl;
                this.processDragEnter(dcl, dtde.getLocation(), dtde.getDropAction());
                dtde.acceptDrag(dtde.getDropAction());
                this.myLastPoint = dtde.getLocation();
            } else {
                ComponentItem componentItem = SimpleTransferable.getData(dtde.getTransferable(), ComponentItem.class);
                if (componentItem != null) {
                    this.myComponentDragObject = new ComponentItemDragObject(componentItem);
                    dtde.acceptDrag(dtde.getDropAction());
                    this.myLastPoint = dtde.getLocation();
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void processDragEnter(DraggedComponentList draggedComponentList, Point location, int dropAction) {
        ArrayList<RadComponent> dragComponents = draggedComponentList.getComponents();
        Rectangle allBounds = null;
        if (!draggedComponentList.hasDragDelta() || !this.myUseDragDelta) {
            RadContainer[] originalParents = draggedComponentList.getOriginalParents();
            Rectangle[] originalBounds = draggedComponentList.getOriginalBounds();
            for (int i = 0; i < originalParents.length; ++i) {
                Rectangle rc = SwingUtilities.convertRectangle(originalParents[i].getDelegee(), originalBounds[i], this.myEditor.getDragLayer());
                allBounds = allBounds == null ? rc : allBounds.union(rc);
            }
        }
        this.myDraggedComponentsCopy = CutCopyPasteSupport.copyComponents(this.myEditor, dragComponents);
        for (int i = 0; i < dragComponents.size(); ++i) {
            this.myDraggedComponentsCopy.get(i).setSelected(true);
            JComponent delegee = this.myDraggedComponentsCopy.get(i).getDelegee();
            Point point = SwingUtilities.convertPoint(draggedComponentList.getOriginalParents()[i].getDelegee(), delegee.getLocation(), this.myEditor.getDragLayer());
            if (draggedComponentList.hasDragDelta() && this.myUseDragDelta) {
                delegee.setLocation((int)point.getX() + draggedComponentList.getDragDeltaX(), (int)point.getY() + draggedComponentList.getDragDeltaY());
                continue;
            }
            assert (allBounds != null);
            delegee.setLocation((int)(point.getX() - allBounds.getX() + location.getX()), (int)(point.getY() - allBounds.getY() + location.getY()));
        }
        for (RadComponent c : dragComponents) {
            if (dropAction != 1) {
                c.setDragBorder(true);
            }
            c.setSelected(false);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        try {
            if (this.myComponentDragObject == null) {
                dtde.rejectDrag();
                return;
            }
            int dx = dtde.getLocation().x - this.myLastPoint.x;
            int dy = dtde.getLocation().y - this.myLastPoint.y;
            if (this.myDraggedComponentsCopy != null && this.myDraggedComponentList != null) {
                for (RadComponent aMySelection : this.myDraggedComponentsCopy) {
                    aMySelection.shift(dx, dy);
                }
            }
            this.myLastPoint = dtde.getLocation();
            this.myEditor.getDragLayer().repaint();
            ComponentDropLocation location = this.myGridInsertProcessor.processDragEvent(dtde.getLocation(), this.myComponentDragObject);
            ComponentTree componentTree = DesignerToolWindowManager.getInstance(this.myEditor).getComponentTree();
            if (!location.canDrop(this.myComponentDragObject) || this.myDraggedComponentList != null && FormEditingUtil.isDropOnChild(this.myDraggedComponentList, location)) {
                if (componentTree != null) {
                    componentTree.setDropTargetComponent(null);
                }
                dtde.rejectDrag();
            } else {
                if (componentTree != null) {
                    componentTree.setDropTargetComponent(location.getContainer());
                }
                dtde.acceptDrag(dtde.getDropAction());
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        DraggedComponentList dcl = DraggedComponentList.fromTransferable(dtde.getTransferable());
        if (dcl != null) {
            DesignDropTargetListener.setDraggingState(dcl, dtde.getDropAction() != 1);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        try {
            ComponentTree componentTree = DesignerToolWindowManager.getInstance(this.myEditor).getComponentTree();
            if (componentTree != null) {
                componentTree.setDropTargetComponent(null);
            }
            this.myUseDragDelta = false;
            if (this.myDraggedComponentList != null) {
                this.cancelDrag();
                DesignDropTargetListener.setDraggingState(this.myDraggedComponentList, false);
                this.myEditor.getActiveDecorationLayer().removeFeedback();
                this.myDraggedComponentList = null;
                this.myEditor.setDesignTimeInsets(2);
            }
            this.myDraggedComponentsCopy = null;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            DraggedComponentList dcl;
            ComponentTree componentTree = DesignerToolWindowManager.getInstance(this.myEditor).getComponentTree();
            if (componentTree != null) {
                componentTree.setDropTargetComponent(null);
            }
            if ((dcl = DraggedComponentList.fromTransferable(dtde.getTransferable())) != null) {
                CommandProcessor.getInstance().executeCommand(this.myEditor.getProject(), () -> {
                    if (this.processDrop(dcl, dtde.getLocation(), dtde.getDropAction())) {
                        this.myEditor.refreshAndSave(true);
                    }
                }, UIDesignerBundle.message("command.drop.components", new Object[0]), null);
            } else {
                ComponentItem componentItem = SimpleTransferable.getData(dtde.getTransferable(), ComponentItem.class);
                if (componentItem != null) {
                    this.myEditor.getMainProcessor().setInsertFeedbackEnabled(false);
                    new InsertComponentProcessor(this.myEditor).processComponentInsert(dtde.getLocation(), componentItem);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        PaletteToolWindowManager.getInstance(this.myEditor).clearActiveItem();
                        this.myEditor.getActiveDecorationLayer().removeFeedback();
                        this.myEditor.getLayeredPane().setCursor(null);
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getGlassLayer(), true));
                        this.myEditor.getMainProcessor().setInsertFeedbackEnabled(true);
                    });
                }
            }
            this.myDraggedComponentsCopy = null;
            this.myEditor.repaintLayeredPane();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean processDrop(DraggedComponentList dcl, Point dropPoint, int dropAction) {
        List<RadComponent> droppedComponents;
        this.myEditor.getActiveDecorationLayer().removeFeedback();
        ArrayList<RadComponent> dclComponents = dcl.getComponents();
        int componentCount = dclComponents.size();
        ComponentDropLocation location = GridInsertProcessor.getDropLocation(this.myEditor.getRootContainer(), dropPoint);
        if (FormEditingUtil.isDropOnChild(dcl, location)) {
            DesignDropTargetListener.setDraggingState(dcl, false);
            return false;
        }
        if (!location.canDrop(dcl)) {
            DesignDropTargetListener.setDraggingState(dcl, false);
            return false;
        }
        if (!this.myEditor.ensureEditable()) {
            DesignDropTargetListener.setDraggingState(dcl, false);
            return false;
        }
        RadContainer[] originalParents = dcl.getOriginalParents();
        this.cancelDrag();
        if (dropAction == 1) {
            DesignDropTargetListener.setDraggingState(dcl, false);
            droppedComponents = this.myDraggedComponentsCopy;
            if (droppedComponents == null) {
                return false;
            }
        } else {
            for (int i = 0; i < dclComponents.size(); ++i) {
                LOG.info("Removing component " + dclComponents.get(i).getId() + " with constraints " + dcl.getOriginalConstraints()[i]);
                originalParents[i].removeComponent(dclComponents.get(i));
            }
            droppedComponents = dclComponents;
        }
        RadComponent[] components = droppedComponents.toArray(new RadComponent[componentCount]);
        GridConstraints[] originalConstraints = dcl.getOriginalConstraints();
        location.processDrop(this.myEditor, components, originalConstraints, dcl);
        if (dropAction == 1) {
            for (RadComponent component : droppedComponents) {
                InsertComponentProcessor.createBindingWhenDrop(this.myEditor, component, false);
            }
            FormEditingUtil.selectComponents(this.myEditor, droppedComponents);
        } else {
            DesignDropTargetListener.setDraggingState(dcl, false);
        }
        for (int i = 0; i < originalConstraints.length; ++i) {
            if (!originalParents[i].getLayoutManager().isGrid()) continue;
            FormEditingUtil.deleteEmptyGridCells(originalParents[i], originalConstraints[i]);
        }
        return true;
    }

    private void cancelDrag() {
        if (this.myDraggedComponentsCopy != null) {
            for (RadComponent c : this.myDraggedComponentsCopy) {
                this.myEditor.getDragLayer().remove(c.getDelegee());
            }
        }
        this.myEditor.refresh();
    }

    private static void setDraggingState(DraggedComponentList draggedComponentList, boolean dragging) {
        for (RadComponent c : draggedComponentList.getComponents()) {
            c.setDragBorder(dragging);
        }
    }

    public void setUseDragDelta(boolean useDragDelta) {
        this.myUseDragDelta = useDragDelta;
    }
}

