/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyInspectorTable;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class ShowJavadocAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowJavadocAction.$$$reportNull$$$0(0);
        }
        PropertyInspectorTable inspector = (PropertyInspectorTable)((Object)e.getData(PropertyInspectorTable.DATA_KEY));
        GuiEditor guiEditor = (GuiEditor)e.getData(GuiEditor.DATA_KEY);
        if (inspector == null || guiEditor == null) {
            return;
        }
        IntrospectedProperty introspectedProperty = inspector.getSelectedIntrospectedProperty();
        String radComponentClassName = inspector.getSelectedRadComponentClassName();
        if (introspectedProperty == null || radComponentClassName == null) {
            return;
        }
        Module module = guiEditor.getModule();
        PsiClass aClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(radComponentClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (aClass == null) {
            return;
        }
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)aClass, (String)introspectedProperty.getName(), (boolean)false, (boolean)true);
        PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)aClass, (String)introspectedProperty.getName(), (boolean)false, (boolean)true);
        if (getter == null || setter == null) {
            return;
        }
        DocumentationManager documentationManager = DocumentationManager.getInstance((Project)aClass.getProject());
        DocumentationComponent component1 = new DocumentationComponent(documentationManager);
        DocumentationComponent component2 = new DocumentationComponent(documentationManager);
        Disposable disposable = Disposer.newDisposable();
        TabbedPaneWrapper tabbedPane = new TabbedPaneWrapper(disposable);
        tabbedPane.addTab(UIDesignerBundle.message("tab.getter", new Object[0]), (JComponent)component1);
        tabbedPane.addTab(UIDesignerBundle.message("tab.setter", new Object[0]), (JComponent)component2);
        documentationManager.fetchDocInfo((PsiElement)getter, component1);
        documentationManager.queueFetchDocInfo((PsiElement)setter, component2).doWhenProcessed(() -> {
            JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder(tabbedPane.getComponent(), (JComponent)component1).setDimensionServiceKey(aClass.getProject(), "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(UIDesignerBundle.message("property.javadoc.title", introspectedProperty.getName())).createPopup();
            component1.setHint(hint);
            component2.setHint(hint);
            Disposer.register((Disposable)hint, (Disposable)component1);
            Disposer.register((Disposable)hint, (Disposable)component2);
            Disposer.register((Disposable)hint, (Disposable)disposable);
            hint.show(new RelativePoint((Component)((Object)inspector), new Point(0, 0)));
        });
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ShowJavadocAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowJavadocAction.$$$reportNull$$$0(2);
        }
        PropertyInspectorTable inspector = (PropertyInspectorTable)((Object)e.getData(PropertyInspectorTable.DATA_KEY));
        e.getPresentation().setEnabled(inspector != null && inspector.getSelectedIntrospectedProperty() != null && inspector.getSelectedRadComponentClassName() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/actions/ShowJavadocAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/actions/ShowJavadocAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

