/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.indexing.shared.platform.impl.CompositeInvertedIndex;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndex;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.events.VfsEventsMerger;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class SharedIndexFileIndexingStatusProcessor
implements FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor {
    private static final boolean SHARED_INDEX_USES_METADATA_HASHES = SystemProperties.getBooleanProperty((String)"shared.index.uses.metadata.hashes", (boolean)true);
    @NotNull
    private final IntSet myAttachedChunks;
    @NotNull
    private final Set<IndexChunk> myInvalidatedChunkIndexes;
    @NotNull
    private final FileBasedIndexImpl myFileBasedIndex;
    @NotNull
    private final Project myProject;

    SharedIndexFileIndexingStatusProcessor(@NotNull Project project) {
        if (project == null) {
            SharedIndexFileIndexingStatusProcessor.$$$reportNull$$$0(0);
        }
        this.myAttachedChunks = IntSets.synchronize((IntSet)new IntOpenHashSet());
        this.myInvalidatedChunkIndexes = ConcurrentCollectionFactory.createConcurrentSet();
        this.myFileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        this.myProject = project;
    }

    public boolean hasIndexForFile(@NotNull VirtualFile file, int inputId, @NotNull FileBasedIndexExtension<?, ?> extension) {
        if (file == null) {
            SharedIndexFileIndexingStatusProcessor.$$$reportNull$$$0(1);
        }
        if (extension == null) {
            SharedIndexFileIndexingStatusProcessor.$$$reportNull$$$0(2);
        }
        if (!extension.dependsOnFileContent()) {
            return false;
        }
        int chunkId = FileContentHashIndex.getFileContentHashIndex(extension.getName()).getAssociatedChunkId(inputId, file);
        return chunkId != -1 && SharedIndexChunkConfiguration.getInstance().hasSharedIndex(extension.getName(), chunkId);
    }

    public boolean shouldProcessUpToDateFiles() {
        return SharedIndexChunkConfiguration.getInstance().hasAnyChunk(false);
    }

    public boolean processUpToDateFile(@NotNull IndexedFile file, int inputId, @NotNull ID<?, ?> indexId2) {
        IndexChunk chunk;
        boolean isInvalidatedChunk;
        boolean shouldAttach;
        int chunkId;
        if (file == null) {
            SharedIndexFileIndexingStatusProcessor.$$$reportNull$$$0(3);
        }
        if (indexId2 == null) {
            SharedIndexFileIndexingStatusProcessor.$$$reportNull$$$0(4);
        }
        if ((chunkId = FileContentHashIndex.getFileContentHashIndex(indexId2).getAssociatedChunkId(inputId, file.getFile())) == -1) {
            return true;
        }
        boolean bl = shouldAttach = !this.myAttachedChunks.contains(chunkId);
        if (shouldAttach) {
            Collection<ID<?, ?>> attachedChunkIndexIds = SharedIndexChunkConfiguration.getInstance().attachExistingChunk(chunkId, this.myProject);
            Collection allContentDependentIndexes = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getContentDependentIndexes();
            for (ID id : allContentDependentIndexes) {
                if (attachedChunkIndexIds.contains(id)) continue;
                this.myInvalidatedChunkIndexes.add(new IndexChunk(chunkId, id));
            }
            this.myAttachedChunks.add(chunkId);
        }
        if ((isInvalidatedChunk = this.myInvalidatedChunkIndexes.contains(chunk = new IndexChunk(chunkId, indexId2))) || !SharedIndexChunkConfiguration.getInstance().isSharedIndexAcceptable(indexId2, chunkId, file)) {
            VfsEventsMerger.tryLog((String)"hash_index_wiped_invalid_chunk", (IndexedFile)file, () -> "id=" + indexId2);
            ProgressManager.getInstance().executeNonCancelableSection(() -> FileContentHashIndex.getFileContentHashIndex(indexId2).mapInputAndPrepareUpdate(inputId, null).compute());
            this.myFileBasedIndex.dropNontrivialIndexedStates(inputId, indexId2);
            return false;
        }
        return true;
    }

    public boolean tryIndexFileWithoutContent(@NotNull IndexedFile file, int inputId, @NotNull ID<?, ?> indexId2) {
        if (file == null) {
            SharedIndexFileIndexingStatusProcessor.$$$reportNull$$$0(5);
        }
        if (indexId2 == null) {
            SharedIndexFileIndexingStatusProcessor.$$$reportNull$$$0(6);
        }
        return (Boolean)ProgressManager.getInstance().computeInNonCancelableSection(() -> SHARED_INDEX_USES_METADATA_HASHES && ((CompositeInvertedIndex)this.myFileBasedIndex.getIndex(indexId2)).tryIndexWithoutContent(inputId, file));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/indexing/shared/platform/impl/SharedIndexFileIndexingStatusProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasIndexForFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processUpToDateFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "tryIndexFileWithoutContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class IndexChunk {
        private final int myChunkId;
        private final ID<?, ?> myIndexId;

        private IndexChunk(int id, ID<?, ?> indexId2) {
            this.myChunkId = id;
            this.myIndexId = indexId2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexChunk chunk = (IndexChunk)o;
            if (this.myChunkId != chunk.myChunkId) {
                return false;
            }
            return Objects.equals(this.myIndexId, chunk.myIndexId);
        }

        public int hashCode() {
            int result2 = this.myChunkId;
            result2 = 31 * result2 + (this.myIndexId != null ? this.myIndexId.hashCode() : 0);
            return result2;
        }
    }
}

