/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.platform.api.AttachChunkResult;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashEnumerator;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashProviders;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorages;
import com.intellij.indexing.shared.platform.impl.ChunkManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tJ\b\u0010\u0019\u001a\u00020\u0016H\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001dH\u0002R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexChunk;", "Lcom/intellij/openapi/Disposable;", "chunkRootPath", "Ljava/nio/file/Path;", "indexAttachChunkResult", "Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "(Ljava/nio/file/Path;Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;)V", "attachedProjects", "Ljava/util/HashSet;", "Lcom/intellij/openapi/project/Project;", "Lkotlin/collections/HashSet;", "getAttachedProjects", "()Ljava/util/HashSet;", "hashEnumerators", "", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashEnumerator;", "[Lkotlin/Pair;", "getIndexAttachChunkResult", "()Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "attachProject", "", "project", "detachProject", "dispose", "tryEnumerate", "", "fileContent", "Lcom/intellij/util/indexing/IndexedFile;", "isContentBased", "", "intellij.indexing.shared"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nChunkManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkManager.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexChunk\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,149:1\n1603#2,9:150\n1855#2:159\n1856#2:164\n1612#2:165\n43#3,3:160\n1#4:163\n37#5,2:166\n*S KotlinDebug\n*F\n+ 1 ChunkManager.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexChunk\n*L\n132#1:150,9\n132#1:159\n132#1:164\n132#1:165\n134#1:160,3\n132#1:163\n143#1:166,2\n*E\n"})
public final class SharedIndexChunk
implements Disposable {
    @NotNull
    private final AttachChunkResult indexAttachChunkResult;
    @NotNull
    private final Pair<SharedIndexContentHashProvider, SharedIndexContentHashEnumerator>[] hashEnumerators;
    @NotNull
    private final HashSet<Project> attachedProjects;

    /*
     * WARNING - void declaration
     */
    public SharedIndexChunk(@NotNull Path chunkRootPath, @NotNull AttachChunkResult indexAttachChunkResult) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        Intrinsics.checkNotNullParameter((Object)indexAttachChunkResult, (String)"indexAttachChunkResult");
        this.indexAttachChunkResult = indexAttachChunkResult;
        Iterable iterable = SharedIndexHashProviders.getSortedSharedIndexHashingProviders();
        SharedIndexChunk sharedIndexChunk = this;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            block6: {
                Pair pair2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SharedIndexContentHashProvider it = (SharedIndexContentHashProvider)element$iv$iv;
                boolean bl2 = false;
                try {
                    boolean $i$f$service = false;
                    Class<SharedIndexHashStorages> serviceClass$iv = SharedIndexHashStorages.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                    }
                    SharedIndexContentHashEnumerator enumerator = ((SharedIndexHashStorages)object).openHashEnumerator(chunkRootPath, it.getInfo(), this);
                    if (enumerator == null) {
                        pair = null;
                        break block6;
                    }
                    pair2 = TuplesKt.to((Object)it, (Object)enumerator);
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    ChunkManagerKt.access$getLOG$p().warn("Failed to open enumerator for " + it.getInfo().getProviderId() + " from " + chunkRootPath + ". " + t.getMessage(), t);
                    pair2 = null;
                }
                pair = pair2;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        sharedIndexChunk.hashEnumerators = thisCollection$iv.toArray(new Pair[0]);
        this.attachedProjects = new HashSet();
    }

    @NotNull
    public final AttachChunkResult getIndexAttachChunkResult() {
        return this.indexAttachChunkResult;
    }

    public final int tryEnumerate(@NotNull IndexedFile fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        for (Pair<SharedIndexContentHashProvider, SharedIndexContentHashEnumerator> pair : this.hashEnumerators) {
            byte[] byArray;
            SharedIndexContentHashProvider hashProvider = (SharedIndexContentHashProvider)pair.component1();
            SharedIndexContentHashEnumerator hashEnumerator = (SharedIndexContentHashEnumerator)pair.component2();
            if (hashProvider.getInfo().getContentBased() != this.isContentBased(fileContent)) continue;
            try {
                if (hashProvider.computeHash(fileContent) == null) continue;
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Exception e) {
                ChunkManagerKt.access$getLOG$p().error((Throwable)e);
                continue;
            }
            byte[] hash = byArray;
            int hashId = hashEnumerator.tryEnumerate(hash);
            if (hashId == 0) continue;
            return hashId;
        }
        return 0;
    }

    public final void attachProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.attachedProjects.add(project);
    }

    public final void detachProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.attachedProjects.remove(project);
    }

    private final boolean isContentBased(IndexedFile $this$isContentBased) {
        return $this$isContentBased instanceof FileContentImpl;
    }

    @NotNull
    public final HashSet<Project> getAttachedProjects() {
        return this.attachedProjects;
    }

    public void dispose() {
    }
}

