/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.jdk;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.indexing.shared.java.jdk.JdkAliases;
import com.intellij.indexing.shared.java.jdk.JdkIndexLookupRequest;
import com.intellij.indexing.shared.java.jdk.JdkSupport;
import com.intellij.indexing.shared.java.jdk.SharedJdkChunkStoreEntry;
import com.intellij.indexing.shared.java.jdk.SharedJdkChunkStoreState;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="shared-index-jdk-hash", storages={@Storage(value="$CACHE_FILE$")}, allowLoadInTests=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u001e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/indexing/shared/java/jdk/SharedJdkChunkStore;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/indexing/shared/java/jdk/SharedJdkChunkStoreState;", "()V", "doComputeCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getDoComputeCounter", "()Ljava/util/concurrent/atomic/AtomicInteger;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "doComputeAliases", "", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "doComputeJdkRequest", "Lcom/intellij/indexing/shared/java/jdk/JdkIndexLookupRequest;", "getOrComputeJdkRequest", "loadState", "", "state", "registerDownloadingJdkRequest", "lookupName", "home", "Lcom/intellij/openapi/vfs/VirtualFile;", "newState", "snapshot", "FileInfo", "intellij.indexing.shared.java"})
@SourceDebugExtension(value={"SMAP\nSharedJdkChunkStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedJdkChunkStore.kt\ncom/intellij/indexing/shared/java/jdk/SharedJdkChunkStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class SharedJdkChunkStore
extends SimplePersistentStateComponent<SharedJdkChunkStoreState> {
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    @TestOnly
    @NotNull
    private final AtomicInteger doComputeCounter = new AtomicInteger();

    public SharedJdkChunkStore() {
        super((BaseState)new SharedJdkChunkStoreState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull SharedJdkChunkStoreState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            super.loadState((BaseState)state);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerDownloadingJdkRequest(@NotNull String lookupName, @NotNull VirtualFile home, @NotNull JdkIndexLookupRequest newState) {
        Intrinsics.checkNotNullParameter((Object)lookupName, (String)"lookupName");
        Intrinsics.checkNotNullParameter((Object)home, (String)"home");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        String snapshotHash = this.snapshot(home);
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            CollectionsKt.removeAll(((SharedJdkChunkStoreState)this.getState()).getEntries(), (Function1)((Function1)new Function1<SharedJdkChunkStoreEntry, Boolean>(snapshotHash){
                final /* synthetic */ String $snapshotHash;
                {
                    this.$snapshotHash = $snapshotHash;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SharedJdkChunkStoreEntry it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return Intrinsics.areEqual((Object)it.getSnapshotHash(), (Object)this.$snapshotHash);
                }
            }));
            ((SharedJdkChunkStoreState)this.getState()).getEntries().add(new SharedJdkChunkStoreEntry(lookupName, snapshotHash, newState));
            ((SharedJdkChunkStoreState)this.getState()).intIncrementModificationCount();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JdkIndexLookupRequest getOrComputeJdkRequest(@NotNull Sdk sdk) {
        Object object;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
                if (!JdkSupport.isJdk(sdk)) {
                    return null;
                }
                object = sdk.getHomeDirectory();
                if (object == null) break block11;
                VirtualFile it = object;
                boolean bl = false;
                String string = this.snapshot(it);
                object = string;
                if (string != null) break block12;
            }
            return null;
        }
        Object snapshotHash = object;
        Lock lock = this.lock;
        lock.lock();
        try {
            Object v2;
            block10: {
                boolean bl = false;
                Iterable iterable = ((SharedJdkChunkStoreState)this.getState()).getEntries();
                for (Object e : iterable) {
                    SharedJdkChunkStoreEntry it = (SharedJdkChunkStoreEntry)((Object)e);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getSnapshotHash(), (Object)snapshotHash)) continue;
                    v2 = e;
                    break block10;
                }
                v2 = null;
            }
            SharedJdkChunkStoreEntry sharedJdkChunkStoreEntry = v2;
            if (sharedJdkChunkStoreEntry != null) {
                SharedJdkChunkStoreEntry it = sharedJdkChunkStoreEntry;
                boolean bl = false;
                JdkIndexLookupRequest jdkIndexLookupRequest = it.toJdkIndexRequest();
                return jdkIndexLookupRequest;
            }
            JdkIndexLookupRequest newState = this.doComputeJdkRequest(sdk);
            List<SharedJdkChunkStoreEntry> list = ((SharedJdkChunkStoreState)this.getState()).getEntries();
            String string = sdk.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            list.add(new SharedJdkChunkStoreEntry(string, (String)snapshotHash, newState));
            ((SharedJdkChunkStoreState)this.getState()).intIncrementModificationCount();
            JdkIndexLookupRequest jdkIndexLookupRequest = newState;
            return jdkIndexLookupRequest;
        }
        finally {
            lock.unlock();
        }
    }

    private final JdkIndexLookupRequest doComputeJdkRequest(Sdk sdk) {
        if (!JdkSupport.isJdk(sdk)) {
            return null;
        }
        String jdkFingerprint = JdkSupport.computeJdkFingerprint(sdk);
        List<String> aliases = this.doComputeAliases(sdk);
        String string = sdk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new JdkIndexLookupRequest(((CharSequence)string).length() == 0 ? null : sdk.getName(), jdkFingerprint, aliases, null, 8, null);
    }

    @NotNull
    public final AtomicInteger getDoComputeCounter() {
        return this.doComputeCounter;
    }

    private final List<String> doComputeAliases(Sdk sdk) {
        this.doComputeCounter.incrementAndGet();
        return JdkAliases.INSTANCE.computeAliasesForJdk(sdk);
    }

    private final String snapshot(VirtualFile home) {
        TreeMap<String, FileInfo> allFiles2 = new TreeMap<String, FileInfo>();
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtil.visitChildrenRecursively((VirtualFile)home, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(allFiles2, optionArray){
            final /* synthetic */ TreeMap<String, FileInfo> $allFiles;
            {
                this.$allFiles = $allFiles;
                super($super_call_param$1);
            }

            public boolean visitFile(@NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!file.isDirectory()) {
                    Map map = this.$allFiles;
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    String string2 = string;
                    FileInfo fileInfo = new FileInfo(file.getLength(), file.getTimeStamp());
                    map.put(string2, fileInfo);
                }
                ProgressManager.checkCanceled();
                return super.visitFile(file);
            }
        }));
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putUnencodedChars((CharSequence)JdkSupport.getSupportedSdkType().getName());
        for (Map.Entry entry : ((Map)allFiles2).entrySet()) {
            String path = (String)entry.getKey();
            FileInfo info = (FileInfo)entry.getValue();
            hasher.putUnencodedChars((CharSequence)path);
            hasher.putLong(info.getSize());
            hasher.putLong(info.getTimestamp());
        }
        String string = hasher.hash().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/indexing/shared/java/jdk/SharedJdkChunkStore$FileInfo;", "", "size", "", "timestamp", "(JJ)V", "getSize", "()J", "getTimestamp", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.indexing.shared.java"})
    private static final class FileInfo {
        private final long size;
        private final long timestamp;

        public FileInfo(long size, long timestamp) {
            this.size = size;
            this.timestamp = timestamp;
        }

        public final long getSize() {
            return this.size;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final long component1() {
            return this.size;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final FileInfo copy(long size, long timestamp) {
            return new FileInfo(size, timestamp);
        }

        public static /* synthetic */ FileInfo copy$default(FileInfo fileInfo, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = fileInfo.size;
            }
            if ((n & 2) != 0) {
                l2 = fileInfo.timestamp;
            }
            return fileInfo.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "FileInfo(size=" + this.size + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.size);
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileInfo)) {
                return false;
            }
            FileInfo fileInfo = (FileInfo)other;
            if (this.size != fileInfo.size) {
                return false;
            }
            return this.timestamp == fileInfo.timestamp;
        }
    }
}

