/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.creator;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.maven.model.Model;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.artifact.Gav;
import org.sonatype.nexus.index.ArtifactAvailablility;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.IndexerField;
import org.sonatype.nexus.index.IndexerFieldVersion;
import org.sonatype.nexus.index.MAVEN;
import org.sonatype.nexus.index.NEXUS;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.creator.AbstractIndexCreator;
import org.sonatype.nexus.index.creator.LegacyDocumentUpdater;
import org.sonatype.nexus.index.locator.JavadocLocator;
import org.sonatype.nexus.index.locator.Locator;
import org.sonatype.nexus.index.locator.Sha1Locator;
import org.sonatype.nexus.index.locator.SignatureLocator;
import org.sonatype.nexus.index.locator.SourcesLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=IndexCreator.class, hint="min")
public class MinimalArtifactInfoIndexCreator
extends AbstractIndexCreator
implements LegacyDocumentUpdater {
    public static final String ID = "min";
    public static final IndexerField FLD_INFO = new IndexerField(NEXUS.INFO, IndexerFieldVersion.V1, "i", "Artifact INFO (not indexed, stored)", Field.Store.YES, Field.Index.NO);
    public static final IndexerField FLD_GROUP_ID_KW = new IndexerField(MAVEN.GROUP_ID, IndexerFieldVersion.V1, "g", "Artifact GroupID (as keyword)", Field.Store.NO, Field.Index.UN_TOKENIZED);
    public static final IndexerField FLD_GROUP_ID = new IndexerField(MAVEN.GROUP_ID, IndexerFieldVersion.V3, "groupId", "Artifact GroupID (tokenized)", Field.Store.NO, Field.Index.TOKENIZED);
    public static final IndexerField FLD_ARTIFACT_ID_KW = new IndexerField(MAVEN.ARTIFACT_ID, IndexerFieldVersion.V1, "a", "Artifact ArtifactID (as keyword)", Field.Store.NO, Field.Index.UN_TOKENIZED);
    public static final IndexerField FLD_ARTIFACT_ID = new IndexerField(MAVEN.ARTIFACT_ID, IndexerFieldVersion.V3, "artifactId", "Artifact ArtifactID (tokenized)", Field.Store.NO, Field.Index.TOKENIZED);
    public static final IndexerField FLD_VERSION_KW = new IndexerField(MAVEN.VERSION, IndexerFieldVersion.V1, "v", "Artifact Version (as keyword)", Field.Store.NO, Field.Index.UN_TOKENIZED);
    public static final IndexerField FLD_VERSION = new IndexerField(MAVEN.VERSION, IndexerFieldVersion.V3, "version", "Artifact Version (tokenized)", Field.Store.NO, Field.Index.TOKENIZED);
    public static final IndexerField FLD_PACKAGING = new IndexerField(MAVEN.PACKAGING, IndexerFieldVersion.V1, "p", "Artifact Packaging (as keyword)", Field.Store.NO, Field.Index.UN_TOKENIZED);
    public static final IndexerField FLD_CLASSIFIER = new IndexerField(MAVEN.CLASSIFIER, IndexerFieldVersion.V1, "l", "Artifact classifier (as keyword)", Field.Store.NO, Field.Index.UN_TOKENIZED);
    public static final IndexerField FLD_NAME = new IndexerField(MAVEN.NAME, IndexerFieldVersion.V1, "n", "Artifact name (tokenized, stored)", Field.Store.YES, Field.Index.TOKENIZED);
    public static final IndexerField FLD_DESCRIPTION = new IndexerField(MAVEN.DESCRIPTION, IndexerFieldVersion.V1, "d", "Artifact description (tokenized, stored)", Field.Store.YES, Field.Index.TOKENIZED);
    public static final IndexerField FLD_LAST_MODIFIED = new IndexerField(MAVEN.LAST_MODIFIED, IndexerFieldVersion.V1, "m", "Artifact last modified (not indexed, stored)", Field.Store.YES, Field.Index.NO);
    public static final IndexerField FLD_SHA1 = new IndexerField(MAVEN.SHA1, IndexerFieldVersion.V1, "1", "Artifact SHA1 checksum (as keyword, stored)", Field.Store.YES, Field.Index.UN_TOKENIZED);
    private Locator jl = new JavadocLocator();
    private Locator sl = new SourcesLocator();
    private Locator sigl = new SignatureLocator();
    private Locator sha1l = new Sha1Locator();

    @Override
    public void populateArtifactInfo(ArtifactContext ac) {
        Model model;
        File artifact = ac.getArtifact();
        File pom = ac.getPom();
        ArtifactInfo ai = ac.getArtifactInfo();
        if (pom != null) {
            ai.lastModified = pom.lastModified();
            ai.fextension = "pom";
        }
        if (pom != null) {
            if (ai.classifier != null) {
                ai.sourcesExists = ArtifactAvailablility.NOT_AVAILABLE;
                ai.javadocExists = ArtifactAvailablility.NOT_AVAILABLE;
            } else {
                File sources = this.sl.locate(pom);
                ai.sourcesExists = !sources.exists() ? ArtifactAvailablility.NOT_PRESENT : ArtifactAvailablility.PRESENT;
                File javadoc = this.jl.locate(pom);
                ai.javadocExists = !javadoc.exists() ? ArtifactAvailablility.NOT_PRESENT : ArtifactAvailablility.PRESENT;
            }
        }
        if ((model = ac.getPomModel()) != null) {
            ai.name = model.getName();
            ai.description = model.getDescription();
            if (ai.classifier == null && model.getPackaging() != null) {
                ai.packaging = model.getPackaging();
            }
        }
        if ("pom".equals(ai.packaging)) {
            artifact = pom;
        }
        if (artifact != null) {
            File signature = this.sigl.locate(artifact);
            ai.signatureExists = signature.exists() ? ArtifactAvailablility.PRESENT : ArtifactAvailablility.NOT_PRESENT;
            File sha1 = this.sha1l.locate(artifact);
            if (sha1.exists()) {
                try {
                    ai.sha1 = StringUtils.chomp((String)FileUtils.fileRead((File)sha1)).trim().split(" ")[0];
                }
                catch (IOException e) {
                    ac.addError(e);
                }
            }
            ai.lastModified = artifact.lastModified();
            ai.size = artifact.length();
            ai.fextension = this.getExtension(artifact, ac.getGav());
            if (ai.packaging == null) {
                ai.packaging = ai.fextension;
            }
        }
    }

    private String getExtension(File artifact, Gav gav) {
        if (gav != null && StringUtils.isNotBlank((String)gav.getExtension())) {
            return gav.getExtension();
        }
        String artifactFileName = artifact.getName().toLowerCase();
        if (artifactFileName.endsWith("tar.gz")) {
            return "tar.gz";
        }
        if (artifactFileName.equals("tar.bz2")) {
            return "tar.bz2";
        }
        return FileUtils.getExtension((String)artifactFileName);
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
        String info = ai.packaging + "|" + Long.toString(ai.lastModified) + "|" + Long.toString(ai.size) + "|" + ai.sourcesExists.toString() + "|" + ai.javadocExists.toString() + "|" + ai.signatureExists.toString() + "|" + ai.fextension;
        doc.add((Fieldable)FLD_INFO.toField(info));
        doc.add((Fieldable)FLD_GROUP_ID_KW.toField(ai.groupId));
        doc.add((Fieldable)FLD_ARTIFACT_ID_KW.toField(ai.artifactId));
        doc.add((Fieldable)FLD_VERSION_KW.toField(ai.version));
        doc.add((Fieldable)FLD_GROUP_ID.toField(ai.groupId));
        doc.add((Fieldable)FLD_ARTIFACT_ID.toField(ai.artifactId));
        doc.add((Fieldable)FLD_VERSION.toField(ai.version));
        if (ai.name != null) {
            doc.add((Fieldable)FLD_NAME.toField(ai.name));
        }
        if (ai.description != null) {
            doc.add((Fieldable)FLD_DESCRIPTION.toField(ai.description));
        }
        if (ai.packaging != null) {
            doc.add((Fieldable)FLD_PACKAGING.toField(ai.packaging));
        }
        if (ai.classifier != null) {
            doc.add((Fieldable)FLD_CLASSIFIER.toField(ai.classifier));
        }
        if (ai.sha1 != null) {
            doc.add((Fieldable)FLD_SHA1.toField(ai.sha1));
        }
    }

    @Override
    public void updateLegacyDocument(ArtifactInfo ai, Document doc) {
        this.updateDocument(ai, doc);
        if (ai.prefix != null) {
            doc.add((Fieldable)new Field(ArtifactInfo.PLUGIN_PREFIX, ai.prefix, Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        if (ai.goals != null) {
            doc.add((Fieldable)new Field(ArtifactInfo.PLUGIN_GOALS, ArtifactInfo.lst2str(ai.goals), Field.Store.YES, Field.Index.NO));
        }
        doc.removeField(ArtifactInfo.GROUP_ID);
        doc.add((Fieldable)new Field(ArtifactInfo.GROUP_ID, ai.groupId, Field.Store.NO, Field.Index.UN_TOKENIZED));
    }

    @Override
    public boolean updateArtifactInfo(Document doc, ArtifactInfo ai) {
        String sha1;
        String description;
        String name;
        String info;
        boolean res = false;
        String uinfo = doc.get(ArtifactInfo.UINFO);
        if (uinfo != null) {
            String[] r = ArtifactInfo.FS_PATTERN.split(uinfo);
            ai.groupId = r[0];
            ai.artifactId = r[1];
            ai.version = r[2];
            if (r.length > 3) {
                ai.classifier = ArtifactInfo.renvl(r[3]);
            }
            res = true;
        }
        if ((info = doc.get(ArtifactInfo.INFO)) != null) {
            String[] r = ArtifactInfo.FS_PATTERN.split(info);
            ai.packaging = r[0];
            ai.lastModified = Long.parseLong(r[1]);
            ai.size = Long.parseLong(r[2]);
            ai.sourcesExists = ArtifactAvailablility.fromString(r[3]);
            ai.javadocExists = ArtifactAvailablility.fromString(r[4]);
            ai.signatureExists = ArtifactAvailablility.fromString(r[5]);
            ai.fextension = r.length > 6 ? r[6] : (ai.classifier != null || "pom".equals(ai.packaging) || "war".equals(ai.packaging) || "ear".equals(ai.packaging) ? ai.packaging : "jar");
            res = true;
        }
        if ((name = doc.get(ArtifactInfo.NAME)) != null) {
            ai.name = name;
            res = true;
        }
        if ((description = doc.get(ArtifactInfo.DESCRIPTION)) != null) {
            ai.description = description;
            res = true;
        }
        if ("null".equals(ai.packaging)) {
            ai.packaging = null;
        }
        if ((sha1 = doc.get(ArtifactInfo.SHA1)) != null) {
            ai.sha1 = sha1;
        }
        return res;
    }

    public String toString() {
        return ID;
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_INFO, FLD_GROUP_ID_KW, FLD_GROUP_ID, FLD_ARTIFACT_ID_KW, FLD_ARTIFACT_ID, FLD_VERSION_KW, FLD_VERSION, FLD_PACKAGING, FLD_CLASSIFIER, FLD_NAME, FLD_DESCRIPTION, FLD_LAST_MODIFIED, FLD_SHA1);
    }
}

