/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.util.ArrayUtil;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.FileKeyDescriptor;
import org.jetbrains.jps.incremental.storage.StampsStorage;

public final class FileTimestampStorage
extends AbstractStateStorage<File, TimestampPerTarget[]>
implements StampsStorage<Timestamp> {
    private final BuildTargetsState myTargetsState;
    private final File myTimestampsRoot;

    public FileTimestampStorage(File dataStorageRoot, BuildTargetsState targetsState) throws IOException {
        super(new File(FileTimestampStorage.calcStorageRoot(dataStorageRoot), "data"), new FileKeyDescriptor(), new StateExternalizer());
        this.myTimestampsRoot = FileTimestampStorage.calcStorageRoot(dataStorageRoot);
        this.myTargetsState = targetsState;
    }

    @NotNull
    private static File calcStorageRoot(File dataStorageRoot) {
        return new File(dataStorageRoot, "timestamps");
    }

    @Override
    public File getStorageRoot() {
        return this.myTimestampsRoot;
    }

    @Override
    public Timestamp getPreviousStamp(File file, BuildTarget<?> target) throws IOException {
        TimestampPerTarget[] state = (TimestampPerTarget[])this.getState(file);
        if (state != null) {
            int targetId = this.myTargetsState.getBuildTargetId(target);
            for (TimestampPerTarget timestampPerTarget : state) {
                if (timestampPerTarget.targetId != targetId) continue;
                return Timestamp.fromLong(timestampPerTarget.timestamp);
            }
        }
        return Timestamp.MINUS_ONE;
    }

    @Override
    public Timestamp getCurrentStamp(File file) {
        return Timestamp.fromLong(FSOperations.lastModified(file));
    }

    @Override
    public boolean isDirtyStamp(@NotNull StampsStorage.Stamp stamp, File file) {
        if (stamp == null) {
            FileTimestampStorage.$$$reportNull$$$0(0);
        }
        if (!(stamp instanceof Timestamp)) {
            return true;
        }
        return ((Timestamp)stamp).myTimestamp != FSOperations.lastModified(file);
    }

    @Override
    public boolean isDirtyStamp(StampsStorage.Stamp stamp, File file, @NotNull BasicFileAttributes attrs) {
        if (attrs == null) {
            FileTimestampStorage.$$$reportNull$$$0(1);
        }
        if (!(stamp instanceof Timestamp)) {
            return true;
        }
        Timestamp timestamp = (Timestamp)stamp;
        return attrs.isRegularFile() ? attrs.lastModifiedTime().toMillis() != timestamp.myTimestamp : this.isDirtyStamp(timestamp, file);
    }

    @Override
    public void saveStamp(File file, BuildTarget<?> buildTarget, Timestamp stamp) throws IOException {
        int targetId = this.myTargetsState.getBuildTargetId(buildTarget);
        this.update(file, FileTimestampStorage.updateTimestamp((TimestampPerTarget[])this.getState(file), targetId, stamp.asLong()));
    }

    private static TimestampPerTarget @NotNull [] updateTimestamp(TimestampPerTarget[] oldState, int targetId, long timestamp) {
        TimestampPerTarget newItem = new TimestampPerTarget(targetId, timestamp);
        if (oldState == null) {
            TimestampPerTarget[] timestampPerTargetArray = new TimestampPerTarget[]{newItem};
            if (timestampPerTargetArray == null) {
                FileTimestampStorage.$$$reportNull$$$0(2);
            }
            return timestampPerTargetArray;
        }
        int length = oldState.length;
        for (int i = 0; i < length; ++i) {
            if (oldState[i].targetId != targetId) continue;
            oldState[i] = newItem;
            if (oldState == null) {
                FileTimestampStorage.$$$reportNull$$$0(3);
            }
            return oldState;
        }
        TimestampPerTarget[] timestampPerTargetArray = (TimestampPerTarget[])ArrayUtil.append((Object[])oldState, (Object)newItem);
        if (timestampPerTargetArray == null) {
            FileTimestampStorage.$$$reportNull$$$0(4);
        }
        return timestampPerTargetArray;
    }

    @Override
    public void removeStamp(File file, BuildTarget<?> buildTarget) throws IOException {
        Object[] state = (TimestampPerTarget[])this.getState(file);
        if (state != null) {
            int targetId = this.myTargetsState.getBuildTargetId(buildTarget);
            for (int i = 0; i < state.length; ++i) {
                TimestampPerTarget timestampPerTarget = state[i];
                if (timestampPerTarget.targetId != targetId) continue;
                if (state.length == 1) {
                    this.remove(file);
                    continue;
                }
                TimestampPerTarget[] newState = (TimestampPerTarget[])ArrayUtil.remove((Object[])state, (int)i);
                this.update(file, newState);
                break;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stamp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/FileTimestampStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/FileTimestampStorage";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateTimestamp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDirtyStamp";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class StateExternalizer
    implements DataExternalizer<TimestampPerTarget[]> {
        private StateExternalizer() {
        }

        public void save(@NotNull DataOutput out, TimestampPerTarget[] value) throws IOException {
            if (out == null) {
                StateExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.length);
            for (TimestampPerTarget target : value) {
                out.writeInt(target.targetId);
                out.writeLong(target.timestamp);
            }
        }

        public TimestampPerTarget[] read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                StateExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            TimestampPerTarget[] targets = new TimestampPerTarget[size];
            for (int i = 0; i < size; ++i) {
                int id = in.readInt();
                long timestamp = in.readLong();
                targets[i] = new TimestampPerTarget(id, timestamp);
            }
            return targets;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/storage/FileTimestampStorage$StateExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class TimestampPerTarget {
        public final int targetId;
        public final long timestamp;

        private TimestampPerTarget(int targetId, long timestamp) {
            this.targetId = targetId;
            this.timestamp = timestamp;
        }
    }

    static final class Timestamp
    implements StampsStorage.Stamp {
        static final Timestamp MINUS_ONE = new Timestamp(-1L);
        private final long myTimestamp;

        Timestamp(long timestamp) {
            this.myTimestamp = timestamp;
        }

        long asLong() {
            return this.myTimestamp;
        }

        static Timestamp fromLong(long l) {
            return new Timestamp(l);
        }

        public String toString() {
            return "Timestamp{myTimestamp=" + this.myTimestamp + "}";
        }
    }
}

