/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.TypeRepr;

public class Proto {
    private final JVMFlags access;
    private final String signature;
    private final String name;
    @NotNull
    private final Iterable<TypeRepr.ClassType> annotations;

    public Proto(@NotNull JVMFlags flags, String signature, String name, @NotNull Iterable<TypeRepr.ClassType> annotations) {
        if (flags == null) {
            Proto.$$$reportNull$$$0(0);
        }
        if (annotations == null) {
            Proto.$$$reportNull$$$0(1);
        }
        this.access = flags;
        this.signature = signature == null ? "" : signature;
        this.name = name == null ? "" : name;
        this.annotations = annotations;
    }

    public JVMFlags getFlags() {
        return this.access;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getName() {
        return this.name;
    }

    @NotNull
    public Iterable<TypeRepr.ClassType> getAnnotations() {
        Iterable<TypeRepr.ClassType> iterable = this.annotations;
        if (iterable == null) {
            Proto.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    public final boolean isPublic() {
        return this.getFlags().isPublic();
    }

    public final boolean isProtected() {
        return this.getFlags().isProtected();
    }

    public final boolean isPackageLocal() {
        return this.getFlags().isPackageLocal();
    }

    public final boolean isPrivate() {
        return this.getFlags().isPrivate();
    }

    public final boolean isAbstract() {
        return this.getFlags().isAbstract();
    }

    public final boolean isBridge() {
        return this.getFlags().isBridge();
    }

    public final boolean isSynthetic() {
        return this.getFlags().isSynthetic();
    }

    public final boolean isAnnotation() {
        return this.getFlags().isAnnotation();
    }

    public final boolean isFinal() {
        return this.getFlags().isFinal();
    }

    public final boolean isStatic() {
        return this.getFlags().isStatic();
    }

    public final boolean isMoreAccessibleThan(Proto anotherProto) {
        if (anotherProto.isPrivate()) {
            return this.isPackageLocal() || this.isProtected() || this.isPublic();
        }
        if (anotherProto.isPackageLocal()) {
            return this.isProtected() || this.isPublic();
        }
        if (anotherProto.isProtected()) {
            return this.isPublic();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/Proto";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/Proto";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Diff<V extends Proto>
    implements Difference {
        protected final V myPast;
        final /* synthetic */ Proto this$0;

        public Diff(V past) {
            this.this$0 = this$0;
            this.myPast = past;
        }

        @Override
        public boolean unchanged() {
            return !this.flagsChanged() && !this.signatureChanged() && this.annotations().unchanged();
        }

        public boolean flagsChanged() {
            return !((Proto)this.myPast).getFlags().equals(this.this$0.getFlags());
        }

        public JVMFlags getAddedFlags() {
            return this.this$0.getFlags().deriveAdded(((Proto)this.myPast).getFlags());
        }

        public JVMFlags getRemovedFlags() {
            return this.this$0.getFlags().deriveRemoved(((Proto)this.myPast).getFlags());
        }

        public boolean becamePackageLocal() {
            return !((Proto)this.myPast).isPackageLocal() && this.this$0.isPackageLocal();
        }

        public boolean accessRestricted() {
            return this.this$0.getFlags().isWeakerAccess(((Proto)this.myPast).getFlags());
        }

        public boolean accessExpanded() {
            return ((Proto)this.myPast).getFlags().isWeakerAccess(this.this$0.getFlags());
        }

        public boolean signatureChanged() {
            return !Objects.equals(((Proto)this.myPast).getSignature(), this.this$0.getSignature());
        }

        public Difference.Specifier<TypeRepr.ClassType, ?> annotations() {
            return Difference.diff(((Proto)this.myPast).getAnnotations(), this.this$0.getAnnotations());
        }
    }
}

