/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl.serializer;

import com.intellij.serialization.SerializationException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.jps.dependency.SerializableGraphElement;
import org.jetbrains.jps.dependency.impl.serializer.NodeSerializerImpl;
import org.jetbrains.jps.dependency.impl.serializer.SerializerUtil;
import org.jetbrains.jps.dependency.java.JvmClass;

public final class JvmClassNodeSerializerImpl
extends NodeSerializerImpl<JvmClass> {
    public JvmClassNodeSerializerImpl() {
        super(JvmClass.class);
    }

    @Override
    public <T extends SerializableGraphElement> void write(T elem, DataOutput out) throws IOException {
        if (!(elem instanceof JvmClass)) {
            throw new SerializationException("Wrong serializer. Expected an object of type JvmClass, but received " + elem.getClass().getName());
        }
        JvmClass jvmClass = (JvmClass)elem;
        SerializerUtil.writeJvmClass(jvmClass, out);
    }

    @Override
    public <T extends SerializableGraphElement> T read(DataInput in) throws IOException {
        return (T)SerializerUtil.readJvmClass(in);
    }
}

