/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.Delta;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.impl.Containers;
import org.jetbrains.jps.dependency.impl.GraphImpl;
import org.jetbrains.jps.dependency.java.SubclassesIndex;
import org.jetbrains.jps.javac.Iterators;

public final class DeltaImpl
extends GraphImpl
implements Delta {
    private final Set<NodeSource> myBaseSources;
    private final Set<NodeSource> myDeletedSources;

    public DeltaImpl(Set<NodeSource> baseSources, Iterable<NodeSource> deletedSources) {
        super(Containers.MEMORY_CONTAINER_FACTORY);
        this.addIndex(new SubclassesIndex(Containers.MEMORY_CONTAINER_FACTORY));
        this.myBaseSources = Collections.unmodifiableSet(baseSources);
        this.myDeletedSources = Collections.unmodifiableSet((Set)Iterators.collect(deletedSources, new HashSet()));
    }

    @Override
    public Set<NodeSource> getBaseSources() {
        return this.myBaseSources;
    }

    @Override
    public Set<NodeSource> getDeletedSources() {
        return this.myDeletedSources;
    }

    @Override
    public void associate(@NotNull Node<?, ?> node, @NotNull Iterable<NodeSource> sources) {
        if (node == null) {
            DeltaImpl.$$$reportNull$$$0(0);
        }
        if (sources == null) {
            DeltaImpl.$$$reportNull$$$0(1);
        }
        ReferenceID nodeID = node.getReferenceID();
        for (NodeSource src : sources) {
            this.myNodeToSourcesMap.appendValue(nodeID, src);
            this.mySourceToNodesMap.appendValue(src, node);
        }
        for (BackDependencyIndex index : this.getIndices()) {
            index.indexNode(node);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sources";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/dependency/impl/DeltaImpl";
        objectArray[2] = "associate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

