/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.MapletFactory;
import org.jetbrains.jps.dependency.MultiMaplet;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.javac.Iterators;

public abstract class BackDependencyIndexImpl
implements BackDependencyIndex {
    private final String myName;
    private final MultiMaplet<ReferenceID, ReferenceID> myMap;

    protected BackDependencyIndexImpl(@NotNull String name, @NotNull MapletFactory cFactory) {
        if (name == null) {
            BackDependencyIndexImpl.$$$reportNull$$$0(0);
        }
        if (cFactory == null) {
            BackDependencyIndexImpl.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myMap = cFactory.createSetMultiMaplet(name);
    }

    protected abstract Iterable<ReferenceID> getIndexedDependencies(@NotNull Node<?, ?> var1);

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            BackDependencyIndexImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public Iterable<ReferenceID> getDependencies(@NotNull ReferenceID id) {
        Iterable<ReferenceID> nodes;
        if (id == null) {
            BackDependencyIndexImpl.$$$reportNull$$$0(3);
        }
        Iterable<ReferenceID> iterable = (nodes = this.myMap.get(id)) != null ? nodes : Collections.emptyList();
        if (iterable == null) {
            BackDependencyIndexImpl.$$$reportNull$$$0(4);
        }
        return iterable;
    }

    @Override
    public void indexNode(@NotNull Node<?, ?> node) {
        if (node == null) {
            BackDependencyIndexImpl.$$$reportNull$$$0(5);
        }
        ReferenceID nodeID = node.getReferenceID();
        for (ReferenceID referentId : this.getIndexedDependencies(node)) {
            this.myMap.appendValue(referentId, nodeID);
        }
    }

    @Override
    public void integrate(Iterable<Node<?, ?>> deletedNodes, Iterable<Node<?, ?>> updatedNodes, Iterable<Pair<ReferenceID, Iterable<ReferenceID>>> indexDelta) {
        HashMap<ReferenceID, Set<ReferenceID>> depsToRemove = new HashMap<ReferenceID, Set<ReferenceID>>();
        for (Node<?, ?> node : deletedNodes) {
            this.cleanupDependencies(node, depsToRemove);
            this.myMap.remove(node.getReferenceID());
        }
        for (Node<?, ?> node : updatedNodes) {
            this.cleanupDependencies(node, depsToRemove);
        }
        for (Pair pair : indexDelta) {
            ReferenceID nodeID = (ReferenceID)pair.getFirst();
            Set deps = (Set)Iterators.collect(this.getDependencies(nodeID), new HashSet());
            Iterable toRemove = (Iterable)depsToRemove.get(nodeID);
            if (toRemove != null) {
                for (ReferenceID d : toRemove) {
                    deps.remove(d);
                }
            }
            this.myMap.put(nodeID, Iterators.collect((Iterable)((Iterable)pair.getSecond()), (Collection)deps));
        }
    }

    private void cleanupDependencies(Node<?, ?> node, Map<ReferenceID, Set<ReferenceID>> depsToRemove) {
        ReferenceID nodeID = node.getReferenceID();
        for (ReferenceID referentId : this.getIndexedDependencies(node)) {
            Set<ReferenceID> deps = depsToRemove.get(referentId);
            if (deps == null) {
                deps = new HashSet<ReferenceID>();
                depsToRemove.put(referentId, deps);
            }
            deps.add(nodeID);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cFactory";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/impl/BackDependencyIndexImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/impl/BackDependencyIndexImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "indexNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

