/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileRepr;
import org.jetbrains.jps.builders.java.dependencyView.ClassRepr;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.ElemType;
import org.jetbrains.jps.builders.java.dependencyView.FieldRepr;
import org.jetbrains.jps.builders.java.dependencyView.MethodRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModulePackageRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModuleRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModuleRequiresRepr;
import org.jetbrains.jps.builders.java.dependencyView.ParamAnnotation;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

final class ClassfileAnalyzer {
    private static final Logger LOG = Logger.getInstance(ClassfileAnalyzer.class);
    public static final String LAMBDA_FACTORY_CLASS = "java/lang/invoke/LambdaMetafactory";
    private static final String KOTLIN_LAMBDA_USAGE_CLASS_MARKER = "$sam$";
    private static final int ASM_API_VERSION = 589824;
    private final DependencyContext myContext;

    ClassfileAnalyzer(DependencyContext context) {
        this.myContext = context;
    }

    public ClassFileRepr analyze(int fileName, ClassReader cr, boolean isGenerated) {
        ClassCrawler visitor = new ClassCrawler(fileName, isGenerated);
        try {
            cr.accept((ClassVisitor)visitor, 0);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Corrupted .class file: " + this.myContext.getValue(fileName), e);
        }
        return visitor.getResult();
    }

    private final class ClassCrawler
    extends ClassVisitor {
        private final SignatureVisitor mySignatureCrawler;
        private final SignatureVisitor mySignatureWithGenericBoundUsageCrawler;
        private boolean myTakeIntoAccount;
        private boolean myIsModule;
        private final int myFileName;
        private final boolean myIsGenerated;
        private int myAccess;
        private int myName;
        private int myVersion;
        private String mySuperClass;
        private String[] myInterfaces;
        private String mySignature;
        private final Ref<String> myClassNameHolder;
        private final Ref<String> myOuterClassName;
        private final Ref<Boolean> myLocalClassFlag;
        private final Ref<Boolean> myAnonymousClassFlag;
        private final Set<MethodRepr> myMethods;
        private final Set<FieldRepr> myFields;
        private final Set<UsageRepr.Usage> myUsages;
        private final Set<ElemType> myTargets;
        private RetentionPolicy myRetentionPolicy;
        private final Map<TypeRepr.ClassType, IntSet> myAnnotationArguments;
        private final Map<TypeRepr.ClassType, Set<ElemType>> myAnnotationTargets;
        private final Set<TypeRepr.ClassType> myAnnotations;
        private final Set<ModuleRequiresRepr> myModuleRequires;
        private final Set<ModulePackageRepr> myModuleExports;

        private void processSignature(String sig) {
            if (sig != null) {
                try {
                    new SignatureReader(sig).accept(this.mySignatureCrawler);
                }
                catch (Exception e) {
                    LOG.info("Problems parsing signature \"" + sig + "\" in " + ClassfileAnalyzer.this.myContext.getValue(this.myFileName), (Throwable)e);
                }
            }
        }

        ClassCrawler(int fn, boolean isGenerated) {
            super(589824);
            this.mySignatureCrawler = new BaseSignatureVisitor(){

                @Override
                public SignatureVisitor visitClassBound() {
                    return ClassCrawler.this.mySignatureWithGenericBoundUsageCrawler;
                }

                @Override
                public SignatureVisitor visitInterfaceBound() {
                    return ClassCrawler.this.mySignatureWithGenericBoundUsageCrawler;
                }

                @Override
                public SignatureVisitor visitTypeArgument(char wildcard) {
                    return wildcard == '+' || wildcard == '-' ? ClassCrawler.this.mySignatureWithGenericBoundUsageCrawler : super.visitTypeArgument(wildcard);
                }
            };
            this.mySignatureWithGenericBoundUsageCrawler = new BaseSignatureVisitor(){

                @Override
                public void visitClassType(String name) {
                    int className = ClassfileAnalyzer.this.myContext.get(name);
                    ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, className));
                    ClassCrawler.this.myUsages.add(UsageRepr.createClassAsGenericBoundUsage(ClassfileAnalyzer.this.myContext, className));
                }
            };
            this.myTakeIntoAccount = false;
            this.myIsModule = false;
            this.myClassNameHolder = Ref.create();
            this.myOuterClassName = Ref.create();
            this.myLocalClassFlag = Ref.create((Object)false);
            this.myAnonymousClassFlag = Ref.create((Object)false);
            this.myMethods = new HashSet<MethodRepr>();
            this.myFields = new HashSet<FieldRepr>();
            this.myUsages = new HashSet<UsageRepr.Usage>();
            this.myTargets = EnumSet.noneOf(ElemType.class);
            this.myRetentionPolicy = null;
            this.myAnnotationArguments = new HashMap<TypeRepr.ClassType, IntSet>();
            this.myAnnotationTargets = new HashMap<TypeRepr.ClassType, Set<ElemType>>();
            this.myAnnotations = new HashSet<TypeRepr.ClassType>();
            this.myModuleRequires = new HashSet<ModuleRequiresRepr>();
            this.myModuleExports = new HashSet<ModulePackageRepr>();
            this.myFileName = fn;
            this.myIsGenerated = isGenerated;
        }

        private boolean notPrivate(int access) {
            return (access & 2) == 0;
        }

        public ClassFileRepr getResult() {
            if (!this.myTakeIntoAccount) {
                return null;
            }
            if (this.myIsModule) {
                return new ModuleRepr(ClassfileAnalyzer.this.myContext, this.myAccess, this.myVersion, this.myFileName, this.myName, this.myModuleRequires, this.myModuleExports, this.myUsages);
            }
            return new ClassRepr(ClassfileAnalyzer.this.myContext, this.myAccess, this.myFileName, this.myName, ClassfileAnalyzer.this.myContext.get(this.mySignature), ClassfileAnalyzer.this.myContext.get(this.mySuperClass), this.myInterfaces, this.myFields, this.myMethods, this.myAnnotations, this.myTargets, this.myRetentionPolicy, ClassfileAnalyzer.this.myContext.get((String)this.myOuterClassName.get()), (Boolean)this.myLocalClassFlag.get(), (Boolean)this.myAnonymousClassFlag.get(), this.myUsages, this.myIsGenerated);
        }

        public void visit(int version, int access, String name, String sig, String superName, String[] interfaces) {
            this.myTakeIntoAccount = this.notPrivate(access);
            this.myAccess = access;
            this.myName = ClassfileAnalyzer.this.myContext.get(name);
            this.myVersion = version;
            this.mySignature = sig;
            this.mySuperClass = superName;
            this.myInterfaces = interfaces;
            this.myClassNameHolder.set((Object)name);
            if (this.mySuperClass != null) {
                int superclassName = ClassfileAnalyzer.this.myContext.get(this.mySuperClass);
                this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, superclassName));
            }
            if (this.myInterfaces != null) {
                for (String it : this.myInterfaces) {
                    int interfaceName = ClassfileAnalyzer.this.myContext.get(it);
                    this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, interfaceName));
                }
            }
            this.processSignature(sig);
        }

        public void visitEnd() {
            for (Map.Entry<TypeRepr.ClassType, Set<ElemType>> entry : this.myAnnotationTargets.entrySet()) {
                TypeRepr.ClassType type = entry.getKey();
                Set<ElemType> targets = entry.getValue();
                IntSet usedArguments = this.myAnnotationArguments.get(type);
                this.myUsages.add(UsageRepr.createAnnotationUsage(ClassfileAnalyzer.this.myContext, type, usedArguments, targets));
            }
        }

        public ModuleVisitor visitModule(String name, int access, String version) {
            this.myIsModule = true;
            this.myAccess = access;
            this.myName = ClassfileAnalyzer.this.myContext.get(name);
            this.myVersion = ClassfileAnalyzer.this.myContext.get(version);
            return new ModuleCrawler();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals("Ljava/lang/annotation/Target;")) {
                return new AnnotationTargetCrawler();
            }
            if (desc.equals("Ljava/lang/annotation/Retention;")) {
                return new AnnotationRetentionPolicyCrawler();
            }
            TypeRepr.ClassType annotationType = (TypeRepr.ClassType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, desc);
            this.myAnnotations.add(annotationType);
            return new AnnotationCrawler(annotationType, (this.myAccess & 0x2000) > 0 ? ElemType.ANNOTATION_TYPE : ElemType.TYPE);
        }

        public void visitSource(String source, String debug) {
        }

        public FieldVisitor visitField(final int access, final String name, final String desc, final String signature, final Object value) {
            this.processSignature(signature);
            return new FieldVisitor(589824){
                final Set<TypeRepr.ClassType> annotations;
                {
                    super(arg0);
                    this.annotations = new HashSet<TypeRepr.ClassType>();
                }

                public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                    TypeRepr.ClassType annotation = (TypeRepr.ClassType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, desc2);
                    this.annotations.add(annotation);
                    return new AnnotationCrawler(annotation, ElemType.FIELD);
                }

                public void visitEnd() {
                    try {
                        super.visitEnd();
                    }
                    finally {
                        if ((access & 0x1000) == 0) {
                            ClassCrawler.this.myFields.add(new FieldRepr(ClassfileAnalyzer.this.myContext, access, ClassfileAnalyzer.this.myContext.get(name), ClassfileAnalyzer.this.myContext.get(desc), ClassfileAnalyzer.this.myContext.get(signature), this.annotations, value));
                        }
                    }
                }
            };
        }

        public MethodVisitor visitMethod(final int access, final String n, final String desc, final String signature, final String[] exceptions) {
            final Ref defaultValue = Ref.create();
            final HashSet annotations = new HashSet();
            final HashSet paramAnnotations = new HashSet();
            this.processSignature(signature);
            return new MethodVisitor(589824){

                public void visitEnd() {
                    if ((access & 0x1000) == 0 || (access & 0x40) > 0) {
                        ClassCrawler.this.myMethods.add(new MethodRepr(ClassfileAnalyzer.this.myContext, access, ClassfileAnalyzer.this.myContext.get(n), ClassfileAnalyzer.this.myContext.get(signature), desc, annotations, paramAnnotations, exceptions, defaultValue.get()));
                    }
                }

                public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                    TypeRepr.ClassType annoType = (TypeRepr.ClassType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, desc2);
                    annotations.add(annoType);
                    return new AnnotationCrawler(annoType, "<init>".equals(n) ? ElemType.CONSTRUCTOR : ElemType.METHOD);
                }

                public AnnotationVisitor visitAnnotationDefault() {
                    return new AnnotationVisitor(589824){
                        @Nullable
                        private List<Object> myAcc;

                        public void visit(String name, Object value) {
                            this.collectValue(value);
                        }

                        public void visitEnum(String name, String desc, String value) {
                            this.collectValue(value);
                        }

                        public AnnotationVisitor visitArray(String name) {
                            this.myAcc = new SmartList();
                            return this;
                        }

                        public void visitEnd() {
                            if (this.myAcc != null) {
                                Object elem;
                                Object[] template = null;
                                if (!this.myAcc.isEmpty() && (elem = this.myAcc.get(0)) != null) {
                                    template = ArrayUtil.newArray(elem.getClass(), (int)0);
                                }
                                defaultValue.set((Object)(template != null ? this.myAcc.toArray(template) : this.myAcc.toArray()));
                            }
                        }

                        private void collectValue(Object value) {
                            if (this.myAcc != null) {
                                this.myAcc.add(value);
                            } else {
                                defaultValue.set(value);
                            }
                        }
                    };
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc2, boolean visible) {
                    TypeRepr.ClassType annoType = (TypeRepr.ClassType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, desc2);
                    paramAnnotations.add(new ParamAnnotation(parameter, annoType));
                    return new AnnotationCrawler(annoType, ElemType.PARAMETER);
                }

                public void visitLdcInsn(Object cst) {
                    if (cst instanceof Type) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(((Type)cst).getInternalName())));
                    }
                    super.visitLdcInsn(cst);
                }

                public void visitMultiANewArrayInsn(String desc2, int dims) {
                    TypeRepr.ArrayType typ = (TypeRepr.ArrayType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, desc2);
                    TypeRepr.AbstractType element = typ.getDeepElementType();
                    if (element instanceof TypeRepr.ClassType) {
                        int className = ((TypeRepr.ClassType)element).className;
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, className));
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassNewUsage(ClassfileAnalyzer.this.myContext, className));
                    }
                    typ.updateClassUsages(ClassfileAnalyzer.this.myContext, ClassCrawler.this.myName, ClassCrawler.this.myUsages);
                    super.visitMultiANewArrayInsn(desc2, dims);
                }

                public void visitLocalVariable(String n2, String desc2, String signature2, Label start, Label end, int index) {
                    ClassCrawler.this.processSignature(signature2);
                    TypeRepr.getType(ClassfileAnalyzer.this.myContext, desc2).updateClassUsages(ClassfileAnalyzer.this.myContext, ClassCrawler.this.myName, ClassCrawler.this.myUsages);
                    super.visitLocalVariable(n2, desc2, signature2, start, end, index);
                }

                public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                    if (type != null) {
                        TypeRepr.createClassType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(type)).updateClassUsages(ClassfileAnalyzer.this.myContext, ClassCrawler.this.myName, ClassCrawler.this.myUsages);
                    }
                    super.visitTryCatchBlock(start, end, handler, type);
                }

                public void visitTypeInsn(int opcode, String type) {
                    TypeRepr.AbstractType typ;
                    TypeRepr.AbstractType abstractType = typ = type.startsWith("[") ? TypeRepr.getType(ClassfileAnalyzer.this.myContext, type) : TypeRepr.createClassType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(type));
                    if (opcode == 187) {
                        int ifNameStart;
                        int ifNameEnd;
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ((TypeRepr.ClassType)typ).className));
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassNewUsage(ClassfileAnalyzer.this.myContext, ((TypeRepr.ClassType)typ).className));
                        int ktLambdaMarker = type.indexOf(ClassfileAnalyzer.KOTLIN_LAMBDA_USAGE_CLASS_MARKER);
                        if (ktLambdaMarker > 0 && (ifNameEnd = type.indexOf("$", ifNameStart = ktLambdaMarker + ClassfileAnalyzer.KOTLIN_LAMBDA_USAGE_CLASS_MARKER.length())) > ifNameStart) {
                            ClassCrawler.this.myUsages.add(UsageRepr.createClassNewUsage(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(type.substring(ifNameStart, ifNameEnd).replace('_', '/'))));
                        }
                    } else if (opcode == 189 && typ instanceof TypeRepr.ClassType) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ((TypeRepr.ClassType)typ).className));
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassNewUsage(ClassfileAnalyzer.this.myContext, ((TypeRepr.ClassType)typ).className));
                    }
                    typ.updateClassUsages(ClassfileAnalyzer.this.myContext, ClassCrawler.this.myName, ClassCrawler.this.myUsages);
                    super.visitTypeInsn(opcode, type);
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc2) {
                    this.registerFieldUsage(opcode, owner, name, desc2);
                    super.visitFieldInsn(opcode, owner, name, desc2);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc2, boolean itf) {
                    this.registerMethodUsage(owner, name, desc2);
                    super.visitMethodInsn(opcode, owner, name, desc2, itf);
                }

                public void visitInvokeDynamicInsn(String methodName, String desc2, Handle bsm, Object ... bsmArgs) {
                    Type samMethodType;
                    Type returnType = Type.getReturnType((String)desc2);
                    this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, returnType));
                    for (Object arg : bsmArgs) {
                        if (arg instanceof Type) {
                            Type type = (Type)arg;
                            if (type.getSort() == 11) {
                                for (Type argType : type.getArgumentTypes()) {
                                    this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, argType));
                                }
                                this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, type.getReturnType()));
                                continue;
                            }
                            this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, type));
                            continue;
                        }
                        if (!(arg instanceof Handle)) continue;
                        this.processMethodHandle((Handle)arg);
                    }
                    if (ClassfileAnalyzer.LAMBDA_FACTORY_CLASS.equals(bsm.getOwner()) && returnType.getSort() == 10 && bsmArgs.length >= 3 && bsmArgs[0] instanceof Type && (samMethodType = (Type)bsmArgs[0]).getSort() == 11) {
                        this.registerMethodUsage(returnType.getInternalName(), methodName, samMethodType.getDescriptor());
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassNewUsage(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(returnType.getInternalName())));
                    }
                    super.visitInvokeDynamicInsn(methodName, desc2, bsm, bsmArgs);
                }

                private void processMethodHandle(Handle handle) {
                    String memberOwner = handle.getOwner();
                    if (memberOwner != null && !memberOwner.equals(ClassCrawler.this.myClassNameHolder.get())) {
                        String memberName = handle.getName();
                        String memberDescriptor = handle.getDesc();
                        int opCode = ClassCrawler.this.getFieldAccessOpcode(handle);
                        if (opCode > 0) {
                            this.registerFieldUsage(opCode, memberOwner, memberName, memberDescriptor);
                        } else {
                            this.registerMethodUsage(memberOwner, memberName, memberDescriptor);
                        }
                    }
                }

                private void registerFieldUsage(int opcode, String owner, String fName, String desc2) {
                    int fieldName = ClassfileAnalyzer.this.myContext.get(fName);
                    int fieldOwner = ClassfileAnalyzer.this.myContext.get(owner);
                    int descr = ClassfileAnalyzer.this.myContext.get(desc2);
                    if (opcode == 181 || opcode == 179) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createFieldAssignUsage(ClassfileAnalyzer.this.myContext, fieldName, fieldOwner, descr));
                    }
                    if (opcode == 180 || opcode == 178) {
                        this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, descr));
                    }
                    ClassCrawler.this.myUsages.add(UsageRepr.createFieldUsage(ClassfileAnalyzer.this.myContext, fieldName, fieldOwner, descr));
                }

                private void registerMethodUsage(String owner, String name, @Nullable String desc2) {
                    int methodOwner = ClassfileAnalyzer.this.myContext.get(owner);
                    int methodName = ClassfileAnalyzer.this.myContext.get(name);
                    ClassCrawler.this.myUsages.add(UsageRepr.createMetaMethodUsage(ClassfileAnalyzer.this.myContext, methodName, methodOwner));
                    if (desc2 != null) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createMethodUsage(ClassfileAnalyzer.this.myContext, methodName, methodOwner, desc2));
                        this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, Type.getReturnType((String)desc2)));
                    }
                }

                private void addClassUsage(TypeRepr.AbstractType type) {
                    TypeRepr.AbstractType elemType;
                    TypeRepr.ClassType classType = null;
                    if (type instanceof TypeRepr.ClassType) {
                        classType = (TypeRepr.ClassType)type;
                    } else if (type instanceof TypeRepr.ArrayType && (elemType = ((TypeRepr.ArrayType)type).getDeepElementType()) instanceof TypeRepr.ClassType) {
                        classType = (TypeRepr.ClassType)elemType;
                    }
                    if (classType != null) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, classType.className));
                    }
                }
            };
        }

        private int getFieldAccessOpcode(Handle handle) {
            switch (handle.getTag()) {
                case 1: {
                    return 180;
                }
                case 2: {
                    return 178;
                }
                case 3: {
                    return 181;
                }
                case 4: {
                    return 179;
                }
            }
            return -1;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (name != null && name.equals(this.myClassNameHolder.get())) {
                this.myAccess |= access;
                if (outerName != null) {
                    this.myOuterClassName.set((Object)outerName);
                }
                if (innerName == null) {
                    this.myAnonymousClassFlag.set((Object)true);
                }
            }
        }

        public void visitOuterClass(String owner, String name, String desc) {
            this.myOuterClassName.set((Object)owner);
            if (name != null) {
                this.myLocalClassFlag.set((Object)true);
            }
        }

        private final class ModuleCrawler
        extends ModuleVisitor {
            ModuleCrawler() {
                super(589824);
            }

            public void visitMainClass(String mainClass) {
                ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(mainClass)));
            }

            public void visitRequire(String module, int access, String version) {
                if (this.isExplicit(access)) {
                    ClassCrawler.this.myModuleRequires.add(new ModuleRequiresRepr(ClassfileAnalyzer.this.myContext, access, ClassfileAnalyzer.this.myContext.get(module), version));
                }
            }

            public void visitExport(String packaze, int access, String ... modules) {
                if (this.isExplicit(access)) {
                    ClassCrawler.this.myModuleExports.add(new ModulePackageRepr(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(packaze), modules != null ? Arrays.asList(modules) : Collections.emptyList()));
                }
            }

            public void visitUse(String service) {
                ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(service)));
            }

            public void visitProvide(String service, String ... providers) {
                ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(service)));
                if (providers != null) {
                    for (String provider : providers) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(provider)));
                    }
                }
            }

            private boolean isExplicit(int access) {
                return (access & 0x9000) == 0;
            }
        }

        private final class AnnotationTargetCrawler
        extends AnnotationVisitor {
            private AnnotationTargetCrawler() {
                super(589824);
            }

            public void visit(String name, Object value) {
            }

            public void visitEnum(String name, String desc, String value) {
                ClassCrawler.this.myTargets.add(ElemType.valueOf(value));
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return this;
            }

            public AnnotationVisitor visitArray(String name) {
                return this;
            }

            public void visitEnd() {
            }
        }

        private final class AnnotationRetentionPolicyCrawler
        extends AnnotationVisitor {
            private AnnotationRetentionPolicyCrawler() {
                super(589824);
            }

            public void visit(String name, Object value) {
            }

            public void visitEnum(String name, String desc, String value) {
                ClassCrawler.this.myRetentionPolicy = RetentionPolicy.valueOf(value);
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return null;
            }

            public AnnotationVisitor visitArray(String name) {
                return null;
            }

            public void visitEnd() {
            }
        }

        private final class AnnotationCrawler
        extends AnnotationVisitor {
            private final TypeRepr.ClassType myType;
            private final ElemType myTarget;
            private final IntOpenHashSet myUsedArguments;
            @Nullable
            private String myArrayName;

            private AnnotationCrawler(TypeRepr.ClassType type, ElemType target) {
                super(589824);
                this.myUsedArguments = new IntOpenHashSet();
                this.myType = type;
                this.myTarget = target;
                Set<ElemType> targets = ClassCrawler.this.myAnnotationTargets.get(type);
                if (targets == null) {
                    ClassCrawler.this.myAnnotationTargets.put(type, EnumSet.of(target));
                } else {
                    targets.add(target);
                }
                ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, type.className));
            }

            private String getMethodDescr(Object value, boolean isArray) {
                StringBuilder descriptor = new StringBuilder();
                descriptor.append("()");
                if (isArray) {
                    descriptor.append("[");
                }
                if (value instanceof Type) {
                    descriptor.append("Ljava/lang/Class;");
                } else {
                    String name;
                    switch (name = Type.getType(value.getClass()).getInternalName()) {
                        case "java/lang/Integer": {
                            descriptor.append("I;");
                            break;
                        }
                        case "java/lang/Short": {
                            descriptor.append("S;");
                            break;
                        }
                        case "java/lang/Long": {
                            descriptor.append("J;");
                            break;
                        }
                        case "java/lang/Byte": {
                            descriptor.append("B;");
                            break;
                        }
                        case "java/lang/Char": {
                            descriptor.append("C;");
                            break;
                        }
                        case "java/lang/Boolean": {
                            descriptor.append("Z;");
                            break;
                        }
                        case "java/lang/Float": {
                            descriptor.append("F;");
                            break;
                        }
                        case "java/lang/Double": {
                            descriptor.append("D;");
                            break;
                        }
                        default: {
                            descriptor.append("L").append(name).append(";");
                        }
                    }
                }
                return descriptor.toString();
            }

            public void visit(String name, Object value) {
                String argName;
                boolean isArray;
                boolean bl = isArray = name == null && this.myArrayName != null;
                if (name != null) {
                    argName = name;
                } else {
                    argName = this.myArrayName;
                    this.myArrayName = null;
                }
                if (argName != null) {
                    this.registerUsages(argName, this.getMethodDescr(value, isArray), value);
                }
            }

            public void visitEnum(String name, String desc, String value) {
                String argName;
                boolean isArray;
                boolean bl = isArray = name == null && this.myArrayName != null;
                if (name != null) {
                    argName = name;
                } else {
                    argName = this.myArrayName;
                    this.myArrayName = null;
                }
                if (argName != null) {
                    this.registerUsages(argName, (isArray ? "()[" : "()") + desc, value);
                }
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return new AnnotationCrawler((TypeRepr.ClassType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, desc), this.myTarget);
            }

            public AnnotationVisitor visitArray(String name) {
                this.myArrayName = name;
                return this;
            }

            private void registerUsages(String argName, String methodDescr, Object value) {
                int methodName = ClassfileAnalyzer.this.myContext.get(argName);
                if (value instanceof Type) {
                    String className = ((Type)value).getClassName().replace('.', '/');
                    ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(className)));
                }
                ClassCrawler.this.myUsages.add(UsageRepr.createMethodUsage(ClassfileAnalyzer.this.myContext, methodName, this.myType.className, methodDescr));
                ClassCrawler.this.myUsages.add(UsageRepr.createMetaMethodUsage(ClassfileAnalyzer.this.myContext, methodName, this.myType.className));
                this.myUsedArguments.add(methodName);
            }

            public void visitEnd() {
                IntSet s = ClassCrawler.this.myAnnotationArguments.get(this.myType);
                if (s == null) {
                    ClassCrawler.this.myAnnotationArguments.put(this.myType, (IntSet)this.myUsedArguments);
                } else {
                    s.retainAll((IntCollection)this.myUsedArguments);
                }
            }
        }

        private class BaseSignatureVisitor
        extends SignatureVisitor {
            BaseSignatureVisitor() {
                super(589824);
            }

            public void visitFormalTypeParameter(String name) {
            }

            public SignatureVisitor visitClassBound() {
                return super.visitClassBound();
            }

            public SignatureVisitor visitInterfaceBound() {
                return super.visitInterfaceBound();
            }

            public SignatureVisitor visitSuperclass() {
                return super.visitSuperclass();
            }

            public SignatureVisitor visitInterface() {
                return super.visitInterface();
            }

            public SignatureVisitor visitParameterType() {
                return super.visitParameterType();
            }

            public SignatureVisitor visitReturnType() {
                return super.visitReturnType();
            }

            public SignatureVisitor visitExceptionType() {
                return super.visitExceptionType();
            }

            public void visitBaseType(char descriptor) {
            }

            public void visitTypeVariable(String name) {
            }

            public SignatureVisitor visitArrayType() {
                return super.visitArrayType();
            }

            public void visitInnerClassType(String name) {
            }

            public void visitTypeArgument() {
                super.visitTypeArgument();
            }

            public SignatureVisitor visitTypeArgument(char wildcard) {
                return this;
            }

            public void visitEnd() {
                super.visitEnd();
            }

            public void visitClassType(String name) {
                int className = ClassfileAnalyzer.this.myContext.get(name);
                ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, className));
            }
        }
    }
}

