/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer.stubs;

import com.intellij.dev.psiViewer.PsiViewerDialog;
import com.intellij.dev.psiViewer.ViewerPsiBasedTree;
import com.intellij.dev.psiViewer.stubs.StubDetailsViewer;
import com.intellij.dev.psiViewer.stubs.StubTreeNode;
import com.intellij.dev.psiViewer.stubs.StubTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubViewerPsiBasedTree
implements ViewerPsiBasedTree {
    public static final Logger LOG = Logger.getInstance(PsiViewerDialog.class);
    @Nullable
    private AbstractTreeModel myTreeModel;
    @NotNull
    private final Tree myStubTree;
    @NotNull
    private final StubDetailsViewer myStubDetailsViewer;
    @Nullable
    private JPanel myPanel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ViewerPsiBasedTree.PsiTreeUpdater myUpdater;
    @NotNull
    private volatile Map<ASTNode, StubElement<?>> myNodeToStubs;
    Disposable myTreeModelDisposable;

    public StubViewerPsiBasedTree(@NotNull Project project, @NotNull ViewerPsiBasedTree.PsiTreeUpdater updater) {
        if (project == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(0);
        }
        if (updater == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(1);
        }
        this.myNodeToStubs = new BidirectionalMap();
        this.myTreeModelDisposable = Disposer.newDisposable();
        this.myProject = project;
        this.myUpdater = updater;
        this.myStubTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myStubDetailsViewer = new StubDetailsViewer(this);
    }

    @Override
    public void reloadTree(@Nullable PsiElement rootRootElement, @NotNull String text) {
        if (text == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(2);
        }
        this.resetStubTree();
        this.buildStubTree(rootRootElement, text);
    }

    private void resetStubTree() {
        this.myStubTree.removeAll();
        if (this.myTreeModel != null) {
            Disposer.dispose((Disposable)this.myTreeModelDisposable);
            this.myTreeModel = null;
            this.myTreeModelDisposable = Disposer.newDisposable();
        }
        this.myNodeToStubs = new BidirectionalMap();
        ViewerPsiBasedTree.removeListenerOfClass(this.myStubTree, StubTreeSelectionListener.class);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        if (this.myPanel != null) {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                StubViewerPsiBasedTree.$$$reportNull$$$0(3);
            }
            return jPanel;
        }
        JBSplitter splitter = new JBSplitter("StubViewer.showPreviewDetails.proportion", 0.7f);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myStubTree, (boolean)true));
        AnAction action = this.myStubDetailsViewer.addComponent(splitter);
        ActionToolbarImpl toolbar = new ActionToolbarImpl("Stub Viewer", (ActionGroup)new DefaultActionGroup(new AnAction[]{action}), false);
        toolbar.setTargetComponent((JComponent)splitter);
        BorderLayoutPanel panel = new BorderLayoutPanel();
        panel.addToCenter((Component)splitter).addToRight((Component)toolbar).setBorder(IdeBorderFactory.createBorder());
        PsiViewerDialog.initTree((JTree)this.myStubTree);
        this.myPanel = panel;
        BorderLayoutPanel borderLayoutPanel = panel;
        if (borderLayoutPanel == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(4);
        }
        return borderLayoutPanel;
    }

    @Override
    public boolean isFocusOwner() {
        return this.myStubTree.isFocusOwner();
    }

    @Override
    public void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myStubTree, true);
    }

    private synchronized void buildStubTree(@Nullable PsiElement rootElement, @NotNull String textToParse) {
        if (textToParse == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(5);
        }
        if (rootElement == null) {
            this.myStubTree.setRootVisible(false);
            return;
        }
        if (!(rootElement instanceof PsiFileWithStubSupport)) {
            this.myStubTree.setRootVisible(false);
            StatusText text = this.myStubTree.getEmptyText();
            if (rootElement instanceof PsiFile) {
                text.setText("No stubs for " + rootElement.getLanguage().getDisplayName());
            } else {
                text.setText("Cannot build stub tree for code fragments");
            }
            return;
        }
        Stub stub = StubViewerPsiBasedTree.buildStubForElement(this.myProject, rootElement, textToParse);
        if (stub instanceof PsiFileStub) {
            PsiFileWithStubSupport file = (PsiFileWithStubSupport)rootElement;
            StubTreeNode rootNode = new StubTreeNode((StubElement)stub, null);
            StructureTreeModel treeModel = new StructureTreeModel((AbstractTreeStructure)new StubTreeStructure(rootNode), this.myTreeModelDisposable);
            this.myTreeModel = new AsyncTreeModel((TreeModel)treeModel, this.myTreeModelDisposable);
            this.myStubTree.setModel((TreeModel)this.myTreeModel);
            this.fillPsiToStubCache(file, (PsiFileStub)stub);
            this.myStubTree.setRootVisible(true);
            this.myStubTree.expandRow(0);
            this.myStubTree.addTreeSelectionListener((TreeSelectionListener)new StubTreeSelectionListener());
            treeModel.invalidateAsync();
        } else {
            this.myStubTree.setRootVisible(false);
            StatusText text = this.myStubTree.getEmptyText();
            text.setText("Cannot build stubs for " + rootElement.getLanguage().getDisplayName());
        }
    }

    public void dispose() {
        this.resetStubTree();
    }

    @Nullable
    private static Stub buildStubForElement(Project project, PsiElement rootElement, @NotNull String textToParse) {
        if (textToParse == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(6);
        }
        PsiFileStub stub = null;
        PsiFileWithStubSupport psiFile = (PsiFileWithStubSupport)rootElement;
        StubTree tree = psiFile.getStubTree();
        if (tree != null) {
            stub = tree.getRoot();
        } else if (rootElement instanceof PsiFileImpl) {
            StubBuilder stubBuilder = StubViewerPsiBasedTree.getStubBuilder((PsiFileImpl)rootElement);
            StubElement stubElement = stub = stubBuilder == null ? null : stubBuilder.buildStubTree((PsiFile)rootElement);
        }
        if (stub == null) {
            LightVirtualFile file = new LightVirtualFile("stub", rootElement.getLanguage(), (CharSequence)textToParse);
            try {
                FileContent fc = FileContentImpl.createByFile((VirtualFile)file, (Project)project);
                fc.putUserData(IndexingDataKeys.PSI_FILE, (Object)psiFile);
                stub = StubTreeBuilder.buildStubTree((FileContent)fc);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return stub;
    }

    @Nullable
    private static StubBuilder getStubBuilder(@NotNull PsiFileImpl rootElement) {
        IStubFileElementType builder;
        if (rootElement == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(7);
        }
        return (builder = rootElement.getElementTypeForStubBuilder()) == null ? null : builder.getBuilder();
    }

    @Override
    public void selectNodeFromPsi(@Nullable PsiElement element) {
        if (this.myTreeModel == null || element == null) {
            return;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof PsiFileWithStubSupport)) {
            return;
        }
        DefaultMutableTreeNode rootNode = this.getRoot();
        if (rootNode == null) {
            return;
        }
        StubElement<?> stubElement = this.myNodeToStubs.get(element.getNode());
        if (stubElement != null) {
            this.selectStubElement(stubElement);
        } else {
            this.myStubTree.clearSelection();
        }
    }

    private void selectStubElement(StubElement<?> stubElement) {
        TreeNode node = (TreeNode)TreeUtil.treeNodeTraverser((TreeNode)this.getRoot()).traverse().find(treeNode -> treeNode instanceof DefaultMutableTreeNode && ((StubTreeNode)((Object)((Object)((DefaultMutableTreeNode)treeNode).getUserObject()))).getStub() == stubElement);
        if (node != null) {
            TreePath path = TreePathUtil.pathToTreeNode((TreeNode)node);
            this.myStubTree.getSelectionModel().setSelectionPath(path);
        }
    }

    @Nullable
    StubElement<?> getSelectedStub() {
        TreePath selectionPath = this.myStubTree.getSelectionPath();
        return selectionPath != null ? ((StubTreeNode)((Object)((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject())).getStub() : null;
    }

    private DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.myStubTree.getModel().getRoot();
    }

    public PsiElement getPsiElementForStub(StubElement<?> stub) {
        Ref result = Ref.create();
        this.myNodeToStubs.forEach((key, value) -> {
            if (value == stub) {
                result.set((Object)key.getPsi());
            }
        });
        return (PsiElement)result.get();
    }

    private void fillPsiToStubCache(@NotNull PsiFileWithStubSupport rootElement, @NotNull PsiFileStub<?> rootStub) {
        if (rootElement == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(8);
        }
        if (rootStub == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(9);
        }
        this.fillTreeForStub(rootElement, new StubTree(rootStub));
    }

    public void fillTreeForStub(@NotNull PsiFileWithStubSupport file, @NotNull StubTree tree) {
        StubBuilder builder;
        if (file == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(10);
        }
        if (tree == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(11);
        }
        StubBuilder stubBuilder = builder = file instanceof PsiFileImpl ? StubViewerPsiBasedTree.getStubBuilder((PsiFileImpl)file) : null;
        if (builder == null) {
            return;
        }
        Iterator<StubElement<?>> stubs = tree.getPlainList().iterator();
        StubElement root = (StubElement)stubs.next();
        FileASTNode ast = file.getNode();
        this.myNodeToStubs.put((ASTNode)ast, root);
        this.findTreeForStub(builder, (ASTNode)ast, stubs);
        if (stubs.hasNext()) {
            LOG.error("Stub mismatch, unprocessed stubs " + stubs.next());
        }
    }

    private void findTreeForStub(StubBuilder builder, ASTNode tree, Iterator<StubElement<?>> stubs) {
        IElementType type = tree.getElementType();
        if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(tree)) {
            if (!stubs.hasNext()) {
                LOG.error("Stub mismatch, " + type);
            }
            StubElement<?> curStub = stubs.next();
            this.myNodeToStubs.put(tree, curStub);
        }
        for (ASTNode node : tree.getChildren(null)) {
            if (builder.skipChildProcessingWhenBuildingStubs(tree, node)) continue;
            this.findTreeForStub(builder, node, stubs);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dev/psiViewer/stubs/StubViewerPsiBasedTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToParse";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dev/psiViewer/stubs/StubViewerPsiBasedTree";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reloadTree";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildStubForElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStubBuilder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillPsiToStubCache";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillTreeForStub";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private class StubTreeSelectionListener
    implements TreeSelectionListener {
        StubTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            StubElement<?> topLevelStub;
            if (StubViewerPsiBasedTree.this.myTreeModel == null) {
                return;
            }
            StubTreeNode rootNode = (StubTreeNode)((Object)StubViewerPsiBasedTree.this.getRoot().getUserObject());
            StubElement<?> stubElement = topLevelStub = rootNode == null ? null : rootNode.getStub();
            if (!(topLevelStub instanceof PsiFileStub)) {
                return;
            }
            StubElement<?> stub = StubViewerPsiBasedTree.this.getSelectedStub();
            if (stub == null) {
                return;
            }
            PsiElement result = StubViewerPsiBasedTree.this.getPsiElementForStub(stub);
            if (result != null) {
                StubViewerPsiBasedTree.this.myUpdater.updatePsiTree(result, StubViewerPsiBasedTree.this.myStubTree.hasFocus() ? result.getTextRange() : null);
                StubViewerPsiBasedTree.this.myStubDetailsViewer.valueChanged(stub);
            }
        }
    }
}

