/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.usages.popup;

import com.intellij.find.actions.ShowUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesManager;
import com.intellij.find.actions.ShowUsagesParameters;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewPopup;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.popups.RdEditorOffsetPopupWindowContext;
import com.jetbrains.ide.model.popups.RdPopupWindowContextBase;
import com.jetbrains.ide.model.popups.RdScreenPositionPopupWindowContext;
import com.jetbrains.rd.ide.model.RdShowUsagesSession;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.usages.popup.FrontendShowUsagesActionHandler;
import com.jetbrains.rdclient.usages.popup.FrontendShowUsagesCustomizer;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/usages/popup/FrontendShowUsagesManager;", "", "()V", "getPopupLocation", "Lcom/intellij/ui/awt/RelativePoint;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "context", "Lcom/jetbrains/ide/model/popups/RdPopupWindowContextBase;", "show", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/jetbrains/rd/ide/model/RdShowUsagesSession;", "onClose", "Lkotlin/Function0;", "AnyScope", "intellij.rd.client"})
public final class FrontendShowUsagesManager {
    @NotNull
    public static final FrontendShowUsagesManager INSTANCE = new FrontendShowUsagesManager();

    private FrontendShowUsagesManager() {
    }

    public final void show(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull RdShowUsagesSession session, @NotNull Function0<Unit> onClose) {
        GlobalSearchScope globalSearchScope;
        GlobalSearchScope scope;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
        TextControlId textControlId = session.getTextControlId();
        UsageViewPopup usageViewPopup = new UsageViewPopup(project);
        TextControlId textControlId2 = textControlId;
        Editor editor2 = textControlId2 != null ? FrontendTextControlHostKt.toEditor(textControlId2) : null;
        ShowUsagesParameters showUsagesParameters = ShowUsagesParameters.initial((Project)project, (Editor)editor2, (RelativePoint)this.getPopupLocation(project, editor2, session.getPopupWindowContext())).withUsages(session.getMaxUsages());
        Intrinsics.checkNotNullExpressionValue((Object)showUsagesParameters, (String)"withUsages(...)");
        ShowUsagesParameters parameters = showUsagesParameters;
        GlobalSearchScope globalSearchScope2 = FrontendShowUsagesCustomizer.Companion.getInstance().getDefaultScope(project);
        if (globalSearchScope2 == null) {
            globalSearchScope2 = scope = (GlobalSearchScope)new AnyScope(session.getScopeName());
        }
        if ((globalSearchScope = FrontendShowUsagesCustomizer.Companion.getInstance().getMaximalScope(project)) == null) {
            globalSearchScope = new AnyScope(session.getScopeName());
        }
        GlobalSearchScope maximalScope = globalSearchScope;
        FrontendShowUsagesActionHandler handler2 = new FrontendShowUsagesActionHandler(lifetime, project, session, (SearchScope)scope, (SearchScope)maximalScope);
        Disposer.register((Disposable)((Disposable)usageViewPopup), () -> FrontendShowUsagesManager.show$lambda$1(handler2, onClose));
        ShowUsagesManager.Companion.getInstance(project).showElementUsagesWithResult(parameters, (ShowUsagesActionHandler)handler2, (UsageViewImpl)usageViewPopup);
    }

    private final RelativePoint getPopupLocation(Project project, Editor editor2, RdPopupWindowContextBase context) {
        if (editor2 != null) {
            if (context instanceof RdEditorOffsetPopupWindowContext) {
                return new RelativePoint((Component)editor2.getContentComponent(), editor2.offsetToXY(((RdEditorOffsetPopupWindowContext)context).getEditorOffset()));
            }
            if (context instanceof RdScreenPositionPopupWindowContext) {
                return new RelativePoint((Component)editor2.getContentComponent(), new Point(((RdScreenPositionPopupWindowContext)context).getX(), ((RdScreenPositionPopupWindowContext)context).getY()));
            }
            RelativePoint relativePoint = PopupFactoryImpl.getInstance().guessBestPopupLocation(editor2);
            Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
            return relativePoint;
        }
        IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(project);
        Intrinsics.checkNotNull((Object)ideFrame);
        JComponent ideFrame2 = ideFrame.getComponent();
        JRootPane jRootPane = UIUtil.getRootPane((Component)ideFrame2);
        Intrinsics.checkNotNull((Object)jRootPane);
        JRootPane rootPane = jRootPane;
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation((JComponent)rootPane);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
        return relativePoint;
    }

    private static final void show$lambda$1$lambda$0(FrontendShowUsagesActionHandler $handler, Function0 $onClose) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        Intrinsics.checkNotNullParameter((Object)$onClose, (String)"$onClose");
        Object[] objectArray = new String[]{"Preview", "ChangeScope", "ResetFilters"};
        if (ArraysKt.contains((Object[])objectArray, (Object)$handler.getCloseReason())) {
            return;
        }
        $onClose.invoke();
    }

    private static final void show$lambda$1(FrontendShowUsagesActionHandler $handler, Function0 $onClose) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        Intrinsics.checkNotNullParameter((Object)$onClose, (String)"$onClose");
        ApplicationKt.getApplication().invokeLater(() -> FrontendShowUsagesManager.show$lambda$1$lambda$0($handler, $onClose));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0014\u0012\r\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096\u0002J\r\u0010\n\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0015\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/usages/popup/FrontendShowUsagesManager$AnyScope;", "Lcom/intellij/psi/search/GlobalSearchScope;", "name", "", "Lorg/jetbrains/annotations/Nls;", "(Ljava/lang/String;)V", "contains", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDisplayName", "isSearchInLibraries", "isSearchInModuleContent", "aModule", "Lcom/intellij/openapi/module/Module;", "intellij.rd.client"})
    private static final class AnyScope
    extends GlobalSearchScope {
        @Nullable
        private final String name;

        public AnyScope(@Nullable String name) {
            this.name = name;
        }

        public boolean contains(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return true;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
            return false;
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.name;
            if (string == null) {
                String string2 = super.getDisplayName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
            }
            return string;
        }
    }
}

