/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.showImplementations;

import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.ImplementationViewSessionFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.rd.ide.model.ImplementationViewElementModel;
import com.jetbrains.rd.ide.model.ImplementationViewSessionModel;
import com.jetbrains.rd.ide.model.ShowImplementationsModel_GeneratedKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.IMutableViewableList;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.reactive.ViewableList;
import com.jetbrains.rd.util.threading.SpinWait;
import com.jetbrains.rd.util.time.DurationKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.showImplementations.FrontendImplementationViewElement;
import com.jetbrains.rdclient.showImplementations.FrontendImplementationViewSessionFactory;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J&\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b2\u0006\u0010*\u001a\u00020+2\u000e\u0010,\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130-H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\u0004\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006."}, d2={"Lcom/jetbrains/rdclient/showImplementations/FrontendImplementationViewSession;", "Lcom/intellij/codeInsight/hint/ImplementationViewSession;", "project", "Lcom/intellij/openapi/project/Project;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "sessionModel", "Lcom/jetbrains/rd/ide/model/ImplementationViewSessionModel;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rdclient/services/IdeBackend;Lcom/jetbrains/rd/ide/model/ImplementationViewSessionModel;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "elements", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lcom/intellij/codeInsight/hint/ImplementationViewElement;", "factory", "Lcom/intellij/codeInsight/hint/ImplementationViewSessionFactory;", "getFactory", "()Lcom/intellij/codeInsight/hint/ImplementationViewSessionFactory;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "implementationElements", "", "getImplementationElements", "()Ljava/util/List;", "getProject", "()Lcom/intellij/openapi/project/Project;", "text", "", "getText", "()Ljava/lang/String;", "dispose", "", "elementRequiresIncludeSelf", "", "needUpdateInBackground", "searchImplementationsInBackground", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "processor", "Lcom/intellij/util/Processor;", "intellij.rd.client"})
public final class FrontendImplementationViewSession
implements ImplementationViewSession {
    @NotNull
    private final Project project;
    @NotNull
    private final IdeBackend backend;
    @NotNull
    private final ImplementationViewSessionModel sessionModel;
    @Nullable
    private final VirtualFile file;
    @Nullable
    private final Editor editor;
    @NotNull
    private final LifetimeDefinition sessionLifetime;
    @NotNull
    private final ViewableList<ImplementationViewElement> elements;

    public FrontendImplementationViewSession(@NotNull Project project, @NotNull IdeBackend backend, @NotNull ImplementationViewSessionModel sessionModel, @Nullable VirtualFile file, @Nullable Editor editor2, @NotNull LifetimeDefinition sessionLifetime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        this.project = project;
        this.backend = backend;
        this.sessionModel = sessionModel;
        this.file = file;
        this.editor = editor2;
        this.sessionLifetime = sessionLifetime;
        this.elements = new ViewableList(null, 1, null);
        SourceExKt.flowInto((ISource)((ISource)this.sessionModel.getItems()), (Lifetime)((Lifetime)this.sessionLifetime), (IMutableViewableList)((IMutableViewableList)this.elements), (Function1)((Function1)new Function1<ImplementationViewElementModel, ImplementationViewElement>(){

            @NotNull
            public final ImplementationViewElement invoke(@NotNull ImplementationViewElementModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new FrontendImplementationViewElement(this.getProject(), sessionModel, it);
            }
        }));
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public ImplementationViewSessionFactory getFactory() {
        return (ImplementationViewSessionFactory)ImplementationViewSessionFactory.EP_NAME.findExtensionOrFail(FrontendImplementationViewSessionFactory.class);
    }

    @NotNull
    public List<ImplementationViewElement> getImplementationElements() {
        return (List)this.elements;
    }

    @Nullable
    public String getText() {
        return (String)this.sessionModel.getText().getValue();
    }

    @NotNull
    public List<ImplementationViewElement> searchImplementationsInBackground(@NotNull ProgressIndicator indicator, @NotNull Processor<? super ImplementationViewElement> processor2) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        this.sessionLifetime.createNested((Function1)new Function1<LifetimeDefinition, Unit>(this, processor2, indicator){
            final /* synthetic */ FrontendImplementationViewSession this$0;
            final /* synthetic */ Processor<? super ImplementationViewElement> $processor;
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.this$0 = $receiver;
                this.$processor = $processor;
                this.$indicator = $indicator;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull LifetimeDefinition it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FrontendImplementationViewSession.access$getElements$p(this.this$0).adviseAddRemove((Lifetime)it, (Function3)new Function3<AddRemove, Integer, ImplementationViewElement, Unit>(this.$processor, it){
                    final /* synthetic */ Processor<? super ImplementationViewElement> $processor;
                    final /* synthetic */ LifetimeDefinition $it;
                    {
                        this.$processor = $processor;
                        this.$it = $it;
                        super(3);
                    }

                    public final void invoke(@NotNull AddRemove addRemove, int n, @NotNull ImplementationViewElement elt) {
                        Intrinsics.checkNotNullParameter((Object)addRemove, (String)"addRemove");
                        Intrinsics.checkNotNullParameter((Object)elt, (String)"elt");
                        if (addRemove != AddRemove.Add) {
                            return;
                        }
                        if (!this.$processor.process((Object)elt)) {
                            LifetimeDefinition.terminate$default((LifetimeDefinition)this.$it, (boolean)false, (int)1, null);
                        }
                    }
                });
                SpinWait.Companion companion = SpinWait.Companion;
                Lifetime lifetime = (Lifetime)FrontendImplementationViewSession.access$getSessionLifetime$p(this.this$0);
                Duration duration = DurationKt.getInfiniteDuration();
                FrontendImplementationViewSession frontendImplementationViewSession = this.this$0;
                ProgressIndicator progressIndicator = this.$indicator;
                boolean $i$f$spinUntil = false;
                long start$iv = System.nanoTime();
                long spins$iv = 0L;
                while (true) {
                    void duration$iv;
                    void lifetime$iv;
                    boolean bl = false;
                    if (InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)FrontendImplementationViewSession.access$getSessionModel$p(frontendImplementationViewSession).getSearchDone())) || progressIndicator.isCanceled() || !RLifetimeKt.isAlive((Lifetime)lifetime$iv) || System.nanoTime() - start$iv > duration$iv.toNanos()) break;
                    long l = spins$iv;
                    spins$iv = l + 1L;
                    if (l < 100L) {
                        Thread.yield();
                        continue;
                    }
                    Thread.sleep(spins$iv / (long)100);
                }
            }
        });
        return (List)this.elements;
    }

    public boolean elementRequiresIncludeSelf() {
        return false;
    }

    public boolean needUpdateInBackground() {
        return true;
    }

    public void dispose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.sessionLifetime, (boolean)false, (int)1, null);
        ShowImplementationsModel_GeneratedKt.getShowImplementationsModel((Solution)this.backend.getSolution()).getSession().set(null);
    }

    public static final /* synthetic */ ViewableList access$getElements$p(FrontendImplementationViewSession $this) {
        return $this.elements;
    }

    public static final /* synthetic */ LifetimeDefinition access$getSessionLifetime$p(FrontendImplementationViewSession $this) {
        return $this.sessionLifetime;
    }
}

