/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.services;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.ide.model.popups.RdEditorOffsetPopupWindowContext;
import com.jetbrains.ide.model.popups.RdPopupWindowContextBase;
import com.jetbrains.ide.model.tooltips.TooltipDescriptor;
import com.jetbrains.ide.model.tooltips.TooltipType;
import com.jetbrains.ide.model.tooltips.TooltipsModel;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.services.TooltipsHost;
import com.jetbrains.rdclient.services.uiContext.UiContextManager;
import java.awt.Component;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdclient/services/TooltipsHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getHint", "Lcom/intellij/ui/LightweightHint;", "tooltip", "Lcom/jetbrains/ide/model/tooltips/TooltipDescriptor;", "showTooltip", "", "Companion", "Listener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nTooltipsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipsHost.kt\ncom/jetbrains/rdclient/services/TooltipsHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,81:1\n10#2:82\n*S KotlinDebug\n*F\n+ 1 TooltipsHost.kt\ncom/jetbrains/rdclient/services/TooltipsHost\n*L\n26#1:82\n*E\n"})
final class TooltipsHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public TooltipsHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final void showTooltip(TooltipDescriptor tooltip) {
        FileEditorManagerEx.Companion.getInstanceEx(this.project).getActiveWindow().thenAccept(arg_0 -> TooltipsHost.showTooltip$lambda$0((Function1)new Function1<EditorWindow, Unit>(this, tooltip){
            final /* synthetic */ TooltipsHost this$0;
            final /* synthetic */ TooltipDescriptor $tooltip;
            {
                this.this$0 = $receiver;
                this.$tooltip = $tooltip;
                super(1);
            }

            public final void invoke(@Nullable EditorWindow editorWindow) {
                if (editorWindow == null) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> showTooltip.1.invoke$lambda$0(editorWindow, this.this$0, this.$tooltip));
            }

            private static final void invoke$lambda$0(EditorWindow $editorWindow, TooltipsHost this$0, TooltipDescriptor $tooltip) {
                LightweightHint hint;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$tooltip, (String)"$tooltip");
                EditorComposite editorComposite = $editorWindow.getSelectedComposite();
                FileEditor fileEditor = editorComposite != null && (editorComposite = editorComposite.getSelectedWithProvider()) != null ? editorComposite.getFileEditor() : null;
                TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                if (textEditor == null) {
                    return;
                }
                TextEditor textEditor2 = textEditor;
                Editor editor2 = textEditor2.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                Editor editor3 = editor2;
                if (UiContextManager.Companion.getInstance(TooltipsHost.access$getProject$p(this$0)).isActualValues($tooltip.getTimestamps()) && (hint = TooltipsHost.access$getHint(this$0, $tooltip)) != null) {
                    HintManagerImpl manager = HintManagerImpl.getInstanceImpl();
                    RdPopupWindowContextBase context = $tooltip.getContext();
                    Point point = context instanceof RdEditorOffsetPopupWindowContext ? new RelativePoint((Component)editor3.getContentComponent(), editor3.offsetToXY(((RdEditorOffsetPopupWindowContext)context).getEditorOffset())).getPoint() : manager.getHintPosition(hint, editor3, (short)1);
                    HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor3, point, 42, 0, false);
                }
            }
        }, arg_0));
    }

    private final LightweightHint getHint(TooltipDescriptor tooltip) {
        String escapedText = XmlStringUtil.escapeString((String)tooltip.getUnescapedText());
        return switch (WhenMappings.$EnumSwitchMapping$0[tooltip.getType().ordinal()]) {
            case 1 -> new LightweightHint(HintUtil.createErrorLabel((String)escapedText, null, null));
            case 2 -> new LightweightHint(HintUtil.createInformationLabel((String)escapedText, null, null, null));
            default -> {
                logger.error("Unexpected tooltip type.");
                yield null;
            }
        };
    }

    private static final void showTooltip$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$showTooltip(TooltipsHost $this, TooltipDescriptor tooltip) {
        $this.showTooltip(tooltip);
    }

    public static final /* synthetic */ Project access$getProject$p(TooltipsHost $this) {
        return $this.project;
    }

    public static final /* synthetic */ LightweightHint access$getHint(TooltipsHost $this, TooltipDescriptor tooltip) {
        return $this.getHint(tooltip);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TooltipsHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TooltipsHost.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/services/TooltipsHost$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdclient/services/TooltipsHost$Listener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/ide/model/tooltips/TooltipsModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rd.client"})
    public static final class Listener
    implements SolutionExtListener<TooltipsModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull TooltipsModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            model.getMessage().advise(lifetime, (Function1)new Function1<TooltipDescriptor, Unit>(session){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(@NotNull TooltipDescriptor tooltip) {
                    Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
                    ComponentManager $this$service$iv = (ComponentManager)this.$session.getProject();
                    boolean $i$f$service = false;
                    Class<TooltipsHost> serviceClass$iv = TooltipsHost.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                    }
                    TooltipsHost.access$showTooltip((TooltipsHost)object, tooltip);
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TooltipType.values().length];
            try {
                nArray[TooltipType.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TooltipType.INFO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

