/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.renderedDocs;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.lang.documentation.ide.IdeDocumentationTargetProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.InlineDocumentation;
import com.intellij.psi.util.PsiEditorUtil;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItemKt;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010'\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u0010(\u001a\u0004\u0018\u00010)H\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020-H\u0016J\b\u00104\u001a\u00020-H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u00065"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItem;", "Lcom/intellij/codeInsight/documentation/render/DocRenderItem;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "value", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "foldRegion", "getFoldRegion", "()Lcom/intellij/openapi/editor/CustomFoldRegion;", "setFoldRegion", "(Lcom/intellij/openapi/editor/CustomFoldRegion;)V", "getHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "setHighlighter", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "regionBackendId", "", "getRegionBackendId", "()Ljava/lang/Long;", "setRegionBackendId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "renderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "getRenderer", "()Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "setRenderer", "(Lcom/intellij/openapi/editor/markup/GutterIconRenderer;)V", "textToRender", "", "getTextToRender", "()Ljava/lang/String;", "setTextToRender", "(Ljava/lang/String;)V", "calcFoldingGutterIconRenderer", "getInlineDocumentation", "Lcom/intellij/platform/backend/documentation/InlineDocumentation;", "getInlineDocumentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "repaintGutter", "", "startY", "", "setIconVisible", "visible", "", "toggle", "updateIcon", "intellij.rd.client"})
public final class FrontendDocRenderItem
implements DocRenderItem {
    @NotNull
    private RangeHighlighter highlighter;
    @NotNull
    private final Editor editor;
    @Nullable
    private String textToRender;
    @Nullable
    private Long regionBackendId;
    @Nullable
    private CustomFoldRegion foldRegion;
    @Nullable
    private GutterIconRenderer renderer;

    public FrontendDocRenderItem(@NotNull RangeHighlighter highlighter2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.highlighter = highlighter2;
        this.editor = editor2;
    }

    @NotNull
    public RangeHighlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(@NotNull RangeHighlighter rangeHighlighter) {
        Intrinsics.checkNotNullParameter((Object)rangeHighlighter, (String)"<set-?>");
        this.highlighter = rangeHighlighter;
    }

    @NotNull
    public Editor getEditor() {
        return this.editor;
    }

    @Nullable
    public String getTextToRender() {
        return this.textToRender;
    }

    public void setTextToRender(@Nullable String string) {
        this.textToRender = string;
    }

    @Nullable
    public final Long getRegionBackendId() {
        return this.regionBackendId;
    }

    public final void setRegionBackendId(@Nullable Long l) {
        this.regionBackendId = l;
    }

    @Nullable
    public CustomFoldRegion getFoldRegion() {
        return this.foldRegion;
    }

    public void setFoldRegion(@Nullable CustomFoldRegion value) {
        if (value == null) {
            this.updateIcon();
            this.foldRegion = null;
        } else {
            this.foldRegion = value;
            this.updateIcon();
        }
    }

    @Nullable
    public final GutterIconRenderer getRenderer() {
        return this.renderer;
    }

    public final void setRenderer(@Nullable GutterIconRenderer gutterIconRenderer) {
        this.renderer = gutterIconRenderer;
    }

    @Nullable
    public GutterIconRenderer calcFoldingGutterIconRenderer() {
        return this.renderer;
    }

    public void setIconVisible(boolean visible) {
        CustomFoldRegion customFoldRegion = this.getFoldRegion();
        boolean bl = customFoldRegion != null ? customFoldRegion.isValid() : false;
        if (bl) {
            CustomFoldRegion customFoldRegion2 = this.getFoldRegion();
            Intrinsics.checkNotNull((Object)customFoldRegion2);
            GutterIconRenderer gutterIconRenderer = customFoldRegion2.getGutterIconRenderer();
            if (gutterIconRenderer == null) {
                return;
            }
            GutterIconRenderer iconRenderer = gutterIconRenderer;
            FrontendDocRenderItemKt.setVisible(iconRenderer, visible);
            Editor editor2 = this.getEditor();
            CustomFoldRegion customFoldRegion3 = this.getFoldRegion();
            Intrinsics.checkNotNull((Object)customFoldRegion3);
            this.repaintGutter(editor2.offsetToXY((int)customFoldRegion3.getStartOffset()).y);
        } else {
            GutterIconRenderer gutterIconRenderer = this.getHighlighter().getGutterIconRenderer();
            if (gutterIconRenderer == null) {
                return;
            }
            GutterIconRenderer iconRenderer = gutterIconRenderer;
            FrontendDocRenderItemKt.setVisible(iconRenderer, visible);
            Editor editor3 = this.getEditor();
            Editor editor4 = this.getEditor();
            Intrinsics.checkNotNull((Object)editor4, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            int y = editor3.visualLineToY(((EditorImpl)editor4).offsetToVisualLine(this.getHighlighter().getStartOffset()));
            this.repaintGutter(y);
        }
    }

    public void toggle() {
        block0: {
            GutterIconRenderer gutterIconRenderer = this.renderer;
            if (gutterIconRenderer == null || (gutterIconRenderer = gutterIconRenderer.getClickAction()) == null) break block0;
            gutterIconRenderer.actionPerformed(AnActionEvent.createFromDataContext((String)"", null, arg_0 -> FrontendDocRenderItem.toggle$lambda$0(this, arg_0)));
        }
    }

    @Nullable
    public InlineDocumentation getInlineDocumentation() {
        return null;
    }

    @Nullable
    public DocumentationTarget getInlineDocumentationTarget() {
        Project project = this.getEditor().getProject();
        if (project == null) {
            return null;
        }
        List list = IdeDocumentationTargetProvider.getInstance((Project)project).documentationTargets(this.getEditor(), PsiEditorUtil.getPsiFile((Editor)this.getEditor()), this.getHighlighter().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"documentationTargets(...)");
        return (DocumentationTarget)CollectionsKt.firstOrNull((List)list);
    }

    private final void updateIcon() {
        CustomFoldRegion customFoldRegion = this.getFoldRegion();
        boolean bl = customFoldRegion != null ? customFoldRegion.isValid() : false;
        if (bl) {
            boolean prevState;
            Object object = this.getHighlighter().getGutterIconRenderer();
            boolean bl2 = prevState = object != null && (object = FrontendDocRenderItemKt.isVisible((GutterIconRenderer)object)) != null ? (Boolean)object : false;
            CustomFoldRegion customFoldRegion2 = this.getFoldRegion();
            if (customFoldRegion2 == null || (customFoldRegion2 = customFoldRegion2.getGutterIconRenderer()) == null) {
                return;
            }
            CustomFoldRegion iconRenderer = customFoldRegion2;
            FrontendDocRenderItemKt.setVisible((GutterIconRenderer)iconRenderer, prevState);
        } else {
            Object object = this.getFoldRegion();
            boolean prevState = object != null && (object = object.getGutterIconRenderer()) != null && (object = FrontendDocRenderItemKt.isVisible((GutterIconRenderer)object)) != null ? (Boolean)object : false;
            GutterIconRenderer gutterIconRenderer = this.getHighlighter().getGutterIconRenderer();
            if (gutterIconRenderer == null) {
                return;
            }
            GutterIconRenderer iconRenderer = gutterIconRenderer;
            FrontendDocRenderItemKt.setVisible(iconRenderer, prevState);
        }
    }

    private final void repaintGutter(int startY) {
        EditorGutter editorGutter = this.getEditor().getGutter();
        Intrinsics.checkNotNull((Object)editorGutter, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent gutter = (JComponent)editorGutter;
        gutter.repaint(0, startY, gutter.getWidth(), startY + this.getEditor().getLineHeight());
    }

    private static final Object toggle$lambda$0(FrontendDocRenderItem this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CommonDataKeys.PROJECT.is(it) ? (UserDataHolder)this$0.getEditor().getProject() : (CommonDataKeys.EDITOR.is(it) ? (UserDataHolder)this$0.getEditor() : null);
    }
}

