/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.foldings;

import com.intellij.codeInsight.folding.CollapseBlockHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.jetbrains.rdclient.daemon.highlighters.foldings.CollapseExpandImplementationsHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/CollapseCodeBlockHandler;", "Lcom/intellij/codeInsight/folding/CollapseBlockHandler;", "()V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.rd.client"})
public final class CollapseCodeBlockHandler
implements CollapseBlockHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> CODE_BLOCK_MARK;

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Ref.IntRef targetCaretOffset = new Ref.IntRef();
        targetCaretOffset.element = -1;
        FoldingModel foldingModel = editor2.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
        FoldingModel foldingModel2 = foldingModel;
        foldingModel2.runBatchFoldingOperation(() -> CollapseCodeBlockHandler.invoke$lambda$0(editor2, foldingModel2, targetCaretOffset));
        if (targetCaretOffset.element >= 0) {
            editor2.getCaretModel().moveToOffset(targetCaretOffset.element);
        }
    }

    private static final void invoke$lambda$0(Editor $editor, FoldingModel $foldingModel, Ref.IntRef $targetCaretOffset) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$foldingModel, (String)"$foldingModel");
        Intrinsics.checkNotNullParameter((Object)$targetCaretOffset, (String)"$targetCaretOffset");
        int offset = $editor.getCaretModel().getOffset();
        FoldingModelEx model = (FoldingModelEx)$foldingModel;
        FoldRegion min = null;
        FoldRegion[] foldRegionArray = model.getAllFoldRegions();
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
        for (FoldRegion region : foldRegionArray) {
            if (!region.isExpanded() || region.getStartOffset() > offset || region.getEndOffset() < offset) continue;
            if (!Intrinsics.areEqual((Object)region.getUserData(CODE_BLOCK_MARK), (Object)Boolean.TRUE)) {
                Intrinsics.checkNotNull((Object)region);
                if (!Intrinsics.areEqual((Object)CollapseExpandImplementationsHandler.Companion.getDefinitionMark(region), (Object)Boolean.TRUE)) continue;
            }
            if (min != null && (min.getStartOffset() > region.getStartOffset() || min.getEndOffset() < region.getEndOffset())) continue;
            min = region;
        }
        if (min != null) {
            min.setExpanded(false);
            $targetCaretOffset.element = min.getEndOffset();
        }
    }

    static {
        Key key = Key.create((String)"explicit.fold.region.codeblock.mark");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CODE_BLOCK_MARK = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/CollapseCodeBlockHandler$Companion;", "", "()V", "CODE_BLOCK_MARK", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "setCodeBlockMark", "", "region", "Lcom/intellij/openapi/editor/FoldRegion;", "value", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final void setCodeBlockMark(@NotNull FoldRegion region, boolean value) {
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            region.putUserData(CODE_BLOCK_MARK, (Object)value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

