/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterIdList;
import com.jetbrains.rd.ide.model.HighlighterList;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendHighlighterExtensionHandler;
import com.jetbrains.rdclient.daemon.FrontendHighlighterSuppressionHandler;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupCacheHighlightersIdStorageKt;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.FrontendMarkupSuppressor;
import com.jetbrains.rdclient.daemon.HighlighterRangeRepairer;
import com.jetbrains.rdclient.daemon.MarkupSuppressionKind;
import com.jetbrains.rdclient.daemon.RecyclingHighlighterStorage;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 62\u00020\u0001:\u00016B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u0016J\u0014\u0010\u001c\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0014\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001eJ\u0016\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0004J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020)H\u0007J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001fH\u0002J\b\u0010-\u001a\u00020\u0016H\u0004J\u001a\u0010.\u001a\u0004\u0018\u00010'2\u0006\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020\fH\u0002J\u0016\u00101\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00102\u001a\u00020)J\u0016\u00103\u001a\u00020\u00162\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001605H\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00067"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;", "", "markupAdapter", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "highlighterRepairer", "Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;", "storage", "Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "suppressor", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;", "(Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;)V", "<set-?>", "", "isUpdating", "()Z", "getMarkupAdapter", "()Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "getStorage", "()Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "getSuppressor", "()Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;", "bind", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "protocolMarkup", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "flushHighlighters", "highlightersAdded", "added", "", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "highlightersRemoved", "removed", "", "highlightersUpdated", "updated", "isReplaced", "highlighterModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "isSuppressed", "Lcom/jetbrains/rdclient/daemon/MarkupSuppressionKind;", "recycle", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "element", "removeAllHighlighters", "repair", "model", "trackInvalid", "suppress", "suppressionKind", "update", "block", "Lkotlin/Function0;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMarkupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,242:1\n1747#2,3:243\n1#3:246\n10#4:247\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n*L\n120#1:243,3\n23#1:247\n*E\n"})
public class FrontendMarkupContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FrontendMarkupAdapter markupAdapter;
    @NotNull
    private final HighlighterRangeRepairer highlighterRepairer;
    @NotNull
    private final RecyclingHighlighterStorage storage;
    @NotNull
    private final FrontendMarkupSuppressor suppressor;
    private boolean isUpdating;
    @NotNull
    private static final Logger logger;

    public FrontendMarkupContributor(@NotNull FrontendMarkupAdapter markupAdapter, @NotNull HighlighterRangeRepairer highlighterRepairer, @NotNull RecyclingHighlighterStorage storage, @NotNull FrontendMarkupSuppressor suppressor) {
        Intrinsics.checkNotNullParameter((Object)markupAdapter, (String)"markupAdapter");
        Intrinsics.checkNotNullParameter((Object)highlighterRepairer, (String)"highlighterRepairer");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)suppressor, (String)"suppressor");
        this.markupAdapter = markupAdapter;
        this.highlighterRepairer = highlighterRepairer;
        this.storage = storage;
        this.suppressor = suppressor;
    }

    @NotNull
    public final FrontendMarkupAdapter getMarkupAdapter() {
        return this.markupAdapter;
    }

    @NotNull
    public final RecyclingHighlighterStorage getStorage() {
        return this.storage;
    }

    @NotNull
    public final FrontendMarkupSuppressor getSuppressor() {
        return this.suppressor;
    }

    public final boolean isUpdating() {
        return this.isUpdating;
    }

    public final void flushHighlighters() {
        this.update((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                List<RangeHighlighterEx> notDeleted;
                Logger $this$trace$iv;
                HighlighterModel repairedModel;
                List extensions;
                Logger logger;
                void $this$trace$iv2;
                FrontendMarkupContributor.getLogger().debug("highlighter flush triggered!");
                Logger logger2 = FrontendMarkupContributor.getLogger();
                FrontendMarkupContributor frontendMarkupContributor = this.this$0;
                boolean bl = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    logger = $this$trace$iv2;
                    boolean bl2 = false;
                    logger.trace("highlighters in document:" + frontendMarkupContributor.getMarkupAdapter().getAllHighlighters().length);
                }
                List<Map.Entry<RangeHighlighterEx, HighlighterElement>> notUpdated = this.this$0.getStorage().flushNotUpdated();
                if (!((Collection)notUpdated).isEmpty()) {
                    for (Map.Entry entry : notUpdated) {
                        RangeHighlighterEx highlighter2 = (RangeHighlighterEx)entry.getKey();
                        HighlighterElement element = (HighlighterElement)entry.getValue();
                        HighlighterModel model = element.component1();
                        extensions = element.component2();
                        repairedModel = FrontendMarkupContributor.access$repair(this.this$0, model, false);
                        if (repairedModel == null) {
                            FrontendMarkupContributor.getLogger().warn("Received unrepairable update for highlighter during flush. Model: " + HighlightersUtilKt.prettyPrint(model));
                            continue;
                        }
                        this.this$0.getMarkupAdapter().updateHighlighter(highlighter2, new HighlighterElement(repairedModel, extensions));
                    }
                }
                ArrayList<HighlighterElement> notReused = new ArrayList<HighlighterElement>();
                List<HighlighterElement> list = this.this$0.getStorage().flushNotRegistered();
                if (!((Collection)list).isEmpty()) {
                    Logger $this$trace$iv3 = FrontendMarkupContributor.getLogger();
                    boolean $i$f$trace322 = false;
                    if ($this$trace$iv3.isTraceEnabled()) {
                        logger = $this$trace$iv3;
                        boolean bl3 = false;
                        logger.trace("Flushing to markup " + list.size() + " not registered highlighters");
                    }
                    for (HighlighterElement $i$f$trace322 : list) {
                        HighlighterModel highlighterModel = $i$f$trace322.component1();
                        extensions = $i$f$trace322.component2();
                        repairedModel = FrontendMarkupContributor.access$repair(this.this$0, highlighterModel, true);
                        if (repairedModel == null) {
                            FrontendMarkupContributor.getLogger().warn("Invalid highlighters are presented in notRegistered highlighters during flush");
                            continue;
                        }
                        HighlighterElement repairedElement = new HighlighterElement(repairedModel, extensions);
                        RangeHighlighterEx recycled = FrontendMarkupContributor.access$recycle(this.this$0, repairedElement);
                        if (recycled != null) continue;
                        notReused.add(repairedElement);
                    }
                    int reused = list.size() - notReused.size();
                    $this$trace$iv = FrontendMarkupContributor.getLogger();
                    boolean $i$f$trace4 = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        logger = $this$trace$iv;
                        boolean bl4 = false;
                        logger.trace("Reused " + reused + " highlighters during flush");
                    }
                }
                if (!((Collection)(notDeleted = this.this$0.getStorage().flushNotDeleted())).isEmpty()) {
                    $this$trace$iv = FrontendMarkupContributor.getLogger();
                    boolean $i$f$trace5 = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        logger = $this$trace$iv;
                        boolean bl5 = false;
                        logger.trace("Deleting " + notDeleted.size() + " highlighters from markup");
                    }
                    this.this$0.getMarkupAdapter().bulkRemoveHighlighters(notDeleted);
                }
                if (notReused.size() != 0) {
                    $this$trace$iv = FrontendMarkupContributor.getLogger();
                    boolean $i$f$trace6 = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        logger = $this$trace$iv;
                        boolean bl6 = false;
                        logger.trace("Registering last portion of " + notReused.size() + " highlighters which have failed at reusing");
                    }
                    List<RangeHighlighterEx> added = this.this$0.getMarkupAdapter().bulkAddHighlighters((List<HighlighterElement>)notReused);
                    int n = added.size();
                    for (int i = 0; i < n; ++i) {
                        this.this$0.getStorage().addHighlighter(FrontendMarkupCacheHighlightersIdStorageKt.getCacheAwareId(((HighlighterElement)notReused.get(i)).getHighlighter()), added.get(i));
                    }
                }
                FrontendMarkupContributor.access$getHighlighterRepairer$p(this.this$0).shrinkHistory();
            }
        }));
    }

    public final void highlightersAdded(@NotNull List<HighlighterElement> added) {
        Intrinsics.checkNotNullParameter(added, (String)"added");
        this.update((Function0<Unit>)((Function0)new Function0<Unit>(added, this){
            final /* synthetic */ List<HighlighterElement> $added;
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.$added = $added;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                List repairedModels = new ArrayList<E>();
                for (HighlighterElement element : this.$added) {
                    HighlighterModel repairedModel;
                    boolean bl;
                    HighlighterModel highlighterModel = element.getHighlighter();
                    List extensions = element.getExtensions();
                    boolean bl2 = bl = this.this$0.getStorage().get(FrontendMarkupCacheHighlightersIdStorageKt.getCacheAwareId(highlighterModel)) == null;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22 = false;
                        String $i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22 = "Multiple highlighter registration on IDEA-side! id: " + FrontendMarkupCacheHighlightersIdStorageKt.getCacheAwareId(highlighterModel) + " model: " + HighlightersUtilKt.prettyPrint(highlighterModel);
                        throw new AssertionError((Object)$i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22);
                    }
                    if (FrontendMarkupContributor.access$repair(this.this$0, highlighterModel, true) == null || FrontendMarkupContributor.access$isReplaced(this.this$0, highlighterModel)) continue;
                    FrontendHighlighterExtensionHandler.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> highlightersAdded.1.invoke$lambda$1(highlightersAdded.2.INSTANCE, arg_0));
                    HighlighterElement repairedElement = new HighlighterElement(repairedModel, extensions);
                    if (this.this$0.getSuppressor().shouldSuppressAddition(highlighterModel.getProperties())) {
                        RangeHighlighterEx rangeHighlighterEx = FrontendMarkupContributor.access$recycle(this.this$0, repairedElement);
                        if (rangeHighlighterEx == null) {
                            this.this$0.getStorage().queueRegistration(element);
                            rangeHighlighterEx = Unit.INSTANCE;
                        }
                        continue;
                    }
                    repairedModels.add(repairedElement);
                }
                if (repairedModels.isEmpty()) {
                    return;
                }
                List<RangeHighlighterEx> bulkAdded = this.this$0.getMarkupAdapter().bulkAddHighlighters(repairedModels);
                int n = bulkAdded.size();
                for (int i = 0; i < n; ++i) {
                    this.this$0.getStorage().addHighlighter(FrontendMarkupCacheHighlightersIdStorageKt.getCacheAwareId(((HighlighterElement)repairedModels.get(i)).getHighlighter()), bulkAdded.get(i));
                }
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }));
    }

    private final boolean isReplaced(HighlighterModel highlighterModel) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = FrontendHighlighterSuppressionHandler.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FrontendHighlighterSuppressionHandler it = (FrontendHighlighterSuppressionHandler)element$iv;
                    boolean bl2 = false;
                    if (!it.shouldSuppress(highlighterModel, this.markupAdapter.getDocument())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected final void highlightersUpdated(@NotNull List<HighlighterElement> updated) {
        Intrinsics.checkNotNullParameter(updated, (String)"updated");
        this.update((Function0<Unit>)((Function0)new Function0<Unit>(updated, this){
            final /* synthetic */ List<HighlighterElement> $updated;
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.$updated = $updated;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                for (HighlighterElement element : this.$updated) {
                    if (this.this$0.getStorage().updateRegistration(element)) continue;
                    RangeHighlighterEx highlighter2 = this.this$0.getStorage().get(element.getHighlighter().getId());
                    if (highlighter2 == null) {
                        FrontendMarkupContributor.getLogger().warn("Received update for not registered highlighter " + HighlightersUtilKt.prettyPrint(element.getHighlighter()));
                        continue;
                    }
                    if (this.this$0.getSuppressor().shouldSuppressUpdate()) {
                        this.this$0.getStorage().queueUpdate(highlighter2, element);
                        continue;
                    }
                    HighlighterModel repairedModel = FrontendMarkupContributor.access$repair(this.this$0, element.getHighlighter(), false);
                    if (repairedModel == null) {
                        FrontendMarkupContributor.getLogger().warn("Received unrepairable update for highlighter. Model: " + HighlightersUtilKt.prettyPrint(element.getHighlighter()));
                        continue;
                    }
                    this.this$0.getMarkupAdapter().updateHighlighter(highlighter2, new HighlighterElement(repairedModel, element.getExtensions()));
                }
            }
        }));
    }

    private final HighlighterModel repair(HighlighterModel model, boolean trackInvalid) {
        HighlighterModel highlighterModel = this.highlighterRepairer.repair(model);
        if (highlighterModel != null) {
            HighlighterModel it = highlighterModel;
            boolean bl = false;
            return it;
        }
        if (trackInvalid) {
            this.storage.addInvalidHighlighter(model);
        }
        return null;
    }

    private final RangeHighlighterEx recycle(HighlighterElement element) {
        RangeHighlighterEx recycledHighlighter = this.storage.recycle(element.getHighlighter());
        if (recycledHighlighter != null) {
            this.markupAdapter.updateHighlighter(recycledHighlighter, element);
        }
        return recycledHighlighter;
    }

    public final void highlightersRemoved(@NotNull List<Long> removed) {
        Intrinsics.checkNotNullParameter(removed, (String)"removed");
        this.update((Function0<Unit>)((Function0)new Function0<Unit>(removed, this){
            final /* synthetic */ List<Long> $removed;
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.$removed = $removed;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                List toRemove = new ArrayList<E>();
                Iterator<Long> iterator2 = this.$removed.iterator();
                while (iterator2.hasNext()) {
                    RangeHighlighterEx highlighter2;
                    long id = ((Number)iterator2.next()).longValue();
                    if (this.this$0.getStorage().remove(id) == null) continue;
                    if (this.this$0.getSuppressor().shouldSuppressDeletion(UtilKt.getBackendProperties((RangeHighlighter)((RangeHighlighter)highlighter2)))) {
                        this.this$0.getStorage().queueDeletion(highlighter2);
                        continue;
                    }
                    toRemove.add(highlighter2);
                }
                if (toRemove.isEmpty()) {
                    return;
                }
                this.this$0.getMarkupAdapter().bulkRemoveHighlighters(toRemove);
            }
        }));
    }

    protected final void removeAllHighlighters() {
        this.update((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                boolean any;
                block3: {
                    boolean bl;
                    void $this$trace$iv;
                    List allHighlighters = CollectionsKt.plus(this.this$0.getStorage().getRegisteredHighlighters(), (Iterable)this.this$0.getStorage().flushNotDeleted());
                    FrontendMarkupContributor.getLogger().debug("Cleaning highlighter storage. Total amount " + allHighlighters.size());
                    this.this$0.getMarkupAdapter().bulkRemoveHighlighters(allHighlighters);
                    this.this$0.getStorage().clear();
                    Logger logger = FrontendMarkupContributor.getLogger();
                    FrontendMarkupContributor frontendMarkupContributor = this.this$0;
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        void var10_6 = $this$trace$iv;
                        boolean bl2 = false;
                        var10_6.trace("storage: " + frontendMarkupContributor.getStorage());
                    }
                    RangeHighlighterEx[] $this$any$iv = this.this$0.getMarkupAdapter().getAllHighlighters();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        RangeHighlighterEx element$iv;
                        RangeHighlighterEx it = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        if (!HighlightersUtilKt.isBackendHighlighter((RangeHighlighter)it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = any = false;
                }
                if (any) {
                    FrontendMarkupContributor.getLogger().error("backend highlighters present in Markup model after cleaning");
                }
            }
        }));
    }

    public final void suppress(@NotNull Lifetime lifetime, @NotNull MarkupSuppressionKind suppressionKind) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)suppressionKind), (String)"suppressionKind");
        this.suppressor.suppress(lifetime, suppressionKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void update(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            this.isUpdating = true;
            block.invoke();
        }
        finally {
            this.isUpdating = false;
        }
    }

    public void bind(@NotNull Lifetime lifetime, @NotNull RdMarkupModel protocolMarkup) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)protocolMarkup, (String)"protocolMarkup");
        protocolMarkup.getHighlightersRemoved().advise(lifetime, (Function1)new Function1<HighlighterIdList, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HighlighterIdList it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.highlightersRemoved(it.getElements());
            }
        });
        protocolMarkup.getHighlightersAdded().advise(lifetime, (Function1)new Function1<HighlighterList, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HighlighterList it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.highlightersAdded(it.getElements());
            }
        });
        protocolMarkup.getHighlightersUpdated().advise(lifetime, (Function1)new Function1<HighlighterList, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HighlighterList it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.highlightersUpdated(it.getElements());
            }
        });
        protocolMarkup.getHighlightersCleared().advise(lifetime, (Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.removeAllHighlighters();
            }
        });
        this.suppressor.released(lifetime, (Function1<? super Lifetime, Unit>)((Function1)new Function1<Lifetime, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Lifetime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.flushHighlighters();
            }
        }));
        lifetime.onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.removeAllHighlighters();
            }
        });
    }

    @TestOnly
    @NotNull
    public final MarkupSuppressionKind isSuppressed() {
        return this.suppressor.isSuppressed();
    }

    @NotNull
    protected static final Logger getLogger() {
        return Companion.getLogger();
    }

    public static final /* synthetic */ HighlighterModel access$repair(FrontendMarkupContributor $this, HighlighterModel model, boolean trackInvalid) {
        return $this.repair(model, trackInvalid);
    }

    public static final /* synthetic */ RangeHighlighterEx access$recycle(FrontendMarkupContributor $this, HighlighterElement element) {
        return $this.recycle(element);
    }

    public static final /* synthetic */ HighlighterRangeRepairer access$getHighlighterRepairer$p(FrontendMarkupContributor $this) {
        return $this.highlighterRepairer;
    }

    public static final /* synthetic */ boolean access$isReplaced(FrontendMarkupContributor $this, HighlighterModel highlighterModel) {
        return $this.isReplaced(highlighterModel);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendMarkupContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendMarkupContributor.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        protected static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

