/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.thinclient.terminal;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.thinclient.services.ThinClientPermissionHost;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.action.TerminalNewTabAction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalActionConfigurationCustomizer;", "Lcom/intellij/openapi/actionSystem/impl/ActionConfigurationCustomizer;", "()V", "customize", "", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "Companion", "intellij.cwm.guest.terminal"})
@SourceDebugExtension(value={"SMAP\nThinClientTerminalActionConfigurationCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientTerminalActionConfigurationCustomizer.kt\ncom/jetbrains/thinclient/terminal/ThinClientTerminalActionConfigurationCustomizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,37:1\n10#2:38\n*S KotlinDebug\n*F\n+ 1 ThinClientTerminalActionConfigurationCustomizer.kt\ncom/jetbrains/thinclient/terminal/ThinClientTerminalActionConfigurationCustomizer\n*L\n15#1:38\n*E\n"})
public final class ThinClientTerminalActionConfigurationCustomizer
implements ActionConfigurationCustomizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public void customize(@NotNull ActionManager actionManager) {
        Intrinsics.checkNotNullParameter((Object)actionManager, (String)"actionManager");
        logger.trace("Patch action 'Terminal.NewTab'...");
        actionManager.replaceAction("Terminal.NewTab", (AnAction)new TerminalNewTabAction(){

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.update(e);
                Project project = e.getProject();
                if (project == null) {
                    return;
                }
                Project project2 = project;
                if (!ThinClientPermissionHost.Companion.getInstance().hasFullAccessToTerminal()) {
                    Presentation presentation = e.getPresentation();
                    Icon icon = e.getPresentation().getDisabledIcon();
                    if (icon == null) {
                        Icon icon2 = ActionButtonLook.SYSTEM_LOOK.getDisabledIcon(AllIcons.General.Add);
                        icon = icon2;
                        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getDisabledIcon(...)");
                    }
                    presentation.setDisabledIcon(ThinClientPermissionHost.Companion.decorateIcon$default((ThinClientPermissionHost.Companion)ThinClientPermissionHost.Companion, (Icon)icon, null, (int)2, null));
                    Presentation presentation2 = e.getPresentation();
                    Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
                    AnAction anAction = (AnAction)this;
                    String string = e.getPlace();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
                    ThinClientPermissionHost.Companion.setRequestFullAccessTooltip(presentation2, anAction, string);
                    e.getPresentation().setEnabled(false);
                } else {
                    e.getPresentation().setDisabledIcon(null);
                    e.getPresentation().putClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP, null);
                }
            }
        });
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientTerminalActionConfigurationCustomizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientTerminalActionConfigurationCustomizer.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalActionConfigurationCustomizer$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cwm.guest.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

