/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.listeners;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.logging.Logger;
import org.gradle.internal.impldep.org.junit.platform.commons.logging.LoggerFactory;
import org.gradle.internal.impldep.org.junit.platform.commons.util.StringUtils;
import org.gradle.internal.impldep.org.junit.platform.engine.ConfigurationParameters;
import org.gradle.internal.impldep.org.junit.platform.engine.TestExecutionResult;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestIdentifier;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestPlan;

@API(status=API.Status.EXPERIMENTAL, since="1.8")
public class UniqueIdTrackingListener
implements TestExecutionListener {
    public static final String LISTENER_ENABLED_PROPERTY_NAME = "junit.platform.listeners.uid.tracking.enabled";
    public static final String OUTPUT_DIR_PROPERTY_NAME = "junit.platform.listeners.uid.tracking.output.dir";
    public static final String OUTPUT_FILE_PREFIX_PROPERTY_NAME = "junit.platform.listeners.uid.tracking.output.file.prefix";
    public static final String DEFAULT_OUTPUT_FILE_PREFIX = "junit-platform-unique-ids";
    private final Logger logger = LoggerFactory.getLogger(UniqueIdTrackingListener.class);
    private final List<String> uniqueIds = new ArrayList<String>();
    private boolean enabled;

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.enabled = testPlan.getConfigurationParameters().getBoolean(LISTENER_ENABLED_PROPERTY_NAME).orElse(false);
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.trackTestUid(testIdentifier);
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.trackTestUid(testIdentifier);
    }

    private void trackTestUid(TestIdentifier testIdentifier) {
        if (this.enabled && testIdentifier.isTest()) {
            this.uniqueIds.add(testIdentifier.getUniqueId());
        }
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (this.enabled) {
            Path outputFile;
            try {
                outputFile = this.getOutputFile(testPlan.getConfigurationParameters());
            }
            catch (IOException ex) {
                this.logger.error(ex, () -> "Failed to create output file");
                return;
            }
            this.logger.debug(() -> "Writing unique IDs to output file " + outputFile.toAbsolutePath());
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]));){
                this.uniqueIds.forEach(writer::println);
                writer.flush();
            }
            catch (IOException ex) {
                this.logger.error(ex, () -> "Failed to write unique IDs to output file " + outputFile.toAbsolutePath());
            }
        }
    }

    private Path getOutputFile(ConfigurationParameters configurationParameters) throws IOException {
        String prefix = configurationParameters.get(OUTPUT_FILE_PREFIX_PROPERTY_NAME).orElse(DEFAULT_OUTPUT_FILE_PREFIX);
        String filename = String.format("%s-%d.txt", prefix, Math.abs(new SecureRandom().nextLong()));
        Path outputFile = this.getOutputDir(configurationParameters).resolve(filename);
        if (Files.exists(outputFile, new LinkOption[0])) {
            Files.delete(outputFile);
        }
        Files.createFile(outputFile, new FileAttribute[0]);
        return outputFile;
    }

    Path getOutputDir(ConfigurationParameters configurationParameters) throws IOException {
        Path cwd = this.currentWorkingDir();
        String customDir = configurationParameters.get(OUTPUT_DIR_PROPERTY_NAME).orElse(null);
        Path outputDir = StringUtils.isNotBlank(customDir) ? cwd.resolve(customDir) : (Files.exists(cwd.resolve("pom.xml"), new LinkOption[0]) ? cwd.resolve("target") : (this.containsFilesWithExtensions(cwd, ".gradle", ".gradle.kts") ? cwd.resolve("build") : cwd));
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        return outputDir;
    }

    Path currentWorkingDir() {
        return Paths.get(".", new String[0]);
    }

    private boolean containsFilesWithExtensions(Path dir2, String ... extensions) throws IOException {
        return Files.find(dir2, 1, (path, basicFileAttributes) -> {
            if (basicFileAttributes.isRegularFile()) {
                for (String extension : extensions) {
                    if (!path.getFileName().toString().endsWith(extension)) continue;
                    return true;
                }
            }
            return false;
        }, new FileVisitOption[0]).findFirst().isPresent();
    }
}

