/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftree;

import java.io.IOException;
import java.util.ArrayList;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftree.Command;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftree.RefTreeBatch;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftree.RefTreeUpdate;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectIdRef;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RefRename;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RefUpdate;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.SymbolicRef;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;

class RefTreeRename
extends RefRename {
    private final RefTreeDatabase refdb;

    RefTreeRename(RefTreeDatabase refdb, RefUpdate src, RefUpdate dst) {
        super(src, dst);
        this.refdb = refdb;
    }

    @Override
    protected RefUpdate.Result doRename() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (RevWalk rw = new RevWalk(this.refdb.getRepository());){
            RefTreeBatch batch = new RefTreeBatch(this.refdb);
            batch.setRefLogIdent(this.getRefLogIdent());
            batch.setRefLogMessage(this.getRefLogMessage(), false);
            batch.init(rw);
            Ref head = batch.exactRef(rw.getObjectReader(), "HEAD");
            Ref oldRef = batch.exactRef(rw.getObjectReader(), this.source.getName());
            if (oldRef == null) {
                return RefUpdate.Result.REJECTED;
            }
            Ref newRef = this.asNew(oldRef);
            ArrayList<Command> mv = new ArrayList<Command>(3);
            mv.add(new Command(oldRef, null));
            mv.add(new Command(null, newRef));
            if (head != null && head.isSymbolic() && head.getTarget().getName().equals(oldRef.getName())) {
                mv.add(new Command(head, new SymbolicRef(head.getName(), newRef)));
            }
            batch.execute(rw, mv);
            return RefTreeUpdate.translate(((Command)mv.get(1)).getResult(), RefUpdate.Result.RENAMED);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Ref asNew(Ref src) {
        String name = this.destination.getName();
        if (src.isSymbolic()) {
            return new SymbolicRef(name, src.getTarget());
        }
        ObjectId peeled = src.getPeeledObjectId();
        if (peeled != null) {
            return new ObjectIdRef.PeeledTag(src.getStorage(), name, src.getObjectId(), peeled);
        }
        return new ObjectIdRef.PeeledNonTag(src.getStorage(), name, src.getObjectId());
    }
}

