/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc;

import java.security.SecureRandom;
import org.gradle.internal.impldep.org.bouncycastle.crypto.BlockCipher;
import org.gradle.internal.impldep.org.bouncycastle.crypto.BufferedBlockCipher;
import org.gradle.internal.impldep.org.bouncycastle.crypto.InvalidCipherTextException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPBESecretKeyEncryptorBuilder {
    private int encAlgorithm;
    private PGPDigestCalculator s2kDigestCalculator;
    private SecureRandom random;
    private int s2kCount = 96;

    public BcPBESecretKeyEncryptorBuilder(int n) {
        this(n, new SHA1PGPDigestCalculator());
    }

    public BcPBESecretKeyEncryptorBuilder(int n, int n2) {
        this(n, new SHA1PGPDigestCalculator(), n2);
    }

    public BcPBESecretKeyEncryptorBuilder(int n, PGPDigestCalculator pGPDigestCalculator) {
        this(n, pGPDigestCalculator, 96);
    }

    public BcPBESecretKeyEncryptorBuilder(int n, PGPDigestCalculator pGPDigestCalculator, int n2) {
        this.encAlgorithm = n;
        this.s2kDigestCalculator = pGPDigestCalculator;
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("s2KCount value outside of range 0 to 255.");
        }
        this.s2kCount = n2;
    }

    public BcPBESecretKeyEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PBESecretKeyEncryptor build(char[] cArray) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return new PBESecretKeyEncryptor(this.encAlgorithm, this.s2kDigestCalculator, this.s2kCount, this.random, cArray){
            private byte[] iv;

            public byte[] encryptKeyData(byte[] byArray, byte[] byArray2, int n, int n2) throws PGPException {
                return this.encryptKeyData(byArray, null, byArray2, n, n2);
            }

            public byte[] encryptKeyData(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2) throws PGPException {
                try {
                    BlockCipher blockCipher = BcImplProvider.createBlockCipher(this.encAlgorithm);
                    if (byArray2 != null) {
                        this.iv = byArray2;
                    } else {
                        if (this.random == null) {
                            this.random = new SecureRandom();
                        }
                        byArray2 = new byte[blockCipher.getBlockSize()];
                        this.iv = byArray2;
                        this.random.nextBytes(byArray2);
                    }
                    BufferedBlockCipher bufferedBlockCipher = BcUtil.createSymmetricKeyWrapper(true, blockCipher, byArray, byArray2);
                    byte[] byArray4 = new byte[n2];
                    int n3 = bufferedBlockCipher.processBytes(byArray3, n, n2, byArray4, 0);
                    n3 += bufferedBlockCipher.doFinal(byArray4, n3);
                    return byArray4;
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new PGPException("decryption failed: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                }
            }

            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

