/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.plugins.repository.url;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.ivy.core.settings.TimeoutConstraint;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.AbstractRepository;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.Resource;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.url.URLResource;
import org.gradle.internal.impldep.org.apache.ivy.util.CopyProgressListener;
import org.gradle.internal.impldep.org.apache.ivy.util.FileUtil;
import org.gradle.internal.impldep.org.apache.ivy.util.url.ApacheURLLister;

public class URLRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener progress = new RepositoryCopyProgressListener(this);
    private final Map<String, Resource> resourcesCache = new HashMap<String, Resource>();
    private ApacheURLLister lister = new ApacheURLLister();

    public URLRepository() {
    }

    public URLRepository(TimeoutConstraint timeoutConstraint) {
        super(timeoutConstraint);
    }

    @Override
    public Resource getResource(String source) throws IOException {
        Resource res = this.resourcesCache.get(source);
        if (res == null) {
            res = new URLResource(new URL(source), this.getTimeoutConstraint());
            this.resourcesCache.put(source, res);
        }
        return res;
    }

    @Override
    public void get(String source, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source), 5);
        try {
            Resource res = this.getResource(source);
            long totalLength = res.getContentLength();
            if (totalLength > 0L) {
                this.progress.setTotalLength(totalLength);
            }
            FileUtil.copy(new URL(source), destination, (CopyProgressListener)this.progress, this.getTimeoutConstraint());
        }
        catch (IOException | RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        finally {
            this.progress.setTotalLength(null);
        }
    }

    @Override
    public void put(File source, String destination, boolean overwrite) throws IOException {
        if (!overwrite && this.getResource(destination).exists()) {
            throw new IOException("destination file exists and overwrite == false");
        }
        this.fireTransferInitiated(this.getResource(destination), 6);
        try {
            long totalLength = source.length();
            if (totalLength > 0L) {
                this.progress.setTotalLength(totalLength);
            }
            FileUtil.copy(source, new URL(destination), (CopyProgressListener)this.progress, this.getTimeoutConstraint());
        }
        catch (IOException | RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        finally {
            this.progress.setTotalLength(null);
        }
    }

    @Override
    public List<String> list(String parent) throws IOException {
        if (parent.startsWith("http")) {
            List<URL> urls = this.lister.listAll(new URL(parent));
            if (urls != null) {
                ArrayList<String> ret = new ArrayList<String>(urls.size());
                for (URL url : urls) {
                    ret.add(url.toExternalForm());
                }
                return ret;
            }
        } else if (parent.startsWith("file")) {
            String path;
            try {
                URI uri = new URI(parent);
                path = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
            }
            catch (URISyntaxException e) {
                throw new IOException("Couldn't list content of '" + parent + "'", e);
            }
            File file = new File(path);
            if (file.exists() && file.isDirectory()) {
                String[] files = file.list();
                ArrayList<String> ret = new ArrayList<String>(files.length);
                URL context = path.endsWith("/") ? new URL(parent) : new URL(parent + "/");
                for (String fileName : files) {
                    ret.add(new URL(context, fileName).toExternalForm());
                }
                return ret;
            }
            return Collections.emptyList();
        }
        return null;
    }
}

