/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Configuration;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.core.report.DownloadStatus;
import org.gradle.internal.impldep.org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.IvyNode;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveData;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.gradle.internal.impldep.org.apache.ivy.osgi.repo.EditableRepoDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.osgi.repo.ModuleDescriptorWrapper;
import org.gradle.internal.impldep.org.apache.ivy.osgi.repo.RepoDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.osgi.util.Version;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.Resource;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.url.URLRepository;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.url.URLResource;
import org.gradle.internal.impldep.org.apache.ivy.plugins.resolver.BasicResolver;
import org.gradle.internal.impldep.org.apache.ivy.plugins.resolver.util.MDResolvedResource;
import org.gradle.internal.impldep.org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.gradle.internal.impldep.org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;
import org.gradle.internal.impldep.org.apache.ivy.util.StringUtils;

public abstract class AbstractOSGiResolver
extends BasicResolver {
    private static final String CAPABILITY_EXTRA_ATTR = "osgi_bundle";
    protected static final RepoDescriptor FAILING_REPO_DESCRIPTOR = new EditableRepoDescriptor(null, null);
    private RepoDescriptor repoDescriptor = null;
    private URLRepository repository = new URLRepository();
    private RequirementStrategy requirementStrategy = RequirementStrategy.noambiguity;

    public void setRequirementStrategy(RequirementStrategy importPackageStrategy) {
        this.requirementStrategy = importPackageStrategy;
    }

    public void setRequirementStrategy(String strategy) {
        this.setRequirementStrategy(RequirementStrategy.valueOf(strategy));
    }

    protected void setRepoDescriptor(RepoDescriptor repoDescriptor) {
        this.repoDescriptor = repoDescriptor;
    }

    public URLRepository getRepository() {
        return this.repository;
    }

    protected void ensureInit() {
        if (this.repoDescriptor == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                this.repoDescriptor = FAILING_REPO_DESCRIPTOR;
                throw new RuntimeException("Error while loading the OSGi repo descriptor" + e.getMessage() + " (" + e.getClass().getName() + ")", e);
            }
        } else if (this.repoDescriptor == FAILING_REPO_DESCRIPTOR) {
            throw new RuntimeException("The repository " + this.getName() + " already failed to load");
        }
    }

    protected abstract void init();

    public RepoDescriptor getRepoDescriptor() {
        this.ensureInit();
        return this.repoDescriptor;
    }

    @Override
    public boolean isAllownomd() {
        return false;
    }

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        String osgiType = mrid.getOrganisation();
        if (osgiType == null) {
            throw new RuntimeException("Unsupported OSGi module Id: " + mrid.getModuleId());
        }
        String id = mrid.getName();
        Collection<ModuleDescriptor> mds = ModuleDescriptorWrapper.unwrap(this.getRepoDescriptor().findModules(osgiType, id));
        if (mds == null || mds.isEmpty()) {
            Message.verbose("\t " + id + " not found.");
            return null;
        }
        ResolvedResource[] ret = "bundle".equals(osgiType) ? this.findBundle(dd, data, mds) : this.findCapability(dd, data, mds);
        ResolvedResource found = this.findResource(ret, this.getDefaultRMDParser(dd.getDependencyId()), mrid, data.getDate());
        if (found == null) {
            Message.debug("\t" + this.getName() + ": no resource found for " + mrid);
        }
        return found;
    }

    public ResolvedResource[] findBundle(DependencyDescriptor dd, ResolveData data, Collection<ModuleDescriptor> mds) {
        ResolvedResource[] ret = new ResolvedResource[mds.size()];
        int i = 0;
        for (ModuleDescriptor md : mds) {
            MetadataArtifactDownloadReport report = new MetadataArtifactDownloadReport(null);
            report.setDownloadStatus(DownloadStatus.NO);
            report.setSearched(true);
            ResolvedModuleRevision rmr = new ResolvedModuleRevision(this, this, md, report);
            MDResolvedResource mdrr = new MDResolvedResource(null, md.getRevision(), rmr);
            ret[i++] = mdrr;
        }
        return ret;
    }

    public ResolvedResource[] findCapability(DependencyDescriptor dd, ResolveData data, Collection<ModuleDescriptor> mds) {
        ArrayList<MDResolvedResource> ret = new ArrayList<MDResolvedResource>(mds.size());
        for (ModuleDescriptor md : mds) {
            IvyNode node = data.getNode(md.getModuleRevisionId());
            if (node != null && node.getDescriptor() != null) {
                return new ResolvedResource[]{this.buildResolvedCapabilityMd(dd, node.getDescriptor())};
            }
            ret.add(this.buildResolvedCapabilityMd(dd, md));
        }
        return ret.toArray(new ResolvedResource[mds.size()]);
    }

    private MDResolvedResource buildResolvedCapabilityMd(DependencyDescriptor dd, ModuleDescriptor md) {
        String org = dd.getDependencyRevisionId().getOrganisation();
        String name = dd.getDependencyRevisionId().getName();
        String rev = md.getExtraInfoContentByTagName("_osgi_export_" + name);
        ModuleRevisionId capabilityRev = ModuleRevisionId.newInstance(org, name, rev, Collections.singletonMap(CAPABILITY_EXTRA_ATTR, md.getModuleRevisionId().toString()));
        DefaultModuleDescriptor capabilityMd = new DefaultModuleDescriptor(capabilityRev, this.getSettings().getStatusManager().getDefaultStatus(), new Date());
        String useConf = "use_" + dd.getDependencyRevisionId().getName();
        capabilityMd.addConfiguration(BundleInfoAdapter.CONF_DEFAULT);
        capabilityMd.addConfiguration(BundleInfoAdapter.CONF_OPTIONAL);
        capabilityMd.addConfiguration(BundleInfoAdapter.CONF_TRANSITIVE_OPTIONAL);
        capabilityMd.addConfiguration(new Configuration(useConf));
        DefaultDependencyDescriptor capabilityDD = new DefaultDependencyDescriptor(md.getModuleRevisionId(), false);
        capabilityDD.addDependencyConfiguration("default", "default");
        capabilityDD.addDependencyConfiguration("optional", "optional");
        capabilityDD.addDependencyConfiguration("transitive-optional", "transitive-optional");
        capabilityDD.addDependencyConfiguration(useConf, useConf);
        capabilityMd.addDependency(capabilityDD);
        MetadataArtifactDownloadReport report = new MetadataArtifactDownloadReport(null);
        report.setDownloadStatus(DownloadStatus.NO);
        report.setSearched(true);
        ResolvedModuleRevision rmr = new ResolvedModuleRevision(this, this, capabilityMd, report);
        return new MDResolvedResource(null, capabilityMd.getRevision(), rmr);
    }

    @Override
    public ResolvedResource findResource(ResolvedResource[] rress, ResourceMDParser rmdparser, ModuleRevisionId mrid, Date date) {
        ResolvedResource found = super.findResource(rress, rmdparser, mrid, date);
        if (found == null) {
            return null;
        }
        String osgiType = mrid.getOrganisation();
        if (!"bundle".equals(osgiType)) {
            if (rress.length != 1) {
                HashMap<String, ArrayList<MDResolvedResource>> matching = new HashMap<String, ArrayList<MDResolvedResource>>();
                for (ResolvedResource rres : rress) {
                    String name = ((MDResolvedResource)rres).getResolvedModuleRevision().getDescriptor().getExtraAttribute(CAPABILITY_EXTRA_ATTR);
                    ArrayList<MDResolvedResource> list = (ArrayList<MDResolvedResource>)matching.get(name);
                    if (list == null) {
                        list = new ArrayList<MDResolvedResource>();
                        matching.put(name, list);
                    }
                    list.add((MDResolvedResource)rres);
                }
                if (matching.keySet().size() != 1) {
                    if (this.requirementStrategy == RequirementStrategy.first) {
                        Message.warn("Ambiguity for the '" + osgiType + "' requirement " + mrid.getName() + ";version=" + mrid.getRevision());
                        for (Map.Entry entry : matching.entrySet()) {
                            Message.warn("\t" + (String)entry.getKey());
                            for (MDResolvedResource c : (List)entry.getValue()) {
                                Message.warn("\t\t" + c.getRevision() + (found == c ? " (selected)" : ""));
                            }
                        }
                    } else if (this.requirementStrategy == RequirementStrategy.noambiguity) {
                        Message.error("Ambiguity for the '" + osgiType + "' requirement " + mrid.getName() + ";version=" + mrid.getRevision());
                        for (Map.Entry entry : matching.entrySet()) {
                            Message.error("\t" + (String)entry.getKey());
                            for (MDResolvedResource c : (List)entry.getValue()) {
                                Message.error("\t\t" + c.getRevision() + (found == c ? " (best match)" : ""));
                            }
                        }
                        return null;
                    }
                }
            }
            Message.info("'" + osgiType + "' requirement " + mrid.getName() + ";version=" + mrid.getRevision() + " satisfied by " + ((MDResolvedResource)found).getResolvedModuleRevision().getId().getName() + ";" + found.getRevision());
        }
        return found;
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        URL url = artifact.getUrl();
        if (url == null) {
            return null;
        }
        Message.verbose("\tusing url for " + artifact + ": " + url);
        this.logArtifactAttempt(artifact, url.toExternalForm());
        URLResource resource = new URLResource(url, this.getTimeoutConstraint());
        return new ResolvedResource(resource, artifact.getModuleRevisionId().getRevision());
    }

    @Override
    protected void checkModuleDescriptorRevision(ModuleDescriptor systemMd, ModuleRevisionId systemMrid) {
        String osgiType = systemMrid.getOrganisation();
        if (osgiType == null || osgiType.equals("bundle")) {
            super.checkModuleDescriptorRevision(systemMd, systemMrid);
        }
    }

    @Override
    protected Collection<String> filterNames(Collection<String> names) {
        this.getSettings().filterIgnore(names);
        return names;
    }

    @Override
    protected Collection<String> findNames(Map<String, String> tokenValues, String token) {
        if ("organisation".equals(token)) {
            return this.getRepoDescriptor().getCapabilities();
        }
        String osgiType = tokenValues.get("organisation");
        if (StringUtils.isNullOrEmpty(osgiType)) {
            return Collections.emptyList();
        }
        if ("module".equals(token)) {
            return this.getRepoDescriptor().getCapabilityValues(osgiType);
        }
        if ("revision".equals(token)) {
            String name = tokenValues.get("module");
            ArrayList<String> versions = new ArrayList<String>();
            Set<ModuleDescriptorWrapper> mds = this.getRepoDescriptor().findModules(osgiType, name);
            if (mds != null) {
                for (ModuleDescriptorWrapper md : mds) {
                    versions.add(md.getBundleInfo().getVersion().toString());
                }
            }
            return versions;
        }
        if ("conf".equals(token)) {
            String name = tokenValues.get("module");
            if (name == null) {
                return Collections.emptyList();
            }
            if (osgiType.equals("package")) {
                return Collections.singletonList("use_" + name);
            }
            Collection<ModuleDescriptor> mds = ModuleDescriptorWrapper.unwrap(this.getRepoDescriptor().findModules(osgiType, name));
            if (mds == null) {
                return Collections.emptyList();
            }
            String version = tokenValues.get("revision");
            if (version == null) {
                return Collections.emptyList();
            }
            ModuleDescriptor found = null;
            for (ModuleDescriptor md : mds) {
                if (!md.getRevision().equals(version)) continue;
                found = md;
            }
            if (found == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(found.getConfigurationsNames());
        }
        return Collections.emptyList();
    }

    private void filterCapabilityValues(Set<String> capabilityValues, Map<String, Set<ModuleDescriptor>> moduleByCapabilityValue, Map<String, String> tokenValues, String rev) {
        if (rev == null) {
            capabilityValues.addAll(moduleByCapabilityValue.keySet());
        } else {
            for (Map.Entry<String, Set<ModuleDescriptor>> entry : moduleByCapabilityValue.entrySet()) {
                ModuleDescriptor md;
                boolean moduleMatchRev = false;
                Iterator<ModuleDescriptor> iterator = entry.getValue().iterator();
                while (iterator.hasNext() && !(moduleMatchRev = rev.equals((md = iterator.next()).getRevision()))) {
                }
                if (!moduleMatchRev) continue;
                capabilityValues.add(entry.getKey());
            }
        }
    }

    @Override
    public Map<String, String>[] listTokenValues(String[] tokens, Map<String, Object> criteria) {
        HashSet<String> tokenSet = new HashSet<String>(Arrays.asList(tokens));
        Set<Map<String, String>> listTokenValues = this.listTokenValues(tokenSet, criteria);
        return listTokenValues.toArray(new Map[listTokenValues.size()]);
    }

    private Set<Map<String, String>> listTokenValues(Set<String> tokens, Map<String, Object> criteria) {
        HashMap<String, String> stringCriteria = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : criteria.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String)) {
                return Collections.emptySet();
            }
            stringCriteria.put(entry.getKey(), (String)value);
        }
        if (tokens.isEmpty()) {
            return Collections.singleton(stringCriteria);
        }
        HashSet<String> remainingTokens = new HashSet<String>(tokens);
        remainingTokens.remove("organisation");
        String osgiType = (String)stringCriteria.get("organisation");
        if (osgiType == null) {
            HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
            newCriteria.put("organisation", "bundle");
            HashSet<Map<String, String>> tokenValues = new HashSet<Map<String, String>>(this.listTokenValues(remainingTokens, newCriteria));
            newCriteria = new HashMap<String, Object>(criteria);
            newCriteria.put("organisation", "package");
            tokenValues.addAll(this.listTokenValues(remainingTokens, newCriteria));
            newCriteria = new HashMap<String, Object>(criteria);
            newCriteria.put("organisation", "service");
            tokenValues.addAll(this.listTokenValues(remainingTokens, newCriteria));
            return tokenValues;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("organisation", osgiType);
        Set<String> capabilities = this.getRepoDescriptor().getCapabilityValues(osgiType);
        if (capabilities == null || capabilities.isEmpty()) {
            return Collections.emptySet();
        }
        remainingTokens.remove("module");
        String module = (String)stringCriteria.get("module");
        if (module == null) {
            HashSet<Map<String, String>> tokenValues = new HashSet<Map<String, String>>();
            for (String name : capabilities) {
                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                newCriteria.put("module", name);
                tokenValues.addAll(this.listTokenValues(remainingTokens, newCriteria));
            }
            return tokenValues;
        }
        values.put("module", module);
        remainingTokens.remove("revision");
        String rev = (String)stringCriteria.get("revision");
        if (rev == null) {
            Set<ModuleDescriptorWrapper> mdws = this.getRepoDescriptor().findModules(osgiType, module);
            if (mdws == null || mdws.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<Map<String, String>> tokenValues = new HashSet<Map<String, String>>();
            for (ModuleDescriptorWrapper mdw : mdws) {
                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                newCriteria.put("revision", mdw.getBundleInfo().getVersion().toString());
                tokenValues.addAll(this.listTokenValues(remainingTokens, newCriteria));
            }
            return tokenValues;
        }
        values.put("revision", rev);
        remainingTokens.remove("conf");
        String conf = (String)stringCriteria.get("conf");
        if (conf == null) {
            if (osgiType.equals("package")) {
                values.put("conf", "use_" + module);
                return Collections.singleton(values);
            }
            Set<ModuleDescriptorWrapper> bundles = this.getRepoDescriptor().findModules(osgiType, module);
            if (bundles == null) {
                return Collections.emptySet();
            }
            Version v = new Version(rev);
            ModuleDescriptorWrapper found = null;
            for (ModuleDescriptorWrapper bundle : bundles) {
                if (!bundle.getBundleInfo().getVersion().equals(v)) continue;
                found = bundle;
            }
            if (found == null) {
                return Collections.emptySet();
            }
            HashSet<Map<String, String>> tokenValues = new HashSet<Map<String, String>>();
            List<String> configurations = BundleInfoAdapter.getConfigurations(found.getBundleInfo());
            for (String configuration : configurations) {
                HashMap<String, String> newCriteria = new HashMap<String, String>(stringCriteria);
                newCriteria.put("conf", configuration);
                tokenValues.add(newCriteria);
            }
            return tokenValues;
        }
        values.put("conf", conf);
        return Collections.singleton(values);
    }

    @Override
    protected long get(Resource resource, File dest) throws IOException {
        Message.verbose("\t" + this.getName() + ": downloading " + resource.getName());
        Message.debug("\t\tto " + dest);
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        this.getRepository().get(resource.getName(), dest);
        return dest.length();
    }

    @Override
    protected Resource getResource(String source) throws IOException {
        return this.getRepository().getResource(source);
    }

    @Override
    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static class RequirementStrategy {
        public static RequirementStrategy first = new RequirementStrategy();
        public static RequirementStrategy noambiguity = new RequirementStrategy();

        public static RequirementStrategy valueOf(String strategy) {
            if (strategy.equals("first")) {
                return first;
            }
            if (strategy.equals("noambiguity")) {
                return noambiguity;
            }
            throw new IllegalStateException();
        }
    }
}

