/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.gradle.internal.impldep.org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public abstract class AbstractFSManifestIterable<T>
implements Iterable<ManifestAndLocation> {
    private final T root;

    public AbstractFSManifestIterable(T root) {
        this.root = root;
    }

    @Override
    public Iterator<ManifestAndLocation> iterator() {
        return new FSManifestIterator();
    }

    protected abstract List<T> listBundleFiles(T var1) throws IOException;

    protected abstract List<T> listDirs(T var1) throws IOException;

    protected abstract InputStream getInputStream(T var1) throws IOException;

    protected abstract URI buildBundleURI(T var1) throws IOException;

    class FSManifestIterator
    implements Iterator<ManifestAndLocation> {
        private ManifestAndLocation next = null;
        private Stack<Iterator<T>> dirs = new Stack();
        private Iterator<T> bundleCandidates = null;
        private T currentDir = null;

        FSManifestIterator() {
            this.dirs.add(Collections.singleton(AbstractFSManifestIterable.this.root).iterator());
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (this.currentDir == null) {
                    if (this.dirs.peek().hasNext()) {
                        this.currentDir = this.dirs.peek().next();
                        try {
                            this.bundleCandidates = AbstractFSManifestIterable.this.listBundleFiles(this.currentDir).iterator();
                        }
                        catch (IOException e) {
                            Message.warn("Unlistable dir: " + this.currentDir, e);
                            this.currentDir = null;
                        }
                        continue;
                    }
                    if (this.dirs.size() <= 1) {
                        return false;
                    }
                    this.dirs.pop();
                    continue;
                }
                if (this.bundleCandidates.hasNext()) {
                    Object bundleCandidate = this.bundleCandidates.next();
                    try (JarInputStream in = new JarInputStream(AbstractFSManifestIterable.this.getInputStream(bundleCandidate));){
                        Manifest manifest = in.getManifest();
                        if (manifest != null) {
                            this.next = new ManifestAndLocation(manifest, AbstractFSManifestIterable.this.buildBundleURI(bundleCandidate), null);
                            continue;
                        }
                        Message.debug("No manifest in jar: " + bundleCandidate);
                    }
                    catch (FileNotFoundException e) {
                        Message.debug("Jar file just removed: " + bundleCandidate, e);
                    }
                    catch (IOException e) {
                        Message.warn("Unreadable jar: " + bundleCandidate, e);
                    }
                    continue;
                }
                try {
                    this.dirs.add(AbstractFSManifestIterable.this.listDirs(this.currentDir).iterator());
                }
                catch (IOException e) {
                    Message.warn("Unlistable dir: " + this.currentDir + " (" + e + ")");
                    this.dirs.add(Collections.emptyList().iterator());
                }
                this.currentDir = null;
            }
            return true;
        }

        @Override
        public ManifestAndLocation next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ManifestAndLocation manifest = this.next;
            this.next = null;
            return manifest;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

