/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.module.id;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.MatcherLookup;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleId;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.plugins.matcher.MapMatcher;
import org.gradle.internal.impldep.org.apache.ivy.util.Checks;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;
import org.gradle.internal.impldep.org.apache.ivy.util.filter.Filter;
import org.gradle.internal.impldep.org.apache.ivy.util.filter.NoFilter;

public class ModuleRules<T> {
    private Map<MapMatcher, T> rules = new LinkedHashMap<MapMatcher, T>();
    private MatcherLookup matcherLookup = new MatcherLookup();

    public ModuleRules() {
    }

    private ModuleRules(Map<MapMatcher, T> rules) {
        this.rules = new LinkedHashMap<MapMatcher, T>(rules);
        for (MapMatcher matcher : rules.keySet()) {
            this.matcherLookup.add(matcher);
        }
    }

    public void defineRule(MapMatcher condition, T rule) {
        Checks.checkNotNull(condition, "condition");
        Checks.checkNotNull(rule, "rule");
        this.rules.put(condition, rule);
        this.matcherLookup.add(condition);
    }

    public T getRule(ModuleId mid) {
        return this.getRule(mid, NoFilter.instance());
    }

    public List<T> getRules(ModuleId mid) {
        return this.getRules(mid.getAttributes(), NoFilter.instance());
    }

    public T getRule(ModuleRevisionId mrid) {
        return this.getRule(mrid, NoFilter.instance());
    }

    public T getRule(ModuleId mid, Filter<T> filter) {
        Checks.checkNotNull(mid, "mid");
        return this.getRule(mid.getAttributes(), filter);
    }

    public T getRule(ModuleRevisionId mrid, Filter<T> filter) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(filter, "filter");
        Map<String, String> moduleAttributes = mrid.getAttributes();
        return this.getRule(moduleAttributes, filter);
    }

    private T getRule(Map<String, String> moduleAttributes, Filter<T> filter) {
        for (MapMatcher midm : this.matcherLookup.get(moduleAttributes)) {
            T rule = this.rules.get(midm);
            if (!filter.accept(rule)) continue;
            return rule;
        }
        return null;
    }

    public List<T> getRules(ModuleRevisionId mrid, Filter<T> filter) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(filter, "filter");
        Map<String, String> moduleAttributes = mrid.getAttributes();
        return this.getRules(moduleAttributes, filter);
    }

    private List<T> getRules(Map<String, String> moduleAttributes, Filter<T> filter) {
        ArrayList<T> matchingRules = new ArrayList<T>();
        for (MapMatcher midm : this.matcherLookup.get(moduleAttributes)) {
            T rule = this.rules.get(midm);
            if (!filter.accept(rule)) continue;
            matchingRules.add(rule);
        }
        return matchingRules;
    }

    public void dump(String prefix) {
        if (this.rules.isEmpty()) {
            Message.debug(prefix + "NONE");
            return;
        }
        for (Map.Entry<MapMatcher, T> entry : this.rules.entrySet()) {
            MapMatcher midm = entry.getKey();
            T rule = entry.getValue();
            Message.debug(prefix + midm + " -> " + rule);
        }
    }

    public Map<MapMatcher, T> getAllRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    public ModuleRules<T> clone() {
        return new ModuleRules<T>(this.rules);
    }
}

