/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.google.api.client.http.apache.v2;

import java.io.IOException;
import org.gradle.internal.impldep.com.google.api.client.http.LowLevelHttpRequest;
import org.gradle.internal.impldep.com.google.api.client.http.LowLevelHttpResponse;
import org.gradle.internal.impldep.com.google.api.client.http.apache.v2.ApacheHttpResponse;
import org.gradle.internal.impldep.com.google.api.client.http.apache.v2.ContentEntity;
import org.gradle.internal.impldep.com.google.api.client.util.Preconditions;
import org.gradle.internal.impldep.org.apache.http.HttpEntityEnclosingRequest;
import org.gradle.internal.impldep.org.apache.http.client.HttpClient;
import org.gradle.internal.impldep.org.apache.http.client.config.RequestConfig;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpRequestBase;

final class ApacheHttpRequest
extends LowLevelHttpRequest {
    private final HttpClient httpClient;
    private final HttpRequestBase request;
    private RequestConfig.Builder requestConfig;

    ApacheHttpRequest(HttpClient httpClient, HttpRequestBase request) {
        this.httpClient = httpClient;
        this.request = request;
        this.requestConfig = RequestConfig.custom().setRedirectsEnabled(false).setNormalizeUri(false).setStaleConnectionCheckEnabled(false);
    }

    @Override
    public void addHeader(String name, String value) {
        this.request.addHeader(name, value);
    }

    @Override
    public void setTimeout(int connectTimeout, int readTimeout) throws IOException {
        this.requestConfig.setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout);
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        if (this.getStreamingContent() != null) {
            Preconditions.checkState(this.request instanceof HttpEntityEnclosingRequest, "Apache HTTP client does not support %s requests with content.", this.request.getRequestLine().getMethod());
            ContentEntity entity = new ContentEntity(this.getContentLength(), this.getStreamingContent());
            entity.setContentEncoding(this.getContentEncoding());
            entity.setContentType(this.getContentType());
            if (this.getContentLength() == -1L) {
                entity.setChunked(true);
            }
            ((HttpEntityEnclosingRequest)((Object)this.request)).setEntity(entity);
        }
        this.request.setConfig(this.requestConfig.build());
        return new ApacheHttpResponse(this.request, this.httpClient.execute(this.request));
    }
}

