/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.retry.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.impldep.com.amazonaws.retry.v2.RetryCondition;
import org.gradle.internal.impldep.com.amazonaws.retry.v2.RetryPolicyContext;
import org.gradle.internal.impldep.com.amazonaws.util.ValidationUtils;

public class RetryOnStatusCodeCondition
implements RetryCondition {
    private final List<Integer> statusCodesToRetryOn;

    public RetryOnStatusCodeCondition(List<Integer> statusCodesToRetryOn) {
        this.statusCodesToRetryOn = new ArrayList<Integer>((Collection)ValidationUtils.assertNotNull(statusCodesToRetryOn, "statusCodesToRetryOn"));
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        if (context.httpStatusCode() != null) {
            for (Integer statusCode : this.statusCodesToRetryOn) {
                if (!statusCode.equals(context.httpStatusCode())) continue;
                return true;
            }
        }
        return false;
    }
}

