/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandlerBase;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

final class GotoPropertyParentDeclarationHandler
extends GotoDeclarationHandlerBase {
    GotoPropertyParentDeclarationHandler() {
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@Nullable PsiElement sourceElement, Editor editor) {
        Property property = GotoPropertyParentDeclarationHandler.findProperty(sourceElement);
        if (property == null) {
            return null;
        }
        String key = property.getKey();
        if (key == null) {
            return null;
        }
        PropertiesFile currentFile = PropertiesImplUtil.getPropertiesFile(property.getContainingFile());
        if (currentFile == null) {
            return null;
        }
        while ((currentFile = PropertiesUtil.getParent(currentFile, currentFile.getResourceBundle().getPropertiesFiles())) != null) {
            IProperty parent = currentFile.findPropertyByKey(key);
            if (parent == null) continue;
            return parent.getPsiElement();
        }
        return null;
    }

    static Property findProperty(@Nullable PsiElement source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Property) {
            return (Property)source;
        }
        PsiElement parent = source.getParent();
        return parent instanceof Property ? (Property)parent : null;
    }
}

