/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.parsing.PropertiesLexer;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;

public class PropertiesHighlightingLexer
extends LayeredLexer {
    public PropertiesHighlightingLexer() {
        super((Lexer)new PropertiesLexer());
        this.registerSelfStoppingLayer((Lexer)new PropertiesStringLiteralLexer(PropertiesTokenTypes.VALUE_CHARACTERS), new IElementType[]{PropertiesTokenTypes.VALUE_CHARACTERS}, IElementType.EMPTY_ARRAY);
        this.registerSelfStoppingLayer((Lexer)new PropertiesStringLiteralLexer(PropertiesTokenTypes.KEY_CHARACTERS), new IElementType[]{PropertiesTokenTypes.KEY_CHARACTERS}, IElementType.EMPTY_ARRAY);
    }

    public static final class PropertiesStringLiteralLexer
    extends StringLiteralLexer {
        public PropertiesStringLiteralLexer(IElementType originalLiteralToken) {
            super('\uffff', originalLiteralToken, true, null);
        }

        public IElementType getTokenType() {
            IElementType tokenType = super.getTokenType();
            if (tokenType != StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) {
                return tokenType;
            }
            if (this.myStart + 1 >= this.myBuffer.length()) {
                return tokenType;
            }
            char nextChar = this.myBuffer.charAt(this.myStart + 1);
            if (nextChar != 'u') {
                return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            }
            return tokenType;
        }
    }
}

