/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BundleNameEvaluator {
    public static final BundleNameEvaluator DEFAULT = new BundleNameEvaluator(){

        @Override
        @Nullable
        public String evaluateBundleName(PsiFile psiFile) {
            PsiDirectory directory = (PsiDirectory)ReadAction.compute(() -> psiFile.getParent());
            if (directory == null) {
                return null;
            }
            String packageQualifiedName = PropertiesUtil.getPackageQualifiedName(directory);
            if (packageQualifiedName == null) {
                return null;
            }
            StringBuilder qName = new StringBuilder(packageQualifiedName);
            if (qName.length() > 0) {
                qName.append(".");
            }
            qName.append(ResourceBundleManager.getInstance(psiFile.getProject()).getBaseName(psiFile));
            return qName.toString();
        }
    };
    public static final BundleNameEvaluator BASE_NAME = new BundleNameEvaluator(){

        @Override
        @NotNull
        public String evaluateBundleName(PsiFile psiFile) {
            String string = ResourceBundleManager.getInstance(psiFile.getProject()).getBaseName(psiFile);
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/BundleNameEvaluator$2", "evaluateBundleName"));
        }
    };

    @Nullable
    public String evaluateBundleName(PsiFile var1);
}

