/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchDataImpl;
import com.intellij.vcs.branch.BranchStateProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.repo.HgRepository;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/zmlx/hg4idea/branch/HgBranchStateProvider;", "Lcom/intellij/vcs/branch/BranchStateProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCurrentBranch", "Lcom/intellij/vcs/branch/BranchData;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.vcs.hg"})
@SourceDebugExtension(value={"SMAP\nHgBranchStateProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HgBranchStateProvider.kt\norg/zmlx/hg4idea/branch/HgBranchStateProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,23:1\n1#2:24\n*E\n"})
public final class HgBranchStateProvider
implements BranchStateProvider {
    @NotNull
    private final Project project;

    public HgBranchStateProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public BranchData getCurrentBranch(@NotNull FilePath path) {
        BranchDataImpl branchDataImpl;
        HgRepository repository;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!ProjectLevelVcsManager.getInstance((Project)this.project).checkVcsIsActive("hg4idea")) {
            return null;
        }
        Repository repository2 = VcsRepositoryManager.getInstance((Project)this.project).getRepositoryForFile(path, true);
        HgRepository hgRepository = repository = repository2 instanceof HgRepository ? (HgRepository)repository2 : null;
        if (hgRepository != null) {
            HgRepository it = hgRepository;
            boolean bl = false;
            String string = it.getRoot().getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            branchDataImpl = new BranchDataImpl(string, it.getCurrentBranchName());
        } else {
            branchDataImpl = null;
        }
        return (BranchData)branchDataImpl;
    }
}

