/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.ScorerDocQueue;

class DisjunctionSumScorer
extends Scorer {
    private final int nrScorers;
    protected final List subScorers;
    private final int minimumNrMatchers;
    private ScorerDocQueue scorerDocQueue = null;
    private int queueSize = -1;
    private int currentDoc = -1;
    protected int nrMatchers = -1;
    private float currentScore = Float.NaN;

    public DisjunctionSumScorer(List subScorers, int minimumNrMatchers) {
        super(null);
        this.nrScorers = subScorers.size();
        if (minimumNrMatchers <= 0) {
            throw new IllegalArgumentException("Minimum nr of matchers must be positive");
        }
        if (this.nrScorers <= 1) {
            throw new IllegalArgumentException("There must be at least 2 subScorers");
        }
        this.minimumNrMatchers = minimumNrMatchers;
        this.subScorers = subScorers;
    }

    public DisjunctionSumScorer(List subScorers) {
        this(subScorers, 1);
    }

    private void initScorerDocQueue() throws IOException {
        Iterator si = this.subScorers.iterator();
        this.scorerDocQueue = new ScorerDocQueue(this.nrScorers);
        this.queueSize = 0;
        while (si.hasNext()) {
            Scorer se = (Scorer)si.next();
            if (!se.next() || !this.scorerDocQueue.insert(se)) continue;
            ++this.queueSize;
        }
    }

    public void score(HitCollector hc) throws IOException {
        while (this.next()) {
            hc.collect(this.currentDoc, this.currentScore);
        }
    }

    protected boolean score(HitCollector hc, int max) throws IOException {
        while (this.currentDoc < max) {
            hc.collect(this.currentDoc, this.currentScore);
            if (this.next()) continue;
            return false;
        }
        return true;
    }

    public boolean next() throws IOException {
        if (this.scorerDocQueue == null) {
            this.initScorerDocQueue();
        }
        return this.scorerDocQueue.size() >= this.minimumNrMatchers && this.advanceAfterCurrent();
    }

    protected boolean advanceAfterCurrent() throws IOException {
        do {
            this.currentDoc = this.scorerDocQueue.topDoc();
            this.currentScore = this.scorerDocQueue.topScore();
            this.nrMatchers = 1;
            while ((this.scorerDocQueue.topNextAndAdjustElsePop() || --this.queueSize != 0) && this.scorerDocQueue.topDoc() == this.currentDoc) {
                this.currentScore += this.scorerDocQueue.topScore();
                ++this.nrMatchers;
            }
            if (this.nrMatchers < this.minimumNrMatchers) continue;
            return true;
        } while (this.queueSize >= this.minimumNrMatchers);
        return false;
    }

    public float score() throws IOException {
        return this.currentScore;
    }

    public int doc() {
        return this.currentDoc;
    }

    public int nrMatchers() {
        return this.nrMatchers;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.scorerDocQueue == null) {
            this.initScorerDocQueue();
        }
        if (this.queueSize < this.minimumNrMatchers) {
            return false;
        }
        if (target <= this.currentDoc) {
            return true;
        }
        do {
            if (this.scorerDocQueue.topDoc() < target) continue;
            return this.advanceAfterCurrent();
        } while (this.scorerDocQueue.topSkipToAndAdjustElsePop(target) || --this.queueSize >= this.minimumNrMatchers);
        return false;
    }

    public Explanation explain(int doc) throws IOException {
        Explanation res = new Explanation();
        Iterator ssi = this.subScorers.iterator();
        float sumScore = 0.0f;
        int nrMatches = 0;
        while (ssi.hasNext()) {
            Explanation es = ((Scorer)ssi.next()).explain(doc);
            if (es.getValue() > 0.0f) {
                sumScore += es.getValue();
                ++nrMatches;
            }
            res.addDetail(es);
        }
        if (this.nrMatchers >= this.minimumNrMatchers) {
            res.setValue(sumScore);
            res.setDescription("sum over at least " + this.minimumNrMatchers + " of " + this.subScorers.size() + ":");
        } else {
            res.setValue(0.0f);
            res.setDescription(nrMatches + " match(es) but at least " + this.minimumNrMatchers + " of " + this.subScorers.size() + " needed");
        }
        return res;
    }
}

