/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.cache.GradleLocalCacheHelper;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.service.task.LazyVersionSpecificInitScript;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleLog;

final class GradleAttachSourcesProvider
implements AttachSourcesProvider {
    private static final GradleVersion GRADLE_5_6 = GradleVersion.version((String)"5.6");
    private static final String ANDROID_LIBRARY_SUFFIX = "@aar";
    private static final String INIT_SCRIPT_FILE_PREFIX = "ijDownloadSources";

    GradleAttachSourcesProvider() {
    }

    @NotNull
    public Collection<? extends AttachSourcesProvider.AttachSourcesAction> getActions(@NotNull List<? extends LibraryOrderEntry> orderEntries, @NotNull PsiFile psiFile) {
        Map<LibraryOrderEntry, Module> gradleModules;
        if (orderEntries == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(1);
        }
        if ((gradleModules = GradleAttachSourcesProvider.getGradleModules(orderEntries)).isEmpty()) {
            List list = List.of();
            if (list == null) {
                GradleAttachSourcesProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<GradleDownloadSourceAction> list = List.of(new GradleDownloadSourceAction(orderEntries, psiFile));
        if (list == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    static String getSourcesArtifactNotation(@NotNull String artifactCoordinates, @NotNull Predicate<String> artifactIdChecker) {
        boolean isArtifactId;
        String[] split;
        if (artifactCoordinates == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(4);
        }
        if (artifactIdChecker == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(5);
        }
        Object groupNameVersionCoordinates = (split = artifactCoordinates.split(":")).length == 4 ? ((isArtifactId = artifactIdChecker.test(split[1])) ? split[0] + ":" + split[1] + ":" + split[3] : artifactCoordinates) : (split.length == 5 ? split[0] + ":" + split[1] + ":" + split[4] : artifactCoordinates);
        String string = StringUtil.trimEnd((String)groupNameVersionCoordinates, (String)ANDROID_LIBRARY_SUFFIX) + ":sources";
        if (string == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static UserDataHolderBase prepareUserData(@NotNull String sourceArtifactNotation, @NotNull String taskName, @NotNull String sourcesLocationFilePath) {
        if (sourceArtifactNotation == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(7);
        }
        if (taskName == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(8);
        }
        if (sourcesLocationFilePath == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(9);
        }
        UserDataHolderBase userData = new UserDataHolderBase();
        LazyVersionSpecificInitScript legacyInitScript = new LazyVersionSpecificInitScript(() -> GradleInitScriptUtil.loadLegacyDownloadSourcesInitScript((String)sourceArtifactNotation, (String)taskName, (String)sourcesLocationFilePath), INIT_SCRIPT_FILE_PREFIX, version -> GRADLE_5_6.compareTo(version) > 0);
        LazyVersionSpecificInitScript initScript = new LazyVersionSpecificInitScript(() -> GradleInitScriptUtil.loadDownloadSourcesInitScript((String)sourceArtifactNotation, (String)taskName, (String)sourcesLocationFilePath), INIT_SCRIPT_FILE_PREFIX, version -> GRADLE_5_6.compareTo(version) <= 0);
        userData.putUserData(GradleTaskManager.VERSION_SPECIFIC_SCRIPTS_KEY, List.of(legacyInitScript, initScript));
        UserDataHolderBase userDataHolderBase = userData;
        if (userDataHolderBase == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(10);
        }
        return userDataHolderBase;
    }

    @NotNull
    private static Map<LibraryOrderEntry, Module> getGradleModules(@NotNull List<? extends LibraryOrderEntry> libraryOrderEntries) {
        if (libraryOrderEntries == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(11);
        }
        HashMap<LibraryOrderEntry, Module> result = new HashMap<LibraryOrderEntry, Module>();
        for (LibraryOrderEntry libraryOrderEntry : libraryOrderEntries) {
            Module module2;
            if (libraryOrderEntry.isModuleLevel() || !ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)(module2 = libraryOrderEntry.getOwnerModule()))) continue;
            result.put(libraryOrderEntry, module2);
        }
        HashMap<LibraryOrderEntry, Module> hashMap = result;
        if (hashMap == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidJar(@NotNull Path path) {
        if (path == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(13);
        }
        try (InputStream is = Files.newInputStream(path, StandardOpenOption.READ, LinkOption.NOFOLLOW_LINKS);){
            byte[] head = is.readNBytes(2);
            if (head.length < 2) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = head[0] == 80 && head[1] == 75;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Nullable
    private static UnifiedCoordinates getLibraryUnifiedCoordinates(@NotNull String sourceArtifactNotation) {
        String notation;
        String[] particles;
        if (sourceArtifactNotation == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(14);
        }
        if ((particles = (notation = sourceArtifactNotation.replace(ANDROID_LIBRARY_SUFFIX, "")).split(":")).length < 3) {
            return null;
        }
        return new UnifiedCoordinates(particles[0], particles[1], particles[2]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/util/GradleAttachSourcesProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactCoordinates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactIdChecker";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceArtifactNotation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcesLocationFilePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryOrderEntries";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/util/GradleAttachSourcesProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesArtifactNotation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareUserData";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSourcesArtifactNotation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareUserData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getGradleModules";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidJar";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryUnifiedCoordinates";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 10, 12 -> new IllegalStateException(string);
        };
    }

    private static class GradleDownloadSourceAction
    implements AttachSourcesProvider.AttachSourcesAction {
        @NotNull
        private final List<? extends LibraryOrderEntry> orderEntries;
        @NotNull
        private final PsiFile psiFile;

        private GradleDownloadSourceAction(@NotNull List<? extends LibraryOrderEntry> orderEntries, @NotNull PsiFile psiFile) {
            if (orderEntries == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(0);
            }
            if (psiFile == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(1);
            }
            this.orderEntries = orderEntries;
            this.psiFile = psiFile;
        }

        public String getName() {
            return GradleBundle.message((String)"gradle.action.download.sources", (Object[])new Object[0]);
        }

        public String getBusyText() {
            return GradleBundle.message((String)"gradle.action.download.sources.busy.text", (Object[])new Object[0]);
        }

        @NotNull
        public ActionCallback perform(@NotNull List<? extends LibraryOrderEntry> orderEntriesContainingFile) {
            Map<LibraryOrderEntry, Module> gradleModules;
            if (orderEntriesContainingFile == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(2);
            }
            if ((gradleModules = GradleAttachSourcesProvider.getGradleModules(this.orderEntries)).isEmpty()) {
                ActionCallback actionCallback = ActionCallback.REJECTED;
                if (actionCallback == null) {
                    GradleDownloadSourceAction.$$$reportNull$$$0(3);
                }
                return actionCallback;
            }
            Map.Entry<LibraryOrderEntry, Module> next = gradleModules.entrySet().iterator().next();
            Module module2 = next.getValue();
            if (CachedModuleDataFinder.getGradleModuleData((Module)module2) == null) {
                ActionCallback actionCallback = ActionCallback.REJECTED;
                if (actionCallback == null) {
                    GradleDownloadSourceAction.$$$reportNull$$$0(4);
                }
                return actionCallback;
            }
            LibraryOrderEntry libraryOrderEntry = next.getKey();
            String libraryName = libraryOrderEntry.getLibraryName();
            if (libraryName == null) {
                ActionCallback actionCallback = ActionCallback.REJECTED;
                if (actionCallback == null) {
                    GradleDownloadSourceAction.$$$reportNull$$$0(5);
                }
                return actionCallback;
            }
            String artifactCoordinates = StringUtil.trimStart((String)libraryName, (String)(GradleConstants.SYSTEM_ID.getReadableName() + ": "));
            if (StringUtil.equals((CharSequence)libraryName, (CharSequence)artifactCoordinates)) {
                ActionCallback actionCallback = ActionCallback.REJECTED;
                if (actionCallback == null) {
                    GradleDownloadSourceAction.$$$reportNull$$$0(6);
                }
                return actionCallback;
            }
            String externalProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
            if (externalProjectPath == null) {
                ActionCallback actionCallback = ActionCallback.REJECTED;
                if (actionCallback == null) {
                    GradleDownloadSourceAction.$$$reportNull$$$0(7);
                }
                return actionCallback;
            }
            String sourceArtifactNotation = GradleAttachSourcesProvider.getSourcesArtifactNotation(artifactCoordinates, artifactIdCandidate -> {
                Object[] rootFiles = libraryOrderEntry.getRootFiles(OrderRootType.CLASSES);
                return rootFiles.length == 0 || ContainerUtil.exists((Object[])rootFiles, file -> file.getName().startsWith((String)artifactIdCandidate));
            });
            Path cachedSourcesPath = GradleDownloadSourceAction.lookupSourcesPathFromCache(libraryOrderEntry, sourceArtifactNotation, this.psiFile.getProject(), externalProjectPath);
            if (cachedSourcesPath != null && GradleAttachSourcesProvider.isValidJar(cachedSourcesPath)) {
                GradleDownloadSourceAction.attachSources(cachedSourcesPath.toFile(), this.orderEntries);
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    GradleDownloadSourceAction.$$$reportNull$$$0(8);
                }
                return actionCallback;
            }
            return this.downloadSources(this.psiFile, sourceArtifactNotation, artifactCoordinates, externalProjectPath);
        }

        @Nullable
        private static Path lookupSourcesPathFromCache(@NotNull LibraryOrderEntry libraryOrderEntry, @NotNull String sourceArtifactNotation, @NotNull Project project, @Nullable String projectPath) {
            VirtualFile[] rootFiles;
            if (libraryOrderEntry == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(9);
            }
            if (sourceArtifactNotation == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(10);
            }
            if (project == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(11);
            }
            if ((rootFiles = libraryOrderEntry.getRootFiles(OrderRootType.CLASSES)).length == 0) {
                return null;
            }
            BuildLayoutParameters buildLayoutParameters = GradleInstallationManager.getInstance().guessBuildLayoutParameters(project, projectPath);
            String gradleUserHome = (String)GradleTargetUtil.maybeGetLocalValue((TargetValue)buildLayoutParameters.getGradleUserHome());
            if (gradleUserHome == null) {
                return null;
            }
            if (!FileUtil.isAncestor((String)gradleUserHome, (String)rootFiles[0].getPath(), (boolean)false)) {
                return null;
            }
            UnifiedCoordinates coordinates = GradleAttachSourcesProvider.getLibraryUnifiedCoordinates(sourceArtifactNotation);
            if (coordinates == null) {
                return null;
            }
            Map localArtifacts = GradleLocalCacheHelper.findArtifactComponents((UnifiedCoordinates)coordinates, (Path)Path.of(gradleUserHome, new String[0]), EnumSet.of(LibraryPathType.SOURCE));
            List sources = (List)localArtifacts.get(LibraryPathType.SOURCE);
            if (sources == null || sources.isEmpty()) {
                return null;
            }
            return (Path)sources.iterator().next();
        }

        @NotNull
        private ActionCallback downloadSources(@NotNull PsiFile psiFile, @NotNull String sourceArtifactNotation, final @NotNull String artifactCoordinates, @NotNull String externalProjectPath) {
            String sourcesLocationFilePath;
            File sourcesLocationFile;
            if (psiFile == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(12);
            }
            if (sourceArtifactNotation == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(13);
            }
            if (artifactCoordinates == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(14);
            }
            if (externalProjectPath == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(15);
            }
            try {
                sourcesLocationFile = new File(FileUtil.createTempDirectory((String)"sources", (String)"loc"), "path.tmp");
                sourcesLocationFilePath = StringUtil.escapeBackSlashes((String)sourcesLocationFile.getCanonicalPath());
                Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtil.delete((File)sourcesLocationFile), "GradleAttachSourcesProvider cleanup"));
            }
            catch (IOException e) {
                GradleLog.LOG.warn((Throwable)e);
                ActionCallback actionCallback = ActionCallback.REJECTED;
                if (actionCallback == null) {
                    GradleDownloadSourceAction.$$$reportNull$$$0(16);
                }
                return actionCallback;
            }
            final Project project = psiFile.getProject();
            String taskName = GradleAttachSourcesProvider.INIT_SCRIPT_FILE_PREFIX + UUID.randomUUID().toString().substring(0, 12);
            ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
            settings.setExecutionName(this.getName());
            settings.setExternalProjectPath(externalProjectPath);
            settings.setTaskNames(List.of(taskName));
            settings.setVmOptions(GradleSettings.getInstance((Project)project).getGradleVmOptions());
            settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
            UserDataHolderBase userData = GradleAttachSourcesProvider.prepareUserData(sourceArtifactNotation, taskName, sourcesLocationFilePath);
            final ActionCallback resultWrapper = new ActionCallback();
            ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)"Run", (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)new TaskCallback(){

                public void onSuccess() {
                    File sourceJar;
                    try {
                        Path downloadedArtifactPath = Path.of(FileUtil.loadFile((File)sourcesLocationFile), new String[0]);
                        if (!GradleAttachSourcesProvider.isValidJar(downloadedArtifactPath)) {
                            GradleLog.LOG.warn("Incorrect file header: " + downloadedArtifactPath + ". Unable to process downloaded file as a JAR file");
                            FileUtil.delete((File)sourcesLocationFile);
                            resultWrapper.setRejected();
                            return;
                        }
                        sourceJar = downloadedArtifactPath.toFile();
                        FileUtil.delete((File)sourcesLocationFile);
                    }
                    catch (IOException e) {
                        GradleLog.LOG.warn((Throwable)e);
                        resultWrapper.setRejected();
                        return;
                    }
                    GradleDownloadSourceAction.attachSources(sourceJar, orderEntries);
                    resultWrapper.setDone();
                }

                public void onFailure() {
                    resultWrapper.setRejected();
                    String title = GradleBundle.message((String)"gradle.notifications.sources.download.failed.title", (Object[])new Object[0]);
                    String message = GradleBundle.message((String)"gradle.notifications.sources.download.failed.content", (Object[])new Object[]{artifactCoordinates});
                    NotificationData notification = new NotificationData(title, message, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
                    notification.setBalloonNotification(true);
                    ExternalSystemNotificationManager.getInstance((Project)project).showNotification(GradleConstants.SYSTEM_ID, notification);
                }
            }, (ProgressExecutionMode)ProgressExecutionMode.NO_PROGRESS_ASYNC, (boolean)false, (UserDataHolderBase)userData);
            ActionCallback actionCallback = resultWrapper;
            if (actionCallback == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(17);
            }
            return actionCallback;
        }

        private static void attachSources(@NotNull File sourcesJar, @NotNull List<? extends LibraryOrderEntry> orderEntries) {
            if (sourcesJar == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(18);
            }
            if (orderEntries == null) {
                GradleDownloadSourceAction.$$$reportNull$$$0(19);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                HashSet libraries = new HashSet();
                for (LibraryOrderEntry orderEntry : orderEntries) {
                    ContainerUtil.addIfNotNull(libraries, (Object)orderEntry.getLibrary());
                }
                InternetAttachSourceProvider.attachSourceJar((File)sourcesJar, libraries);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7, 8, 16, 17 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderEntries";
                    break;
                }
                case 1: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderEntriesContainingFile";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/util/GradleAttachSourcesProvider$GradleDownloadSourceAction";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryOrderEntry";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceArtifactNotation";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactCoordinates";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalProjectPath";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcesJar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/util/GradleAttachSourcesProvider$GradleDownloadSourceAction";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "downloadSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: 
                case 17: {
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lookupSourcesPathFromCache";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadSources";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "attachSources";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7, 8, 16, 17 -> new IllegalStateException(string);
            };
        }
    }
}

