/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import icons.GradleIcons;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.GradlePluginDescriptionsExtension;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginActionHandler;
import org.jetbrains.plugins.gradle.codeInsight.actions.PluginDescriptor;
import org.jetbrains.plugins.gradle.config.GradleFileType;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class AddGradleDslPluginAction
extends CodeInsightAction {
    public static final String ID = "AddGradleDslPluginAction";
    static final ThreadLocal<String> TEST_THREAD_LOCAL = new ThreadLocal();
    private final List<PluginDescriptor> myPlugins;

    public AddGradleDslPluginAction() {
        this.getTemplatePresentation().setDescription(GradleBundle.messagePointer((String)"gradle.codeInsight.action.apply_plugin.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setText(GradleBundle.messagePointer((String)"gradle.codeInsight.action.apply_plugin.text", (Object[])new Object[0]));
        this.getTemplatePresentation().setIcon(GradleIcons.Gradle);
        this.myPlugins = new ArrayList<PluginDescriptor>();
        for (GradlePluginDescriptionsExtension extension : (GradlePluginDescriptionsExtension[])GradlePluginDescriptionsExtension.EP_NAME.getExtensions()) {
            for (Map.Entry<String, String> pluginDescription : extension.getPluginDescriptions().entrySet()) {
                this.myPlugins.add(new PluginDescriptor(pluginDescription.getKey(), pluginDescription.getValue()));
            }
        }
        this.myPlugins.sort(Comparator.comparing(p -> p.name()));
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new AddGradleDslPluginActionHandler(this.myPlugins);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            AddGradleDslPluginAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AddGradleDslPluginAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            AddGradleDslPluginAction.$$$reportNull$$$0(2);
        }
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        if (!GradleFileType.isGradleFile(file)) {
            return false;
        }
        return !"settings.gradle".equals(file.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginAction";
        objectArray[2] = "isValidForFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

