/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.IDEACoverageRunner;
import com.intellij.coverage.JaCoCoCoverageRunner;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCoverageSuite
extends BaseCoverageSuite {
    @NonNls
    private static final String FILTER = "FILTER";
    @NonNls
    private static final String EXCLUDED_FILTER = "EXCLUDED_FILTER";
    @NonNls
    private static final String COVERAGE_RUNNER = "RUNNER";
    private final CoverageEngine myCoverageEngine;
    private String @Nullable [] myIncludeFilters;
    private String @Nullable [] myExcludePatterns;
    private boolean mySkipUnloadedClassesAnalysis;

    public JavaCoverageSuite(@NotNull CoverageEngine coverageEngine) {
        if (coverageEngine == null) {
            JavaCoverageSuite.$$$reportNull$$$0(0);
        }
        this.myCoverageEngine = coverageEngine;
    }

    /*
     * WARNING - void declaration
     */
    public JavaCoverageSuite(String name, CoverageFileProvider coverageDataFileProvider, String @Nullable [] includeFilters, String @Nullable [] excludePatterns, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, CoverageRunner coverageRunner, @NotNull CoverageEngine coverageEngine, Project project) {
        void project2;
        if (coverageEngine == null) {
            JavaCoverageSuite.$$$reportNull$$$0(1);
        }
        super(name, coverageDataFileProvider, lastCoverageTimeStamp, coverageByTestEnabled, branchCoverage, trackTestFolders, coverageRunner != null ? coverageRunner : CoverageRunner.getInstance(IDEACoverageRunner.class), (Project)project2);
        this.myCoverageEngine = coverageEngine;
        this.myIncludeFilters = includeFilters;
        this.myExcludePatterns = excludePatterns;
        if (coverageRunner instanceof JaCoCoCoverageRunner) {
            this.setSkipUnloadedClassesAnalysis(true);
        }
    }

    public final String @NotNull [] getFilteredPackageNames() {
        String[] stringArray = JavaCoverageSuite.getPackageNames(this.myIncludeFilters);
        if (stringArray == null) {
            JavaCoverageSuite.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    public final String @NotNull [] getExcludedPackageNames() {
        String[] stringArray = JavaCoverageSuite.getPackageNames(this.myExcludePatterns);
        if (stringArray == null) {
            JavaCoverageSuite.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    final String @Nullable [] getIncludeFilters() {
        return this.myIncludeFilters;
    }

    final void setIncludeFilters(String @Nullable [] filters) {
        this.myIncludeFilters = filters;
    }

    final String @Nullable [] getExcludePatterns() {
        return this.myExcludePatterns;
    }

    final void setExcludePatterns(String @Nullable [] patterns) {
        this.myExcludePatterns = patterns;
    }

    public boolean isSkipUnloadedClassesAnalysis() {
        return this.mySkipUnloadedClassesAnalysis;
    }

    public void setSkipUnloadedClassesAnalysis(boolean skipUnloadedClassesAnalysis) {
        this.mySkipUnloadedClassesAnalysis = skipUnloadedClassesAnalysis;
    }

    private static String[] getPackageNames(String[] filters) {
        if (filters == null || filters.length == 0) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String filter : filters) {
            if (filter.equals("*")) {
                result.add("");
                continue;
            }
            if (!filter.endsWith(".*")) continue;
            result.add(filter.substring(0, filter.length() - 2));
        }
        return ArrayUtilRt.toStringArray(result);
    }

    public final String @NotNull [] getFilteredClassNames() {
        return JavaCoverageSuite.getClassNames(this.myIncludeFilters);
    }

    public final String @NotNull [] getExcludedClassNames() {
        return JavaCoverageSuite.getClassNames(this.myExcludePatterns);
    }

    private static String @NotNull [] getClassNames(String[] filters) {
        if (filters == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                JavaCoverageSuite.$$$reportNull$$$0(4);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String filter : filters) {
            if (filter.equals("*") || filter.endsWith(".*")) continue;
            result.add(filter);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            JavaCoverageSuite.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    public final void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myIncludeFilters = JavaCoverageSuite.readFilters(element, FILTER);
        this.myExcludePatterns = JavaCoverageSuite.readFilters(element, EXCLUDED_FILTER);
        if (this.getRunner() == null) {
            this.setRunner(CoverageRunner.getInstance(IDEACoverageRunner.class));
        }
    }

    private static String[] readFilters(Element element, String tagName) {
        List children = element.getChildren(tagName);
        ArrayList<String> filters = new ArrayList<String>();
        for (Element child : children) {
            filters.add(child.getValue());
        }
        return filters.isEmpty() ? null : ArrayUtilRt.toStringArray(filters);
    }

    public final void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JavaCoverageSuite.writeFilters(element, this.myIncludeFilters, FILTER);
        JavaCoverageSuite.writeFilters(element, this.myExcludePatterns, EXCLUDED_FILTER);
        CoverageRunner coverageRunner = this.getRunner();
        if (coverageRunner != null) {
            element.setAttribute(COVERAGE_RUNNER, coverageRunner.getId());
        }
    }

    private static void writeFilters(Element element, String[] filters, String tagName) {
        if (filters != null) {
            for (String filter : filters) {
                Element filterElement = new Element(tagName);
                filterElement.setText(filter);
                element.addContent(filterElement);
            }
        }
    }

    @NotNull
    public final CoverageEngine getCoverageEngine() {
        CoverageEngine coverageEngine = this.myCoverageEngine;
        if (coverageEngine == null) {
            JavaCoverageSuite.$$$reportNull$$$0(6);
        }
        return coverageEngine;
    }

    public final boolean isClassFiltered(String classFQName) {
        return JavaCoverageSuite.isClassFiltered(classFQName, this.getFilteredClassNames());
    }

    public static boolean isClassFiltered(String classFQName, String[] classPatterns) {
        for (String className2 : classPatterns) {
            if (!className2.equals(classFQName) && (!classFQName.startsWith(className2) || classFQName.charAt(className2.length()) != '$')) continue;
            return true;
        }
        return false;
    }

    public final boolean isPackageFiltered(String packageFQName) {
        String[] filteredPackageNames;
        for (String name : this.getExcludedPackageNames()) {
            if (!packageFQName.equals(name) && !packageFQName.startsWith(name + ".")) continue;
            return false;
        }
        for (String packName : filteredPackageNames = this.getFilteredPackageNames()) {
            if (!packName.isEmpty() && !PsiNameHelper.isSubpackageOf((String)packageFQName, (String)packName)) continue;
            return true;
        }
        return filteredPackageNames.length == 0 && this.getFilteredClassNames().length == 0;
    }

    @NotNull
    public final List<PsiPackage> getCurrentSuitePackages(Project project) {
        List list = (List)ReadAction.compute(() -> {
            ArrayList<PsiPackage> packages = new ArrayList<PsiPackage>();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            String[] filters = this.getFilteredPackageNames();
            if (filters.length == 0) {
                if (this.getFilteredClassNames().length > 0) {
                    return Collections.emptyList();
                }
                PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage("");
                if (defaultPackage != null) {
                    packages.add(defaultPackage);
                }
            } else {
                ArrayList<String> nonInherited = new ArrayList<String>();
                for (String filter : filters) {
                    if (JavaCoverageSuite.isSubPackage(filters, filter)) continue;
                    nonInherited.add(filter);
                }
                for (String filter : nonInherited) {
                    PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(filter);
                    if (psiPackage == null) continue;
                    packages.add(psiPackage);
                }
            }
            return packages;
        });
        if (list == null) {
            JavaCoverageSuite.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static boolean isSubPackage(String[] filters, String filter) {
        for (String supPackageFilter : filters) {
            if (!filter.startsWith(supPackageFilter + ".")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<PsiClass> getCurrentSuiteClasses(Project project) {
        ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>();
        String[] classNames = this.getFilteredClassNames();
        if (classNames.length > 0) {
            DumbService dumbService = DumbService.getInstance((Project)project);
            for (String className2 : classNames) {
                ThrowableComputable computable = () -> {
                    Module module;
                    GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
                    RunConfigurationBase configuration = this.getConfiguration();
                    if (configuration instanceof ModuleBasedConfiguration && (module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule()) != null) {
                        searchScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)this.isTrackTestFolders());
                    }
                    return JavaPsiFacade.getInstance((Project)project).findClass(className2.replace("$", "."), searchScope);
                };
                PsiClass aClass = (PsiClass)ReadAction.compute(() -> (PsiClass)dumbService.computeWithAlternativeResolveEnabled(computable));
                if (aClass == null) continue;
                classes2.add(aClass);
            }
        }
        ArrayList<PsiClass> arrayList = classes2;
        if (arrayList == null) {
            JavaCoverageSuite.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageEngine";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/JavaCoverageSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/JavaCoverageSuite";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredPackageNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPackageNames";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageEngine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSuitePackages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSuiteClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

