/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import icons.ExternalSystemIcons;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.navigator.structure.GroupNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.ProjectNode;
import org.jetbrains.idea.maven.navigator.structure.RunConfigurationNode;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;

class RunConfigurationsNode
extends GroupNode {
    private final List<RunConfigurationNode> myChildren = new CopyOnWriteArrayList<RunConfigurationNode>();

    RunConfigurationsNode(MavenProjectsStructure structure, ProjectNode parent) {
        super(structure, parent);
        this.getTemplatePresentation().setIcon(ExternalSystemIcons.Task);
    }

    public String getName() {
        return MavenProjectBundle.message("view.node.run.configurations", new Object[0]);
    }

    @Override
    protected List<? extends MavenSimpleNode> doGetChildren() {
        return this.myChildren;
    }

    public void updateRunConfigurations(MavenProject mavenProject2) {
        Ref childChanged = new Ref((Object)false);
        HashSet settings = new HashSet(RunManager.getInstance((Project)this.myProject).getConfigurationSettingsList((ConfigurationType)MavenRunConfigurationType.getInstance()));
        this.myChildren.forEach(node2 -> {
            if (settings.remove(node2.getSettings())) {
                node2.updateRunConfiguration();
            } else {
                this.myChildren.remove(node2);
                childChanged.set((Object)true);
            }
        });
        int oldSize = this.myChildren.size();
        for (RunnerAndConfigurationSettings cfg : settings) {
            MavenRunConfiguration mavenRunConfiguration = (MavenRunConfiguration)cfg.getConfiguration();
            if (!VfsUtilCore.pathEqualsTo((VirtualFile)mavenProject2.getDirectoryFile(), (String)mavenRunConfiguration.getRunnerParameters().getWorkingDirPath())) continue;
            this.myChildren.add(new RunConfigurationNode(this.myMavenProjectsStructure, this, cfg));
        }
        if (oldSize != this.myChildren.size()) {
            childChanged.set((Object)true);
            this.sort(this.myChildren);
        }
        if (((Boolean)childChanged.get()).booleanValue()) {
            this.childrenChanged();
        }
    }
}

