/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.indices.MavenArtifactSearcher;
import org.jetbrains.idea.maven.indices.MavenClassSearchResult;
import org.jetbrains.idea.maven.indices.MavenClassSearcher;
import org.jetbrains.idea.maven.indices.MavenRepositoriesConfigurable;
import org.jetbrains.idea.maven.indices.MavenSearcher;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenArtifactSearchPanel
extends JPanel {
    private static final int MAX_RESULT = 1000;
    private final Project myProject;
    private final MavenArtifactSearchDialog myDialog;
    private final boolean myClassMode;
    private final Listener myListener;
    private JTextField mySearchField;
    private Tree myResultList;
    private final Alarm myAlarm;
    private final Map<Pair<String, String>, String> myManagedDependenciesMap;

    public MavenArtifactSearchPanel(Project project2, @NlsSafe String initialText, boolean classMode, Listener listener2, MavenArtifactSearchDialog dialog, Map<Pair<String, String>, String> managedDependenciesMap) {
        this.myProject = project2;
        this.myDialog = dialog;
        this.myClassMode = classMode;
        this.myListener = listener2;
        this.myManagedDependenciesMap = managedDependenciesMap;
        this.initComponents(initialText);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, dialog.getDisposable());
    }

    public JTextField getSearchField() {
        return this.mySearchField;
    }

    private void initComponents(@NlsSafe String initialText) {
        this.myResultList = new Tree();
        this.myResultList.setExpandableItemsEnabled(false);
        this.myResultList.getEmptyText().setText(CommonBundle.getLoadingTreeNodeText());
        this.myResultList.setRootVisible(false);
        this.myResultList.setShowsRootHandles(true);
        this.myResultList.setModel(null);
        MyArtifactCellRenderer renderer = this.myClassMode ? new MyClassCellRenderer(this.myResultList) : new MyArtifactCellRenderer(this.myResultList);
        this.myResultList.setCellRenderer((TreeCellRenderer)renderer);
        this.myResultList.setRowHeight(renderer.getPreferredSize().height);
        this.mySearchField = new JTextField(initialText);
        this.mySearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int d;
                if (e.getKeyCode() == 40) {
                    d = 1;
                } else if (e.getKeyCode() == 38) {
                    d = -1;
                } else {
                    return;
                }
                int row = MavenArtifactSearchPanel.this.myResultList.getSelectionModel().getLeadSelectionRow();
                if ((row += d) >= 0 && row < MavenArtifactSearchPanel.this.myResultList.getRowCount()) {
                    MavenArtifactSearchPanel.this.myResultList.setSelectionRow(row);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.mySearchField, "North");
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myResultList);
        pane.setHorizontalScrollBarPolicy(31);
        pane.setVerticalScrollBarPolicy(22);
        this.add((Component)pane, "Center");
        this.mySearchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                MavenArtifactSearchPanel.this.scheduleSearch();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/indices/MavenArtifactSearchPanel$2", "textChanged"));
            }
        });
        this.myResultList.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!MavenArtifactSearchPanel.this.myAlarm.isEmpty()) {
                    return;
                }
                boolean hasSelection = !MavenArtifactSearchPanel.this.myResultList.isSelectionEmpty();
                MavenArtifactSearchPanel.this.myListener.canSelectStateChanged(MavenArtifactSearchPanel.this, hasSelection);
            }
        });
        this.myResultList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && MavenArtifactSearchPanel.this.myResultList.getLastSelectedPathComponent() != null) {
                    MavenArtifactSearchPanel.this.myListener.itemSelected();
                    e.consume();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                Object sel;
                TreePath path2;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((path2 = MavenArtifactSearchPanel.this.myResultList.getPathForLocation(e.getX(), e.getY())) != null && MavenArtifactSearchPanel.this.myResultList.isPathSelected(path2) && (sel = path2.getLastPathComponent()) != null && MavenArtifactSearchPanel.this.myResultList.getModel().isLeaf(sel)) {
                    MavenArtifactSearchPanel.this.myListener.itemSelected();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/indices/MavenArtifactSearchPanel$5", "onDoubleClick"));
            }
        }.installOn((Component)this.myResultList);
    }

    public void scheduleSearch() {
        this.myListener.canSelectStateChanged(this, false);
        this.myResultList.setPaintBusy(true);
        String text = this.mySearchField.getText();
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            try {
                this.doSearch(text);
            }
            catch (Throwable e) {
                MavenLog.LOG.warn(e);
            }
        }, 500);
    }

    private void doSearch(String searchText) {
        MavenSearcher searcher = this.myClassMode ? new MavenClassSearcher() : new MavenArtifactSearcher();
        List result2 = searcher.search(this.myProject, searchText, 1000);
        MyTreeModel model = new MyTreeModel(result2);
        SwingUtilities.invokeLater(() -> {
            if (!this.myDialog.isVisible()) {
                return;
            }
            this.myResultList.getEmptyText().setText(MavenDomBundle.message("maven.search.no.results", new Object[0]));
            if (this.myClassMode) {
                this.myResultList.getEmptyText().appendLine(MavenDomBundle.message("maven.search.no.results.indices.try.update", new Object[0]), SimpleTextAttributes.LINK_BOLD_ATTRIBUTES, e -> ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, MavenRepositoriesConfigurable.class));
            }
            this.myResultList.setModel(model);
            this.myResultList.setSelectionRow(0);
            this.myResultList.setPaintBusy(false);
        });
    }

    @NotNull
    public List<MavenId> getResult() {
        TreePath[] selectionPaths = this.myResultList.getSelectionPaths();
        if (selectionPaths == null) {
            List<MavenId> list = Collections.emptyList();
            if (list == null) {
                MavenArtifactSearchPanel.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<MavenId> result2 = new ArrayList<MavenId>();
        for (TreePath each : selectionPaths) {
            Object sel = each.getLastPathComponent();
            MavenDependencyCompletionItem info = sel instanceof MavenDependencyCompletionItem ? (MavenDependencyCompletionItem)sel : ((MavenArtifactSearchResult)sel).getSearchResults().getItems()[0];
            result2.add(new MavenId(info.getGroupId(), info.getArtifactId(), info.getVersion()));
        }
        ArrayList<MavenId> arrayList = result2;
        if (arrayList == null) {
            MavenArtifactSearchPanel.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/indices/MavenArtifactSearchPanel", "getResult"));
    }

    public static interface Listener {
        public void itemSelected();

        public void canSelectStateChanged(@NotNull MavenArtifactSearchPanel var1, boolean var2);
    }

    private final class MyClassCellRenderer
    extends MyArtifactCellRenderer {
        private MyClassCellRenderer(Tree tree) {
            super(tree);
        }

        @Override
        protected void formatSearchResult(JTree tree, MavenArtifactSearchResult searchResult, boolean selected) {
            MavenClassSearchResult classResult = (MavenClassSearchResult)searchResult;
            MavenDependencyCompletionItem info = searchResult.getSearchResults().getItems()[0];
            this.myLeftComponent.setIcon(AllIcons.Nodes.Class);
            this.myLeftComponent.append(classResult.getClassName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.myLeftComponent.append(" (" + classResult.getPackageName() + ")", this.getGrayAttributes(selected));
            this.appendArtifactInfo(this.myRightComponent, info, selected);
        }
    }

    private class MyArtifactCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected SimpleColoredComponent myLeftComponent = new SimpleColoredComponent();
        protected SimpleColoredComponent myRightComponent = new SimpleColoredComponent();

        private MyArtifactCellRenderer(final Tree tree) {
            this.myLeftComponent.setOpaque(false);
            this.myRightComponent.setOpaque(false);
            this.myLeftComponent.setIconOpaque(false);
            this.myRightComponent.setIconOpaque(false);
            this.add((Component)this.myLeftComponent);
            this.add((Component)this.myRightComponent);
            Font font = EditorFontType.getGlobalPlainFont();
            this.myLeftComponent.setFont(font);
            this.myRightComponent.setFont(font);
            this.setPreferredSize(new Dimension(2000, this.myLeftComponent.getPreferredSize().height));
            this.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(Container parent) {
                    return new Dimension(this.getVisibleWidth(), MyArtifactCellRenderer.this.myLeftComponent.getPreferredSize().height);
                }

                public void layoutContainer(Container parent) {
                    int w = this.getVisibleWidth();
                    Dimension ls = MyArtifactCellRenderer.this.myLeftComponent.getPreferredSize();
                    Dimension rs = MyArtifactCellRenderer.this.myRightComponent.getPreferredSize();
                    int lw = w - rs.width - 10;
                    int rw = rs.width;
                    MyArtifactCellRenderer.this.myLeftComponent.setBounds(0, 0, lw, ls.height);
                    MyArtifactCellRenderer.this.myRightComponent.setBounds(w - rw, 0, rw, rs.height);
                }

                private int getVisibleWidth() {
                    JScrollBar sb;
                    int w = tree.getVisibleRect().width - 10;
                    Insets insets = tree.getInsets();
                    w -= insets.left + insets.right;
                    JScrollPane scrollPane = ComponentUtil.getScrollPane((Component)tree);
                    if (scrollPane != null && (sb = scrollPane.getVerticalScrollBar()) != null) {
                        w -= sb.getWidth();
                    }
                    return w;
                }
            });
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.myLeftComponent.clear();
            this.myRightComponent.clear();
            this.setBackground(RenderingUtil.getBackground((JTree)tree, (boolean)selected));
            this.myLeftComponent.setForeground(selected ? UIUtil.getTreeSelectionForeground((boolean)hasFocus) : null);
            this.myRightComponent.setForeground(selected ? UIUtil.getTreeSelectionForeground((boolean)hasFocus) : null);
            if (value == tree.getModel().getRoot()) {
                this.myLeftComponent.append(MavenProjectBundle.message("maven.search.artifract.results", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else if (value instanceof MavenArtifactSearchResult) {
                this.formatSearchResult(tree, (MavenArtifactSearchResult)value, selected);
            } else if (value instanceof MavenDependencyCompletionItem) {
                MavenDependencyCompletionItem info = (MavenDependencyCompletionItem)value;
                String version2 = info.getVersion();
                Icon icon = MavenDependencyCompletionUtil.getIcon(info.getType());
                String managedVersion = MavenArtifactSearchPanel.this.myManagedDependenciesMap.get(Pair.create((Object)info.getGroupId(), (Object)info.getArtifactId()));
                if (managedVersion != null && managedVersion.equals(version2)) {
                    this.myLeftComponent.setIcon(icon);
                    this.myLeftComponent.append(version2, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    this.myLeftComponent.append(MavenProjectBundle.message("from.dependency.management", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    this.myLeftComponent.setIcon(icon);
                    this.myLeftComponent.append(version2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
            return this;
        }

        protected void formatSearchResult(JTree tree, MavenArtifactSearchResult searchResult, boolean selected) {
            MavenDependencyCompletionItem info = searchResult.getSearchResults().getItems()[0];
            MavenDependencyCompletionItem iconInfo = MavenDependencyCompletionUtil.getMaxIcon(searchResult);
            this.myLeftComponent.setIcon(MavenDependencyCompletionUtil.getIcon(iconInfo.getType()));
            this.appendArtifactInfo(this.myLeftComponent, info, selected);
        }

        protected void appendArtifactInfo(SimpleColoredComponent component, MavenDependencyCompletionItem info, boolean selected) {
            component.append(info.getGroupId() + ":", this.getGrayAttributes(selected));
            component.append(info.getArtifactId(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(":" + info.getVersion(), this.getGrayAttributes(selected));
        }

        protected SimpleTextAttributes getGrayAttributes(boolean selected) {
            return !selected ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
    }

    private static final class MyTreeModel
    implements TreeModel {
        List<? extends MavenArtifactSearchResult> myItems;

        private MyTreeModel(List<? extends MavenArtifactSearchResult> items) {
            this.myItems = items;
        }

        @Override
        public Object getRoot() {
            return this.myItems;
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.getList(parent).get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            List list = this.getList(parent);
            assert (list != null) : parent;
            return list.size();
        }

        public List getList(Object parent) {
            if (parent == this.myItems) {
                return this.myItems;
            }
            if (parent instanceof MavenArtifactSearchResult) {
                return Arrays.asList(((MavenArtifactSearchResult)parent).getSearchResults().getItems());
            }
            return null;
        }

        @Override
        public boolean isLeaf(Object node2) {
            return node2 != this.myItems && (this.getList(node2) == null || this.getChildCount(node2) < 2);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return this.getList(parent).indexOf(child);
        }

        @Override
        public void valueForPathChanged(TreePath path2, Object newValue) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }
}

