/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.build;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.scratch.JavaScratchConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ModuleResourcesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.JpsProjectTaskRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.build.MavenArtifactBuilder;
import org.jetbrains.idea.maven.execution.build.MavenArtifactProperties;
import org.jetbrains.idea.maven.execution.build.MavenArtifactPropertiesProvider;
import org.jetbrains.idea.maven.execution.build.MavenExecutionEnvironmentProvider;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectTaskRunner
extends ProjectTaskRunner {
    public void run(@NotNull Project project2, @NotNull ProjectTaskContext context2, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks) {
        if (project2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(1);
        }
        if (tasks == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(2);
        }
        Map taskMap = JpsProjectTaskRunner.groupBy(tasks);
        MavenProjectTaskRunner.buildModuleFiles(project2, context2, callback, MavenProjectTaskRunner.getFromGroupedMap(taskMap, ModuleFilesBuildTask.class, Collections.emptyList()));
        MavenProjectTaskRunner.buildModules(project2, context2, callback, MavenProjectTaskRunner.getFromGroupedMap(taskMap, ModuleResourcesBuildTask.class, Collections.emptyList()));
        MavenProjectTaskRunner.buildModules(project2, context2, callback, MavenProjectTaskRunner.getFromGroupedMap(taskMap, ModuleBuildTask.class, Collections.emptyList()));
        MavenProjectTaskRunner.buildArtifacts(project2, context2, callback, MavenProjectTaskRunner.getFromGroupedMap(taskMap, ProjectModelBuildTask.class, Collections.emptyList()));
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        if (projectTask == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException("MavenProjectTaskRunner#canRun(ProjectTask)");
    }

    public boolean canRun(@NotNull Project project2, @NotNull ProjectTask projectTask, @Nullable ProjectTaskContext context2) {
        if (project2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(4);
        }
        if (projectTask == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(5);
        }
        if (context2 != null && context2.getRunConfiguration() instanceof JavaScratchConfiguration) {
            return false;
        }
        return this.canRun(project2, projectTask);
    }

    public boolean canRun(@NotNull Project project2, @NotNull ProjectTask projectTask) {
        ProjectModelBuildTask buildTask;
        ProjectModelBuildableElement projectModelBuildableElement;
        if (project2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(6);
        }
        if (projectTask == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(7);
        }
        if (!MavenRunner.getInstance(project2).getSettings().isDelegateBuildToMaven()) {
            return false;
        }
        if (projectTask instanceof ModuleBuildTask) {
            Module module2 = ((ModuleBuildTask)projectTask).getModule();
            return MavenUtil.isMavenModule(module2);
        }
        if (projectTask instanceof ProjectModelBuildTask && (projectModelBuildableElement = (buildTask = (ProjectModelBuildTask)projectTask).getBuildableElement()) instanceof Artifact) {
            Artifact artifact = (Artifact)projectModelBuildableElement;
            MavenArtifactProperties properties = null;
            for (ArtifactPropertiesProvider provider : artifact.getPropertiesProviders()) {
                ArtifactProperties artifactProperties;
                if (!(provider instanceof MavenArtifactPropertiesProvider) || !((artifactProperties = artifact.getProperties(provider)) instanceof MavenArtifactProperties)) continue;
                properties = (MavenArtifactProperties)artifactProperties;
                break;
            }
            if (properties == null || properties.getModuleName() == null) {
                return false;
            }
            Module module3 = ModuleManager.getInstance((Project)project2).findModuleByName(properties.getModuleName());
            if (!MavenUtil.isMavenModule(module3)) {
                return false;
            }
            MavenArtifactBuilder[] mavenArtifactBuilderArray = (MavenArtifactBuilder[])MavenArtifactBuilder.EP_NAME.getExtensions();
            int n = mavenArtifactBuilderArray.length;
            for (int j = 0; j < n; ++j) {
                MavenArtifactBuilder artifactBuilder = mavenArtifactBuilderArray[j];
                if (!artifactBuilder.isApplicable(buildTask)) continue;
                return true;
            }
        }
        if (projectTask instanceof ExecuteRunConfigurationTask) {
            ExecuteRunConfigurationTask task = (ExecuteRunConfigurationTask)projectTask;
            RunProfile runProfile = task.getRunProfile();
            if (runProfile instanceof JavaScratchConfiguration) {
                return false;
            }
            if (runProfile instanceof ModuleBasedConfiguration) {
                RunConfigurationModule module4 = ((ModuleBasedConfiguration)runProfile).getConfigurationModule();
                if (!MavenUtil.isMavenModule(module4.getModule())) {
                    return false;
                }
                for (MavenExecutionEnvironmentProvider environmentProvider : (MavenExecutionEnvironmentProvider[])MavenExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
                    if (!environmentProvider.isApplicable(task)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project2, @NotNull ExecuteRunConfigurationTask task, @Nullable Executor executor) {
        if (project2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(8);
        }
        if (task == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(9);
        }
        for (MavenExecutionEnvironmentProvider environmentProvider : (MavenExecutionEnvironmentProvider[])MavenExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
            if (!environmentProvider.isApplicable(task)) continue;
            return environmentProvider.createExecutionEnvironment(project2, task, executor);
        }
        return null;
    }

    private static <T extends ProjectTask> List<? extends T> getFromGroupedMap(Map<Class<? extends ProjectTask>, List<ProjectTask>> map, Class<T> key, List<? extends T> defaultValue) {
        List<ProjectTask> result2 = map.get(key);
        if (result2 == null) {
            return defaultValue;
        }
        return result2;
    }

    private static void buildModules(@NotNull Project project2, @NotNull ProjectTaskContext context2, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ModuleBuildTask> moduleBuildTasks) {
        if (project2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(10);
        }
        if (context2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(11);
        }
        if (moduleBuildTasks == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(12);
        }
        if (moduleBuildTasks.isEmpty()) {
            return;
        }
        MavenRunner mavenRunner = MavenRunner.getInstance(project2);
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        MavenExplicitProfiles explicitProfiles = mavenProjectsManager.getExplicitProfiles();
        HashMap<MavenProject, List> rootProjectsToModules = new HashMap<MavenProject, List>();
        boolean buildOnlyResources = false;
        for (ModuleBuildTask moduleBuildTask : moduleBuildTasks) {
            MavenProject mavenProject2 = mavenProjectsManager.findProject(moduleBuildTask.getModule());
            if (mavenProject2 == null) continue;
            buildOnlyResources = buildOnlyResources || moduleBuildTask instanceof ModuleResourcesBuildTask;
            MavenProject rootProject = mavenProjectsManager.findRootProject(mavenProject2);
            rootProjectsToModules.computeIfAbsent(rootProject, p -> new ArrayList()).add(mavenProject2);
        }
        boolean clean = moduleBuildTasks.stream().anyMatch(task -> !(task instanceof ModuleFilesBuildTask) && !task.isIncrementalBuild());
        boolean bl = moduleBuildTasks.stream().allMatch(task -> task instanceof ModuleFilesBuildTask);
        boolean includeDependentModules = moduleBuildTasks.stream().anyMatch(ModuleBuildTask::isIncludeDependentModules);
        String goal = MavenProjectTaskRunner.getGoal(buildOnlyResources, bl);
        ArrayList<MavenRunnerParameters> commands = new ArrayList<MavenRunnerParameters>();
        for (Map.Entry entry : rootProjectsToModules.entrySet()) {
            ParametersList parameters = new ParametersList();
            if (clean) {
                parameters.add("clean");
            }
            parameters.add(goal);
            List mavenProjects2 = (List)entry.getValue();
            if (!includeDependentModules) {
                if (mavenProjects2.size() > 1) {
                    parameters.add("--projects");
                    parameters.add(mavenProjects2.stream().map(MavenProject::getMavenId).map(mavenId2 -> mavenId2.getGroupId() + ":" + mavenId2.getArtifactId()).collect(Collectors.joining(",")));
                } else {
                    parameters.add("--non-recursive");
                }
            }
            VirtualFile pomFile = (mavenProjects2.size() > 1 ? (MavenProject)entry.getKey() : (MavenProject)mavenProjects2.get(0)).getFile();
            commands.add(new MavenRunnerParameters(true, pomFile.getParent().getPath(), pomFile.getName(), parameters.getList(), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles()));
        }
        MavenProjectTaskRunner.runBatch(project2, mavenRunner, "Maven Build", commands, context2, callback);
    }

    @NotNull
    private static String getGoal(boolean buildOnlyResources, boolean compileOnly) {
        if (buildOnlyResources) {
            return "resources:resources";
        }
        return compileOnly ? "compile" : "install";
    }

    public static void runBatch(@NotNull Project project2, @NotNull MavenRunner mavenRunner, @NotNull String title, @NotNull List<MavenRunnerParameters> commands, @NotNull ProjectTaskContext context2, final @Nullable ProjectTaskNotification callback) {
        if (project2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(13);
        }
        if (mavenRunner == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(14);
        }
        if (title == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(15);
        }
        if (commands == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(16);
        }
        if (context2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            for (MavenRunnerParameters command : commands) {
                MavenRunConfigurationType.runConfiguration(project2, command, null, null, descriptor2 -> {
                    if (callback == null) {
                        return;
                    }
                    ProcessHandler handler = descriptor2.getProcessHandler();
                    if (handler != null) {
                        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                            public void processTerminated(@NotNull ProcessEvent event) {
                                if (event == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (event.getExitCode() == 0) {
                                    callback.finished(new ProjectTaskResult(false, 0, 0));
                                } else {
                                    callback.finished(new ProjectTaskResult(true, 0, 0));
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/maven/execution/build/MavenProjectTaskRunner$1", "processTerminated"));
                            }
                        });
                    }
                }, true);
            }
        });
    }

    private static void buildModuleFiles(@NotNull Project project2, @NotNull ProjectTaskContext context2, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ModuleFilesBuildTask> moduleFilesBuildTasks) {
        if (project2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(18);
        }
        if (context2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(19);
        }
        if (moduleFilesBuildTasks == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(20);
        }
        MavenProjectTaskRunner.buildModules(project2, context2, callback, moduleFilesBuildTasks);
    }

    private static void buildArtifacts(@NotNull Project project2, @NotNull ProjectTaskContext context2, @Nullable ProjectTaskNotification callback, List<? extends ProjectModelBuildTask> tasks) {
        if (project2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(21);
        }
        if (context2 == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(22);
        }
        for (ProjectModelBuildTask projectModelBuildTask : tasks) {
            if (!(projectModelBuildTask.getBuildableElement() instanceof Artifact)) continue;
            for (MavenArtifactBuilder artifactBuilder : (MavenArtifactBuilder[])MavenArtifactBuilder.EP_NAME.getExtensions()) {
                if (!artifactBuilder.isApplicable(projectModelBuildTask)) continue;
                artifactBuilder.build(project2, projectModelBuildTask, context2, callback);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleBuildTasks";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenRunner";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilesBuildTasks";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/execution/build/MavenProjectTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createExecutionEnvironment";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModules";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "runBatch";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModuleFiles";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "buildArtifacts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

