/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dsl;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependencyRepository;
import com.intellij.externalSystem.ExternalDependencyModificator;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomElement;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomRepositories;
import org.jetbrains.idea.maven.dom.model.MavenDomRepository;
import org.jetbrains.idea.maven.dsl.MavenDependencyModificatorKt;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001LB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J&\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170\"2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010'\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J.\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010*0)2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001dH\u0002J\u0018\u0010-\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u000e2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\"H\u0002J\u0010\u00103\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u00104\u001a\u0002052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u00106\u001a\u0004\u0018\u00010\u001d2\b\u00107\u001a\u0004\u0018\u00010\u001d2\b\u00108\u001a\u0004\u0018\u00010\u001dH\u0002J \u00109\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u0013H\u0016J<\u0010<\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020*2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?2\b\u0010A\u001a\u0004\u0018\u00010\u001d2\b\u0010B\u001a\u0004\u0018\u00010\u001dH\u0002J4\u0010C\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?2\b\u0010A\u001a\u0004\u0018\u00010\u001d2\b\u0010B\u001a\u0004\u0018\u00010\u001dH\u0002JL\u0010D\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020*2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u001d0G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001d0G2\b\u0010I\u001a\u0004\u0018\u00010\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J:\u0010D\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020*2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u001d0G2\b\u0010J\u001a\u0004\u0018\u00010\u001d2\b\u0010I\u001a\u0004\u0018\u00010\u001dH\u0002J&\u0010K\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u001d0G2\u0006\u0010I\u001a\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/jetbrains/idea/maven/dsl/MavenDependencyModificator;", "Lcom/intellij/externalSystem/ExternalDependencyModificator;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myDocumentManager", "Lcom/intellij/psi/PsiDocumentManager;", "myProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "addDependenciesTagIfNotExists", "", "psiFile", "Lcom/intellij/psi/xml/XmlFile;", "model", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "addDependency", "module", "Lcom/intellij/openapi/module/Module;", "descriptor", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "addRepositoriesTagIfNotExists", "addRepository", "repository", "Lcom/intellij/buildsystem/model/unified/UnifiedDependencyRepository;", "addTagIfNotExists", "element", "Lorg/jetbrains/idea/maven/dom/MavenDomElement;", "elementsBefore", "", "", "tagName", "parentElement", "siblingsBeforeTag", "declaredDependencies", "", "Lcom/intellij/buildsystem/model/DeclaredDependency;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "declaredRepositories", "deleteRepository", "getDependenciesModel", "Lkotlin/Pair;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "groupId", "artifactId", "removeDependency", "retrieveDependencyVersions", "project", "domModel", "dependencies", "Lorg/jetbrains/idea/maven/dsl/MavenDependencyModificator$DeclaredDependencyData;", "saveFile", "supports", "", "toMavenScope", "scope", "managedScope", "updateDependency", "oldDescriptor", "newDescriptor", "updateManagedDependency", "managedDependency", "oldMavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "newMavenId", "oldScope", "newScope", "updatePlainDependency", "updateValueIfNeeded", "domDependency", "domValue", "Lcom/intellij/util/xml/GenericDomValue;", "managedDomValue", "newValue", "oldValue", "updateVariableOrValue", "DeclaredDependencyData", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenDependencyModificator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenDependencyModificator.kt\norg/jetbrains/idea/maven/dsl/MavenDependencyModificator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,447:1\n1#2:448\n1#2:469\n427#3:449\n1747#4,3:450\n533#4,6:453\n533#4,6:472\n766#4:479\n857#4,2:480\n1490#4:482\n1520#4,3:483\n1523#4,3:493\n1549#4:496\n1620#4,3:497\n1549#4:500\n1620#4,3:501\n766#4:504\n857#4,2:505\n1549#4:507\n1620#4,3:508\n11383#5,9:459\n13309#5:468\n13310#5:470\n11392#5:471\n26#6:478\n372#7,7:486\n*S KotlinDebug\n*F\n+ 1 MavenDependencyModificator.kt\norg/jetbrains/idea/maven/dsl/MavenDependencyModificator\n*L\n118#1:469\n94#1:449\n95#1:450,3\n97#1:453,6\n119#1:472,6\n415#1:479\n415#1:480,2\n415#1:482\n415#1:483,3\n415#1:493,3\n439#1:496\n439#1:497,3\n382#1:500\n382#1:501,3\n391#1:504\n391#1:505,2\n392#1:507\n392#1:508,3\n118#1:459,9\n118#1:468\n118#1:470\n118#1:471\n351#1:478\n415#1:486,7\n*E\n"})
public final class MavenDependencyModificator
implements ExternalDependencyModificator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final MavenProjectsManager myProjectsManager;
    @NotNull
    private final PsiDocumentManager myDocumentManager;

    public MavenDependencyModificator(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"getInstance(...)");
        this.myProjectsManager = mavenProjectsManager;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)psiDocumentManager, (String)"getInstance(...)");
        this.myDocumentManager = psiDocumentManager;
    }

    private final void addDependenciesTagIfNotExists(XmlFile psiFile, MavenDomProjectModel model) {
        MavenDomDependencies mavenDomDependencies = model.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"getDependencies(...)");
        this.addTagIfNotExists(psiFile, (MavenDomElement)mavenDomDependencies, MavenDependencyModificatorKt.getElementsBeforeDependencies());
    }

    private final void addRepositoriesTagIfNotExists(XmlFile psiFile, MavenDomProjectModel model) {
        MavenDomRepositories mavenDomRepositories = model.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepositories, (String)"getRepositories(...)");
        this.addTagIfNotExists(psiFile, (MavenDomElement)mavenDomRepositories, MavenDependencyModificatorKt.getElementsBeforeRepositories());
    }

    private final void addTagIfNotExists(String tagName, MavenDomElement parentElement, Set<String> siblingsBeforeTag) {
        Object v3;
        XmlTag parentTag;
        block7: {
            boolean bl;
            List xmlTagSiblings;
            block6: {
                XmlTag xmlTag = parentElement.getXmlTag();
                if (xmlTag == null) {
                    boolean $i$a$-checkNotNull-MavenDependencyModificator$addTagIfNotExists$parentTag$22 = false;
                    String $i$a$-checkNotNull-MavenDependencyModificator$addTagIfNotExists$parentTag$22 = "Parent element " + parentElement.getXmlElementName() + " must be an XML tag";
                    throw new IllegalStateException($i$a$-checkNotNull-MavenDependencyModificator$addTagIfNotExists$parentTag$22.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"checkNotNull(...)");
                parentTag = xmlTag;
                PsiElement $this$childrenOfType$iv = (PsiElement)parentTag;
                boolean $i$f$childrenOfType = false;
                List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, XmlTag.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                xmlTagSiblings = list;
                Iterable $this$any$iv = xmlTagSiblings;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        XmlTag it = (XmlTag)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)tagName)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
            List $this$lastOrNull$iv = xmlTagSiblings;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                XmlTag it = (XmlTag)element$iv;
                boolean bl3 = false;
                if (!siblingsBeforeTag.contains(it.getName())) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        XmlTag siblingToInsertAfterOrNull = v3;
        XmlTag child = parentTag.createChildTag(tagName, parentTag.getNamespace(), null, false);
        parentTag.addAfter((PsiElement)child, (PsiElement)siblingToInsertAfterOrNull);
    }

    /*
     * WARNING - void declaration
     */
    private final void addTagIfNotExists(XmlFile psiFile, MavenDomElement element, Set<String> elementsBefore) {
        Object v1;
        XmlTag rootTag;
        block5: {
            void $this$lastOrNull$iv;
            void $this$mapNotNullTo$iv$iv;
            List $this$mapNotNull$iv;
            if (element.exists()) {
                return;
            }
            rootTag = psiFile.getRootTag();
            if (rootTag == null) {
                element.ensureTagExists();
                return;
            }
            PsiElement[] psiElementArray = rootTag.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            PsiElement[] children = psiElementArray;
            if (children.length == 0) {
                element.ensureTagExists();
                return;
            }
            PsiElement[] psiElementArray2 = children;
            boolean $i$f$mapNotNull = false;
            void var9_8 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                XmlTag it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof XmlTag ? (XmlTag)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                XmlTag it = (XmlTag)element$iv;
                boolean bl = false;
                if (!elementsBefore.contains(it.getName())) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        XmlTag lastOrNull = v1;
        XmlTag child = rootTag.createChildTag(element.getXmlElementName(), rootTag.getNamespace(), null, false);
        rootTag.addAfter((PsiElement)child, (PsiElement)lastOrNull);
    }

    private final Pair<MavenDomProjectModel, MavenDomDependency> getDependenciesModel(Module module2, String groupId, String artifactId) {
        MavenProject mavenProject2 = this.myProjectsManager.findProject(module2);
        if (mavenProject2 == null) {
            Object[] objectArray = new Object[]{module2.getName()};
            throw new IllegalArgumentException(MavenProjectBundle.message("maven.project.not.found.for", objectArray));
        }
        MavenProject project2 = mavenProject2;
        Object object = ReadAction.compute(() -> MavenDependencyModificator.getDependenciesModel$lambda$5(this, project2, module2, groupId, artifactId));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Pair)object;
    }

    public boolean supports(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return this.myProjectsManager.isMavenizedModule(module2);
    }

    public void addDependency(@NotNull Module module2, @NotNull UnifiedDependency descriptor2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2.getCoordinates().getGroupId() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (descriptor2.getCoordinates().getVersion() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (descriptor2.getCoordinates().getArtifactId() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        MavenId mavenId2 = MavenDependencyModificatorKt.access$toMavenId(descriptor2.getCoordinates());
        String string = mavenId2.getGroupId();
        Intrinsics.checkNotNull((Object)string);
        String string2 = mavenId2.getArtifactId();
        Intrinsics.checkNotNull((Object)string2);
        Pair<MavenDomProjectModel, MavenDomDependency> pair = this.getDependenciesModel(module2, string, string2);
        MavenDomProjectModel model = (MavenDomProjectModel)pair.component1();
        MavenDomDependency managedDependency = (MavenDomDependency)pair.component2();
        XmlFile xmlFile = DomUtil.getFile((DomElement)model);
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile psiFile = xmlFile;
        PsiFile[] psiFileArray = new PsiFile[]{psiFile};
        WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])psiFileArray).compute(() -> MavenDependencyModificator.addDependency$lambda$7(this, psiFile, model, mavenId2, descriptor2, managedDependency));
    }

    public void updateDependency(@NotNull Module module2, @NotNull UnifiedDependency oldDescriptor, @NotNull UnifiedDependency newDescriptor) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)oldDescriptor, (String)"oldDescriptor");
        Intrinsics.checkNotNullParameter((Object)newDescriptor, (String)"newDescriptor");
        if (newDescriptor.getCoordinates().getGroupId() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (newDescriptor.getCoordinates().getVersion() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (newDescriptor.getCoordinates().getArtifactId() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        MavenId oldMavenId = MavenDependencyModificatorKt.access$toMavenId(oldDescriptor.getCoordinates());
        MavenId newMavenId = MavenDependencyModificatorKt.access$toMavenId(newDescriptor.getCoordinates());
        Pair pair = (Pair)ReadAction.compute(() -> MavenDependencyModificator.updateDependency$lambda$8(this, module2, oldMavenId));
        MavenDomProjectModel model = (MavenDomProjectModel)pair.component1();
        MavenDomDependency managedDependency = (MavenDomDependency)pair.component2();
        XmlFile xmlFile = DomUtil.getFile((DomElement)model);
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile psiFile = xmlFile;
        PsiFile[] psiFileArray = new PsiFile[]{psiFile};
        WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])psiFileArray).compute(() -> MavenDependencyModificator.updateDependency$lambda$9(managedDependency, this, model, oldMavenId, newMavenId, oldDescriptor, newDescriptor, psiFile));
    }

    private final void updateManagedDependency(MavenDomProjectModel model, MavenDomDependency managedDependency, MavenId oldMavenId, MavenId newMavenId, String oldScope, String newScope) {
        Object v2;
        block2: {
            List<MavenDomDependency> list = model.getDependencies().getDependencies();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDependencies(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                MavenDomDependency dep = (MavenDomDependency)t;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)dep.getArtifactId().getStringValue(), (Object)oldMavenId.getArtifactId()) && Intrinsics.areEqual((Object)dep.getGroupId().getStringValue(), (Object)oldMavenId.getGroupId()) && (!dep.getVersion().exists() || Intrinsics.areEqual((Object)dep.getVersion().getStringValue(), (Object)oldMavenId.getVersion())) && (!dep.getScope().exists() || Intrinsics.areEqual((Object)dep.getScope().getStringValue(), (Object)oldScope));
                if (!bl2) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        MavenDomDependency mavenDomDependency = v2;
        if (mavenDomDependency == null) {
            return;
        }
        MavenDomDependency domDependency = mavenDomDependency;
        GenericDomValue<String> genericDomValue = domDependency.getVersion();
        Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"getVersion(...)");
        GenericDomValue<String> genericDomValue2 = managedDependency.getVersion();
        Intrinsics.checkNotNullExpressionValue(genericDomValue2, (String)"getVersion(...)");
        this.updateValueIfNeeded(model, domDependency, genericDomValue, genericDomValue2, newMavenId.getVersion(), MavenDependencyModificatorKt.getElementsBeforeDependencyVersion());
        GenericDomValue<String> genericDomValue3 = domDependency.getScope();
        Intrinsics.checkNotNullExpressionValue(genericDomValue3, (String)"getScope(...)");
        GenericDomValue<String> genericDomValue4 = managedDependency.getScope();
        Intrinsics.checkNotNullExpressionValue(genericDomValue4, (String)"getScope(...)");
        this.updateValueIfNeeded(model, domDependency, genericDomValue3, genericDomValue4, newScope, MavenDependencyModificatorKt.getElementsBeforeDependencyScope());
    }

    private final void updateValueIfNeeded(MavenDomProjectModel model, MavenDomDependency domDependency, GenericDomValue<String> domValue, GenericDomValue<String> managedDomValue, String newValue, Set<String> siblingsBeforeTag) {
        if (newValue == null) {
            XmlTag xmlTag = domValue.getXmlTag();
            if (xmlTag != null) {
                xmlTag.delete();
            }
        } else if (!Intrinsics.areEqual((Object)managedDomValue.getStringValue(), (Object)newValue)) {
            String string = domValue.getXmlElementName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getXmlElementName(...)");
            this.addTagIfNotExists(string, (MavenDomElement)domDependency, siblingsBeforeTag);
            this.updateVariableOrValue(model, domValue, newValue);
        }
    }

    private final void updatePlainDependency(MavenDomProjectModel model, MavenId oldMavenId, MavenId newMavenId, String oldScope, String newScope) {
        Object v2;
        block2: {
            List<MavenDomDependency> list = model.getDependencies().getDependencies();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDependencies(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                MavenDomDependency dep = (MavenDomDependency)t;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)dep.getArtifactId().getStringValue(), (Object)oldMavenId.getArtifactId()) && Intrinsics.areEqual((Object)dep.getGroupId().getStringValue(), (Object)oldMavenId.getGroupId()) && Intrinsics.areEqual((Object)dep.getVersion().getStringValue(), (Object)oldMavenId.getVersion()) && Intrinsics.areEqual((Object)dep.getScope().getStringValue(), (Object)oldScope);
                if (!bl2) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        MavenDomDependency mavenDomDependency = v2;
        if (mavenDomDependency == null) {
            return;
        }
        MavenDomDependency domDependency = mavenDomDependency;
        GenericDomValue genericDomValue = domDependency.getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"getArtifactId(...)");
        this.updateValueIfNeeded(model, domDependency, (GenericDomValue<String>)genericDomValue, oldMavenId.getArtifactId(), newMavenId.getArtifactId());
        GenericDomValue genericDomValue2 = domDependency.getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue2, (String)"getGroupId(...)");
        this.updateValueIfNeeded(model, domDependency, (GenericDomValue<String>)genericDomValue2, oldMavenId.getGroupId(), newMavenId.getGroupId());
        GenericDomValue<String> genericDomValue3 = domDependency.getVersion();
        Intrinsics.checkNotNullExpressionValue(genericDomValue3, (String)"getVersion(...)");
        this.updateValueIfNeeded(model, domDependency, genericDomValue3, oldMavenId.getVersion(), newMavenId.getVersion());
        GenericDomValue<String> genericDomValue4 = domDependency.getScope();
        Intrinsics.checkNotNullExpressionValue(genericDomValue4, (String)"getScope(...)");
        this.updateValueIfNeeded(model, domDependency, genericDomValue4, oldScope, newScope);
    }

    private final void updateValueIfNeeded(MavenDomProjectModel model, MavenDomDependency domDependency, GenericDomValue<String> domValue, String oldValue, String newValue) {
        block2: {
            block1: {
                if (Intrinsics.areEqual((Object)oldValue, (Object)newValue)) {
                    return;
                }
                if (newValue == null) break block1;
                String string = domValue.getXmlElementName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getXmlElementName(...)");
                this.addTagIfNotExists(string, (MavenDomElement)domDependency, MavenDependencyModificatorKt.getElementsBeforeDependencyScope());
                this.updateVariableOrValue(model, domValue, newValue);
                break block2;
            }
            XmlTag xmlTag = domDependency.getScope().getXmlTag();
            if (xmlTag == null) break block2;
            xmlTag.delete();
        }
    }

    public void removeDependency(@NotNull Module module2, @NotNull UnifiedDependency descriptor2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2.getCoordinates().getGroupId() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (descriptor2.getCoordinates().getVersion() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        MavenId mavenId2 = MavenDependencyModificatorKt.access$toMavenId(descriptor2.getCoordinates());
        String string = mavenId2.getGroupId();
        Intrinsics.checkNotNull((Object)string);
        String string2 = mavenId2.getArtifactId();
        Intrinsics.checkNotNull((Object)string2);
        MavenDomProjectModel model = (MavenDomProjectModel)this.getDependenciesModel(module2, string, string2).component1();
        XmlFile xmlFile = DomUtil.getFile((DomElement)model);
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile psiFile = xmlFile;
        PsiFile[] psiFileArray = new PsiFile[]{psiFile};
        WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])psiFileArray).compute(() -> MavenDependencyModificator.removeDependency$lambda$12(model, mavenId2, this, psiFile));
    }

    public void addRepository(@NotNull Module module2, @NotNull UnifiedDependencyRepository repository) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        MavenProject mavenProject2 = this.myProjectsManager.findProject(module2);
        if (mavenProject2 == null) {
            Object[] objectArray = new Object[]{module2.getName()};
            throw new IllegalArgumentException(MavenProjectBundle.message("maven.project.not.found.for", objectArray));
        }
        MavenProject project2 = mavenProject2;
        MavenDomProjectModel model = (MavenDomProjectModel)ReadAction.compute(() -> MavenDependencyModificator.addRepository$lambda$13(this, project2, module2));
        for (MavenDomRepository repo : model.getRepositories().getRepositories()) {
            String string = repo.getUrl().getStringValue();
            String string2 = repository.getUrl();
            if (!Intrinsics.areEqual((Object)(string != null ? MavenDependencyModificatorKt.access$trimLastSlash(string) : null), (Object)(string2 != null ? MavenDependencyModificatorKt.access$trimLastSlash(string2) : null))) continue;
            return;
        }
        XmlFile xmlFile = DomUtil.getFile((DomElement)model);
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile psiFile = xmlFile;
        PsiFile[] psiFileArray = new PsiFile[]{psiFile};
        WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])psiFileArray).compute(() -> MavenDependencyModificator.addRepository$lambda$17(this, psiFile, model, repository));
    }

    public void deleteRepository(@NotNull Module module2, @NotNull UnifiedDependencyRepository repository) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        MavenProject mavenProject2 = this.myProjectsManager.findProject(module2);
        if (mavenProject2 == null) {
            Object[] objectArray = new Object[]{module2.getName()};
            throw new IllegalArgumentException(MavenProjectBundle.message("maven.project.not.found.for", objectArray));
        }
        MavenProject project2 = mavenProject2;
        Pair pair = (Pair)ReadAction.compute(() -> MavenDependencyModificator.deleteRepository$lambda$18(this, project2, module2, repository));
        MavenDomProjectModel model = (MavenDomProjectModel)pair.component1();
        MavenDomRepository repo = (MavenDomRepository)pair.component2();
        if (repo == null) {
            return;
        }
        XmlFile xmlFile = DomUtil.getFile((DomElement)repo);
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile psiFile = xmlFile;
        PsiFile[] psiFileArray = new PsiFile[]{psiFile};
        WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])psiFileArray).compute(() -> MavenDependencyModificator.deleteRepository$lambda$19(repo, model, this, psiFile));
    }

    private final void saveFile(XmlFile psiFile) {
        Document document = this.myDocumentManager.getDocument((PsiFile)psiFile);
        if (document == null) {
            Object[] objectArray = new Object[]{psiFile};
            throw new IllegalStateException(MavenProjectBundle.message("maven.model.error", objectArray));
        }
        Document document2 = document;
        this.myDocumentManager.doPostponedOperationsAndUnblockDocument(document2);
        FileDocumentManager.getInstance().saveDocument(document2);
    }

    private final void updateVariableOrValue(MavenDomProjectModel model, GenericDomValue<String> domValue, String newValue) {
        String rawText;
        String string = domValue.getRawText();
        String string2 = rawText = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        if (rawText != null && StringsKt.startsWith$default((String)rawText, (String)"${", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)rawText, (String)"}", (boolean)false, (int)2, null)) {
            XmlTag[] xmlTagArray;
            XmlTag[] xmlTagArray2;
            String string3 = rawText.substring(2, rawText.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String propertyName = string3;
            XmlTag xmlTag = model.getProperties().getXmlTag();
            Object object = xmlTagArray2 = xmlTag != null ? xmlTag.getSubTags() : null;
            if (xmlTagArray2 == null) {
                boolean $i$f$emptyArray = false;
                xmlTagArray = new XmlTag[]{};
            } else {
                xmlTagArray = xmlTagArray2;
            }
            for (XmlTag subTag : xmlTagArray) {
                if (!Intrinsics.areEqual((Object)subTag.getName(), (Object)propertyName)) continue;
                subTag.getValue().setText(newValue);
                return;
            }
        } else {
            domValue.setStringValue(newValue);
        }
    }

    private final String toMavenScope(String scope, String managedScope) {
        if (managedScope == null) {
            return scope;
        }
        if (Intrinsics.areEqual((Object)scope, (Object)managedScope)) {
            return null;
        }
        return scope;
    }

    @NotNull
    public List<DeclaredDependency> declaredDependencies(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        MavenProject mavenProject2 = MavenProjectsManager.getInstance(module2.getProject()).findProject(module2);
        if (mavenProject2 == null) {
            return CollectionsKt.emptyList();
        }
        MavenProject project2 = mavenProject2;
        VirtualFile virtualFile = project2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        List list = this.declaredDependencies(virtualFile);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final List<DeclaredDependency> declaredDependencies(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (List)ReadAction.compute(() -> MavenDependencyModificator.declaredDependencies$lambda$24(this, file));
    }

    /*
     * WARNING - void declaration
     */
    private final void retrieveDependencyVersions(Project project2, MavenDomProjectModel domModel, List<DeclaredDependencyData> dependencies) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        DeclaredDependencyData it;
        void $this$filterTo$iv$iv;
        if (dependencies.isEmpty()) {
            return;
        }
        Iterable $this$filter$iv = dependencies;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DeclaredDependencyData)element$iv$iv;
            boolean bl = false;
            if (!(it.getVersion() == null && it.getArtifactId() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it2;
            Object object;
            String key$iv$iv;
            it = (DeclaredDependencyData)element$iv$iv;
            boolean $i$a$-groupBy-MavenDependencyModificator$retrieveDependencyVersions$dependencyMap$42 = false;
            Intrinsics.checkNotNull((Object)it.getArtifactId());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            DeclaredDependencyData $i$a$-groupBy-MavenDependencyModificator$retrieveDependencyVersions$dependencyMap$42 = (DeclaredDependencyData)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(it2);
        }
        Object dependencyMap = destination$iv$iv;
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(domModel, (Processor<? super MavenDomDependency>)((Processor)arg_0 -> MavenDependencyModificator.retrieveDependencyVersions$lambda$28((Function1)new Function1<MavenDomDependency, Boolean>((Map<String, ? extends List<DeclaredDependencyData>>)dependencyMap, dependencies){
            final /* synthetic */ Map<String, List<DeclaredDependencyData>> $dependencyMap;
            final /* synthetic */ List<DeclaredDependencyData> $dependencies;
            {
                this.$dependencyMap = $dependencyMap;
                this.$dependencies = $dependencies;
                super(1);
            }

            @NotNull
            public final Boolean invoke(MavenDomDependency mavenDomDependency) {
                boolean bl;
                block5: {
                    String groupId = mavenDomDependency.getGroupId().getStringValue();
                    String artifactId = mavenDomDependency.getArtifactId().getStringValue();
                    String version2 = mavenDomDependency.getVersion().getStringValue();
                    CharSequence charSequence = version2;
                    if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && this.$dependencyMap.containsKey(artifactId)) {
                        List<DeclaredDependencyData> list = this.$dependencyMap.get(artifactId);
                        Intrinsics.checkNotNull(list);
                        for (DeclaredDependencyData dependency : list) {
                            if (!Intrinsics.areEqual((Object)groupId, (Object)dependency.getGroupId())) continue;
                            dependency.setVersion(version2);
                        }
                    }
                    Iterable $this$any$iv = this.$dependencies;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            DeclaredDependencyData it = (DeclaredDependencyData)element$iv;
                            boolean bl2 = false;
                            if (!(it.getVersion() == null)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                return !bl;
            }
        }, arg_0)), project2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<UnifiedDependencyRepository> declaredRepositories(@NotNull Module module2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        MavenProject mavenProject2 = MavenProjectsManager.getInstance(module2.getProject()).findProject(module2);
        if (mavenProject2 == null) {
            return CollectionsKt.emptyList();
        }
        MavenProject project2 = mavenProject2;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel(this.myProject, project2.getFile());
        if (mavenDomProjectModel == null) {
            return CollectionsKt.emptyList();
        }
        MavenDomProjectModel model = mavenDomProjectModel;
        List<MavenDomRepository> list = model.getRepositories().getRepositories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MavenDomRepository mavenDomRepository = (MavenDomRepository)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getId().getStringValue();
            String string2 = it.getName().getStringValue();
            String string3 = it.getUrl().getStringValue();
            if (string3 == null) {
                string3 = "";
            }
            collection.add(new UnifiedDependencyRepository(string, string2, string3));
        }
        return (List)destination$iv$iv;
    }

    private static final Pair getDependenciesModel$lambda$5(MavenDependencyModificator this$0, MavenProject $project, Module $module, String $groupId, String $artifactId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)$groupId, (String)"$groupId");
        Intrinsics.checkNotNullParameter((Object)$artifactId, (String)"$artifactId");
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel(this$0.myProject, $project.getFile());
        if (mavenDomProjectModel == null) {
            Object[] objectArray = new Object[]{$module.getName()};
            throw new IllegalStateException(MavenProjectBundle.message("maven.model.error", objectArray));
        }
        MavenDomProjectModel model = mavenDomProjectModel;
        MavenDomDependency managedDependency = MavenDependencyCompletionUtil.findManagedDependency(model, this$0.myProject, $groupId, $artifactId);
        return new Pair((Object)model, (Object)managedDependency);
    }

    private static final Unit addDependency$lambda$7(MavenDependencyModificator this$0, XmlFile $psiFile, MavenDomProjectModel $model, MavenId $mavenId, UnifiedDependency $descriptor, MavenDomDependency $managedDependency) {
        GenericDomValue<String> genericDomValue;
        String scope;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$psiFile, (String)"$psiFile");
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)$mavenId, (String)"$mavenId");
        Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
        this$0.addDependenciesTagIfNotExists($psiFile, $model);
        MavenDomDependency mavenDomDependency = MavenDomUtil.createDomDependency($model, null);
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependency, (String)"createDomDependency(...)");
        MavenDomDependency dependency = mavenDomDependency;
        dependency.getGroupId().setStringValue($mavenId.getGroupId());
        dependency.getArtifactId().setStringValue($mavenId.getArtifactId());
        String string = scope = this$0.toMavenScope($descriptor.getScope(), (genericDomValue = $managedDependency) != null && (genericDomValue = genericDomValue.getScope()) != null ? genericDomValue.getStringValue() : null);
        if (string != null) {
            String it = string;
            boolean bl = false;
            dependency.getScope().setStringValue(it);
        }
        if ($managedDependency == null || !Intrinsics.areEqual((Object)$managedDependency.getVersion().getStringValue(), (Object)$mavenId.getVersion())) {
            String string2 = $mavenId.getVersion();
            Intrinsics.checkNotNull((Object)string2);
            if (((CharSequence)string2).length() > 0) {
                dependency.getVersion().setStringValue($mavenId.getVersion());
            }
        }
        this$0.saveFile($psiFile);
        return Unit.INSTANCE;
    }

    private static final Pair updateDependency$lambda$8(MavenDependencyModificator this$0, Module $module, MavenId $oldMavenId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)$oldMavenId, (String)"$oldMavenId");
        String string = $oldMavenId.getGroupId();
        Intrinsics.checkNotNull((Object)string);
        String string2 = $oldMavenId.getArtifactId();
        Intrinsics.checkNotNull((Object)string2);
        return this$0.getDependenciesModel($module, string, string2);
    }

    private static final Unit updateDependency$lambda$9(MavenDomDependency $managedDependency, MavenDependencyModificator this$0, MavenDomProjectModel $model, MavenId $oldMavenId, MavenId $newMavenId, UnifiedDependency $oldDescriptor, UnifiedDependency $newDescriptor, XmlFile $psiFile) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)$oldMavenId, (String)"$oldMavenId");
        Intrinsics.checkNotNullParameter((Object)$newMavenId, (String)"$newMavenId");
        Intrinsics.checkNotNullParameter((Object)$oldDescriptor, (String)"$oldDescriptor");
        Intrinsics.checkNotNullParameter((Object)$newDescriptor, (String)"$newDescriptor");
        Intrinsics.checkNotNullParameter((Object)$psiFile, (String)"$psiFile");
        if ($managedDependency != null) {
            this$0.updateManagedDependency($model, $managedDependency, $oldMavenId, $newMavenId, $oldDescriptor.getScope(), $newDescriptor.getScope());
        } else {
            this$0.updatePlainDependency($model, $oldMavenId, $newMavenId, $oldDescriptor.getScope(), $newDescriptor.getScope());
        }
        this$0.saveFile($psiFile);
        return Unit.INSTANCE;
    }

    private static final Unit removeDependency$lambda$12(MavenDomProjectModel $model, MavenId $mavenId, MavenDependencyModificator this$0, XmlFile $psiFile) {
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)$mavenId, (String)"$mavenId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$psiFile, (String)"$psiFile");
        for (MavenDomDependency dep : $model.getDependencies().getDependencies()) {
            if (!Intrinsics.areEqual((Object)dep.getArtifactId().getStringValue(), (Object)$mavenId.getArtifactId()) || !Intrinsics.areEqual((Object)dep.getGroupId().getStringValue(), (Object)$mavenId.getGroupId())) continue;
            XmlTag xmlTag = dep.getXmlTag();
            if (xmlTag == null) continue;
            xmlTag.delete();
        }
        if ($model.getDependencies().getDependencies().isEmpty()) {
            XmlTag xmlTag = $model.getDependencies().getXmlTag();
            if (xmlTag != null) {
                xmlTag.delete();
            }
        }
        this$0.saveFile($psiFile);
        return Unit.INSTANCE;
    }

    private static final MavenDomProjectModel addRepository$lambda$13(MavenDependencyModificator this$0, MavenProject $project, Module $module) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel(this$0.myProject, $project.getFile());
        if (mavenDomProjectModel == null) {
            Object[] objectArray = new Object[]{$module.getName()};
            throw new IllegalStateException(MavenProjectBundle.message("maven.model.error", objectArray));
        }
        return mavenDomProjectModel;
    }

    private static final Unit addRepository$lambda$17(MavenDependencyModificator this$0, XmlFile $psiFile, MavenDomProjectModel $model, UnifiedDependencyRepository $repository) {
        String it;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$psiFile, (String)"$psiFile");
        Intrinsics.checkNotNullParameter((Object)$repository, (String)"$repository");
        Intrinsics.checkNotNull((Object)$model);
        this$0.addRepositoriesTagIfNotExists($psiFile, $model);
        MavenDomRepository repoTag = $model.getRepositories().addRepository();
        String string = $repository.getId();
        if (string != null) {
            it = string;
            boolean bl = false;
            repoTag.getId().setStringValue(it);
        }
        String string2 = $repository.getName();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            repoTag.getName().setStringValue(it);
        }
        String it2 = $repository.getUrl();
        boolean bl = false;
        repoTag.getUrl().setStringValue(it2);
        this$0.saveFile($psiFile);
        return Unit.INSTANCE;
    }

    private static final Pair deleteRepository$lambda$18(MavenDependencyModificator this$0, MavenProject $project, Module $module, UnifiedDependencyRepository $repository) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)$repository, (String)"$repository");
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel(this$0.myProject, $project.getFile());
        if (mavenDomProjectModel == null) {
            Object[] objectArray = new Object[]{$module.getName()};
            throw new IllegalStateException(MavenProjectBundle.message("maven.model.error", objectArray));
        }
        MavenDomProjectModel model = mavenDomProjectModel;
        for (MavenDomRepository repo : model.getRepositories().getRepositories()) {
            String string = repo.getUrl().getStringValue();
            String string2 = $repository.getUrl();
            if (!Intrinsics.areEqual((Object)(string != null ? MavenDependencyModificatorKt.access$trimLastSlash(string) : null), (Object)(string2 != null ? MavenDependencyModificatorKt.access$trimLastSlash(string2) : null))) continue;
            return new Pair((Object)model, (Object)repo);
        }
        return null;
    }

    private static final Unit deleteRepository$lambda$19(MavenDomRepository $repo, MavenDomProjectModel $model, MavenDependencyModificator this$0, XmlFile $psiFile) {
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$psiFile, (String)"$psiFile");
        XmlTag xmlTag = $repo.getXmlTag();
        if (xmlTag != null) {
            xmlTag.delete();
        }
        if ($model.getRepositories().getRepositories().isEmpty()) {
            XmlTag xmlTag2 = $model.getRepositories().getXmlTag();
            if (xmlTag2 != null) {
                xmlTag2.delete();
            }
        }
        this$0.saveFile($psiFile);
        return Unit.INSTANCE;
    }

    private static final Object declaredDependencies$lambda$24$lambda$21$lambda$20(MavenDomDependency $mavenDomDependency, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CommonDataKeys.PSI_ELEMENT.is(it) ? $mavenDomDependency.getXmlElement() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List declaredDependencies$lambda$24(MavenDependencyModificator this$0, VirtualFile $file) {
        DeclaredDependencyData it;
        Iterable $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel(this$0.myProject, $file);
        if (mavenDomProjectModel == null) {
            return null;
        }
        MavenDomProjectModel model = mavenDomProjectModel;
        List<MavenDomDependency> list = model.getDependencies().getDependencies();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDependencies(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void mavenDomDependency;
            MavenDomDependency mavenDomDependency2 = (MavenDomDependency)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new DeclaredDependencyData(mavenDomDependency.getGroupId().getStringValue(), mavenDomDependency.getArtifactId().getStringValue(), mavenDomDependency.getVersion().getStringValue(), mavenDomDependency.getScope().getStringValue(), arg_0 -> MavenDependencyModificator.declaredDependencies$lambda$24$lambda$21$lambda$20((MavenDomDependency)mavenDomDependency, arg_0)));
        }
        List dependencies = (List)destination$iv$iv;
        $this$map$iv = dependencies;
        MavenDomProjectModel mavenDomProjectModel2 = model;
        Project project2 = this$0.myProject;
        object = this$0;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DeclaredDependencyData)element$iv$iv;
            boolean bl = false;
            if (!(it.getVersion() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        super.retrieveDependencyVersions(project2, mavenDomProjectModel2, list2);
        $this$map$iv = dependencies;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void data2;
            it = (DeclaredDependencyData)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new DeclaredDependency(data2.getGroupId(), data2.getArtifactId(), data2.getVersion(), data2.getConfiguration(), data2.getDataContext()));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean retrieveDependencyVersions$lambda$28(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/dsl/MavenDependencyModificator$DeclaredDependencyData;", "", "groupId", "", "artifactId", "version", "configuration", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/actionSystem/DataContext;)V", "getArtifactId", "()Ljava/lang/String;", "getConfiguration", "getDataContext", "()Lcom/intellij/openapi/actionSystem/DataContext;", "getGroupId", "getVersion", "setVersion", "(Ljava/lang/String;)V", "intellij.maven"})
    private static final class DeclaredDependencyData {
        @Nullable
        private final String groupId;
        @Nullable
        private final String artifactId;
        @Nullable
        private String version;
        @Nullable
        private final String configuration;
        @NotNull
        private final DataContext dataContext;

        public DeclaredDependencyData(@Nullable String groupId, @Nullable String artifactId, @Nullable String version2, @Nullable String configuration, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version2;
            this.configuration = configuration;
            this.dataContext = dataContext;
        }

        @Nullable
        public final String getGroupId() {
            return this.groupId;
        }

        @Nullable
        public final String getArtifactId() {
            return this.artifactId;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(@Nullable String string) {
            this.version = string;
        }

        @Nullable
        public final String getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public final DataContext getDataContext() {
            return this.dataContext;
        }
    }
}

